/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.NBTBuilder;

public class NBTHelper {
    public static final Collector<NBTBase, NBTTagList, NBTTagList> NBTLIST_COLLECTOR = Collector.of(NBTTagList::new, NBTTagList::func_74742_a, (l1, l2) -> {
        l2.forEach(arg_0 -> ((NBTTagList)l1).func_74742_a(arg_0));
        return l1;
    }, new Collector.Characteristics[0]);

    private NBTHelper() {
    }

    public static IBlockState getBlockState(NBTTagCompound blockStateTag) {
        return BlockTools.getBlockState((Tuple<String, Map<String, String>>)new Tuple((Object)blockStateTag.func_74779_i("blockName"), NBTHelper.getStateProperties(blockStateTag.func_74775_l("properties"))), Block::func_176223_P, BlockTools::updateProperty);
    }

    private static Map<String, String> getStateProperties(NBTTagCompound propertiesTag) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String key : propertiesTag.func_150296_c()) {
            if (!propertiesTag.func_150297_b(key, 8)) continue;
            ret.put(key, propertiesTag.func_74779_i(key));
        }
        return ret;
    }

    public static NBTTagCompound getBlockStateTag(IBlockState state) {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74778_a("blockName", state.func_177230_c().getRegistryName().toString());
        if (!state.func_177228_b().isEmpty()) {
            ret.func_74782_a("properties", (NBTBase)NBTHelper.getStatePropertiesTag(state.func_177228_b()));
        }
        return ret;
    }

    private static NBTTagCompound getStatePropertiesTag(ImmutableMap<IProperty<?>, Comparable<?>> properties) {
        NBTTagCompound propertiesTag = new NBTTagCompound();
        for (Map.Entry property : properties.entrySet()) {
            propertiesTag.func_74778_a(((IProperty)property.getKey()).func_177701_a(), NBTHelper.serializeValue((IProperty)property.getKey(), (Comparable)property.getValue()));
        }
        return propertiesTag;
    }

    private static <T extends Comparable<T>> String serializeValue(IProperty<T> property, Comparable<?> valueString) {
        return property.func_177702_a(valueString);
    }

    public static <T> Set<T> getSet(NBTTagList tagList, Function<NBTBase, T> getElement) {
        HashSet<T> ret = new HashSet<T>();
        for (NBTBase tag : tagList) {
            ret.add(getElement.apply(tag));
        }
        return ret;
    }

    public static <T> List<T> getList(NBTTagList tagList, Function<NBTBase, T> getElement) {
        ArrayList<T> ret = new ArrayList<T>();
        for (NBTBase tag : tagList) {
            ret.add(getElement.apply(tag));
        }
        return ret;
    }

    public static Set<String> getStringSet(NBTTagList tagList) {
        return NBTHelper.getSet(tagList, tag -> ((NBTTagString)tag).func_150285_a_());
    }

    public static <T> NBTTagList getTagList(Collection<T> collection, Function<T, NBTBase> serializeElement) {
        NBTTagList ret = new NBTTagList();
        collection.forEach(element -> ret.func_74742_a((NBTBase)serializeElement.apply(element)));
        return ret;
    }

    public static NBTTagList getNBTStringList(Collection<String> strings) {
        NBTTagList ret = new NBTTagList();
        strings.forEach(str -> ret.func_74742_a((NBTBase)new NBTTagString(str)));
        return ret;
    }

    public static NBTTagList getNBTUniqueIdList(Collection<UUID> uuids) {
        NBTTagList ret = new NBTTagList();
        uuids.forEach(uuid -> ret.func_74742_a((NBTBase)new NBTBuilder().setUniqueId("uuid", (UUID)uuid).build()));
        return ret;
    }

    public static Set<UUID> getUniqueIdSet(NBTBase tag) {
        return NBTHelper.getSet(NBTHelper.getTagList(tag, 10), element -> ((NBTTagCompound)element).func_186857_a("uuid"));
    }

    private static NBTTagList getTagList(NBTBase tag, int type) {
        try {
            if (tag.func_74732_a() == 9) {
                NBTTagList nbttaglist = (NBTTagList)tag;
                if (!nbttaglist.func_82582_d() && nbttaglist.func_150303_d() != type) {
                    return new NBTTagList();
                }
                return nbttaglist;
            }
        }
        catch (ClassCastException classcastexception) {
            AncientWarfareCore.LOG.error("Error casting tag to taglist: {}", (Object)tag);
        }
        return new NBTTagList();
    }

    public static NBTTagCompound writeBlockPosToNBT(NBTTagCompound tag, BlockPos pos) {
        tag.func_74768_a("x", pos.func_177958_n());
        tag.func_74768_a("y", pos.func_177956_o());
        tag.func_74768_a("z", pos.func_177952_p());
        return tag;
    }

    public static BlockPos readBlockPosFromNBT(NBTTagCompound tag) {
        return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public static <K, V> Map<K, V> getMap(NBTTagList list, Function<NBTTagCompound, K> getKey, Function<NBTTagCompound, V> getValue) {
        HashMap<K, V> ret = new HashMap<K, V>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            ret.put(getKey.apply(tag), getValue.apply(tag));
        }
        return ret;
    }

    public static <K, V> NBTTagList mapToCompoundList(Map<K, V> map, BiConsumer<NBTTagCompound, K> setKeyTag, BiConsumer<NBTTagCompound, V> setValueTag) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            NBTTagCompound nbtEntry = new NBTTagCompound();
            setKeyTag.accept(nbtEntry, entry.getKey());
            setValueTag.accept(nbtEntry, entry.getValue());
            list.func_74742_a((NBTBase)nbtEntry);
        }
        return list;
    }

    public static void writeSerializablesTo(NBTTagCompound tag, String key, List<? extends INBTSerializable> elements) {
        NBTTagList list = new NBTTagList();
        for (INBTSerializable iNBTSerializable : elements) {
            list.func_74742_a(iNBTSerializable.serializeNBT());
        }
        tag.func_74782_a(key, (NBTBase)list);
    }

    public static <T extends INBTSerializable<NBTTagCompound>> List<T> deserializeListFrom(NBTTagCompound tag, String key, Supplier<T> supplier) {
        NBTTagList tags = tag.func_150295_c(key, 10);
        ArrayList<INBTSerializable> list = new ArrayList<INBTSerializable>();
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            INBTSerializable element = (INBTSerializable)supplier.get();
            element.deserializeNBT((NBTBase)tags.func_150305_b(i));
            list.add(element);
        }
        return list;
    }
}

