/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    private FileUtils() {
    }

    public static void findFiles(File source, String base, @Nullable BiConsumer<Path, Path> processor) {
        FileUtils.findFiles(source, base, null, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void findFiles(File source, String base, @Nullable Function<Path, Boolean> preprocessor, @Nullable BiConsumer<Path, Path> processor) {
        FileSystem fs;
        block16: {
            Iterator itr;
            Path root;
            block15: {
                Boolean cont;
                block14: {
                    fs = null;
                    root = null;
                    if (source.isFile()) {
                        try {
                            fs = FileSystems.newFileSystem(source.toPath(), null);
                            root = fs.getPath("/" + base, new String[0]);
                        }
                        catch (IOException e) {
                            AncientWarfareCore.LOG.error("Error loading FileSystem from jar: ", (Throwable)e);
                            IOUtils.closeQuietly((Closeable)fs);
                            return;
                        }
                    } else if (source.isDirectory()) {
                        root = source.toPath().resolve(base);
                    }
                    if (root != null && Files.exists(root, new LinkOption[0])) break block14;
                    IOUtils.closeQuietly((Closeable)fs);
                    return;
                }
                if (preprocessor == null || (cont = preprocessor.apply(root)) != null && cont.booleanValue()) break block15;
                IOUtils.closeQuietly((Closeable)fs);
                return;
            }
            if (processor == null) break block16;
            try {
                itr = Files.walk(root, new FileVisitOption[0]).iterator();
            }
            catch (IOException e) {
                AncientWarfareCore.LOG.error("Error iterating filesystem for: {}", (Object)root, (Object)e);
                IOUtils.closeQuietly((Closeable)fs);
                return;
            }
            try {
                while (itr.hasNext()) {
                    processor.accept(root, (Path)itr.next());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fs);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)fs);
    }

    public static void exportToFile(File exportFile, List<String> rows) {
        if (!exportFile.exists() && FileUtils.createFile(exportFile)) {
            return;
        }
        try (FileWriter fileWriter = new FileWriter(exportFile);
             BufferedWriter writer = new BufferedWriter(fileWriter);){
            for (String row : rows) {
                writer.write(row);
                writer.newLine();
            }
        }
        catch (IOException e) {
            AncientWarfareCore.LOG.error("Error exporting file: " + exportFile.getAbsolutePath(), (Throwable)e);
        }
    }

    private static boolean createFile(File exportFile) {
        try {
            if (!exportFile.getParentFile().exists() && !exportFile.getParentFile().mkdirs()) {
                AncientWarfareCore.LOG.error("Unable to create folders for file : " + exportFile.getAbsolutePath());
                return true;
            }
            if (!exportFile.createNewFile()) {
                AncientWarfareCore.LOG.error("Unable to open new file : " + exportFile.getAbsolutePath());
                return true;
            }
        }
        catch (IOException e) {
            AncientWarfareCore.LOG.error("Error opening file : " + exportFile.getAbsolutePath(), (Throwable)e);
            return true;
        }
        return false;
    }
}

