/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.owner;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.owner.ITeamViewer;
import net.shadowmage.ancientwarfare.core.owner.ScoreboardTeamViewer;

public class TeamViewerRegistry {
    private static final Set<ITeamViewer> teamViewers = new HashSet<ITeamViewer>();

    private TeamViewerRegistry() {
    }

    public static void registerTeamViewer(ITeamViewer teamViewer) {
        teamViewers.add(teamViewer);
    }

    public static boolean areTeamMates(World world, UUID player1, UUID player2, String playerName1, String playerName2) {
        for (ITeamViewer teamViewer : teamViewers) {
            if (!teamViewer.areTeamMates(world, player1, player2, playerName1, playerName2)) continue;
            return true;
        }
        return false;
    }

    public static boolean areFriendly(World world, UUID player1, @Nullable UUID player2, String playerName1, String playerName2) {
        for (ITeamViewer teamViewer : teamViewers) {
            if (!teamViewer.areFriendly(world, player1, player2, playerName1, playerName2)) continue;
            return true;
        }
        return false;
    }

    public static Set<ResourceLocation> getPlayerTeamNames(World world, UUID playerUUID, String playerName) {
        HashSet<ResourceLocation> ret = new HashSet<ResourceLocation>();
        teamViewers.forEach(v -> ret.addAll(v.getPlayerTeamNames(world, playerUUID, playerName)));
        return ret;
    }

    public static Set<String> getRegularlyCheckedViewerNames() {
        HashSet<String> ret = new HashSet<String>();
        for (ITeamViewer teamViewer : teamViewers) {
            if (!teamViewer.needsRegularMembershipRecheck()) continue;
            ret.add(teamViewer.getName());
        }
        return ret;
    }

    public static Set<ResourceLocation> getRegularlyCheckedPlayerTeamNames(World world, UUID playerUUID, String playerName) {
        HashSet<ResourceLocation> ret = new HashSet<ResourceLocation>();
        for (ITeamViewer teamViewer : teamViewers) {
            if (!teamViewer.needsRegularMembershipRecheck()) continue;
            ret.addAll(teamViewer.getPlayerTeamNames(world, playerUUID, playerName));
        }
        return ret;
    }

    static {
        teamViewers.add(new ScoreboardTeamViewer());
    }
}

