/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketBase;

public class PacketGui
extends PacketBase {
    private NBTTagCompound packetData;

    public PacketGui(NBTTagCompound packetData) {
        this.packetData = packetData;
    }

    public PacketGui() {
        this.packetData = new NBTTagCompound();
    }

    public void setOpenGui(int id, int x, int y, int z) {
        this.packetData.func_74757_a("openGui", true);
        this.packetData.func_74768_a("id", id);
        this.packetData.func_74768_a("x", x);
        this.packetData.func_74768_a("y", y);
        this.packetData.func_74768_a("z", z);
    }

    public void setTag(String key, NBTTagCompound tag) {
        this.packetData.func_74782_a(key, (NBTBase)tag);
    }

    public void setData(NBTTagCompound tag) {
        this.packetData = tag;
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        if (this.packetData != null) {
            try (ByteBufOutputStream outputStream = new ByteBufOutputStream(data);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.packetData, (OutputStream)outputStream);
            }
            catch (IOException e) {
                AncientWarfareCore.LOG.error("Error writing gui packet data: ", (Throwable)e);
            }
        }
    }

    @Override
    protected void readFromStream(ByteBuf data) {
        try (ByteBufInputStream inputStream = new ByteBufInputStream(data);){
            this.packetData = CompressedStreamTools.func_74796_a((InputStream)inputStream);
        }
        catch (IOException e) {
            AncientWarfareCore.LOG.error("Error reading gui packet data: ", (Throwable)e);
        }
    }

    @Override
    protected void execute(EntityPlayer player) {
        if (this.packetData.func_74764_b("openGui")) {
            NetworkHandler.INSTANCE.openGui(player, this.packetData.func_74762_e("id"), this.packetData.func_74762_e("x"), this.packetData.func_74762_e("y"), this.packetData.func_74762_e("z"));
        } else if (player.field_71070_bA instanceof ContainerBase) {
            ((ContainerBase)player.field_71070_bA).onPacketData(this.packetData);
        } else {
            AncientWarfareCore.LOG.error("Invalid target found when processing GUI/Container packet : {} packet: {}", (Object)player.field_71070_bA, (Object)this.packetData);
        }
    }
}

