/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.item;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.GuiInfoTool;
import net.shadowmage.ancientwarfare.core.item.ItemBaseCore;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.ItemTools;

public class ItemInfoTool
extends ItemBaseCore {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).create();

    public ItemInfoTool() {
        super("info_tool");
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(this.getMode(stack).getDisplayName() + " mode");
    }

    private void printSimpleMessage(EntityPlayer player, IBlockState state) {
        player.func_145747_a((ITextComponent)new TextComponentString("Block name: " + state.func_177230_c().getRegistryName().toString()));
        if (!state.func_177228_b().isEmpty()) {
            player.func_145747_a((ITextComponent)new TextComponentString("Properties:"));
            for (Map.Entry prop : state.func_177228_b().entrySet()) {
                player.func_145747_a((ITextComponent)new TextComponentString(((IProperty)prop.getKey()).func_177701_a() + " : " + ((Comparable)prop.getValue()).toString()));
            }
        }
    }

    private void printJSON(EntityPlayer player, IBlockState state) {
        String json = BlockTools.serializeToJson(state).toString();
        this.printAndCopyToClipboard(player, json);
    }

    public void printItemInfo(EntityPlayer player, ItemStack infoTool, ItemStack stack) {
        Mode mode = this.getMode(infoTool);
        switch (mode) {
            case INFO: {
                this.printSimpleMessage(player, stack);
                break;
            }
            case JSON: {
                this.printJSON(player, stack);
                break;
            }
            case LOOT_ENTRY: {
                this.printLootEntryJSON(player, stack);
            }
        }
    }

    private void printSimpleMessage(EntityPlayer player, ItemStack stack) {
        player.func_145747_a((ITextComponent)new TextComponentString("Item name: " + stack.func_77973_b().getRegistryName().toString()));
        player.func_145747_a((ITextComponent)new TextComponentString("Meta: " + stack.func_77960_j()));
        if (stack.func_77942_o()) {
            player.func_145747_a((ITextComponent)new TextComponentString("NBT: " + stack.func_77978_p().toString()));
        }
    }

    private void printJSON(EntityPlayer player, ItemStack stack) {
        String json = ItemTools.serializeToJson(stack).toString();
        this.printAndCopyToClipboard(player, json);
    }

    private void printAndCopyToClipboard(EntityPlayer player, String json) {
        StringSelection stringSelection = new StringSelection(json);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
        player.func_145747_a((ITextComponent)new TextComponentString(json));
        player.func_145747_a((ITextComponent)new TextComponentString("Copied to clipboard"));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return super.func_77659_a(world, player, hand);
        }
        RayTraceResult hit = this.func_77621_a(world, player, true);
        if (hit != null && hit.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState state = world.func_180495_p(hit.func_178782_a());
            Mode mode = this.getMode(player.func_184586_b(hand));
            switch (mode) {
                case INFO: {
                    this.printSimpleMessage(player, state);
                    break;
                }
                case JSON: {
                    this.printJSON(player, state);
                    break;
                }
                case LOOT_ENTRY: {
                    this.printLootEntryJSON(player, state, hit, world);
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        if (player.func_70093_af()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)this.cycleMode(player.func_184586_b(hand)));
        }
        NetworkHandler.INSTANCE.openGui(player, 57);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private void printLootEntryJSON(EntityPlayer player, IBlockState state, RayTraceResult hit, World world) {
        this.printLootEntryJSON(player, state.func_177230_c().getPickBlock(state, hit, world, hit.func_178782_a(), player));
    }

    private void printLootEntryJSON(EntityPlayer player, ItemStack stack) {
        ArrayList<Object> functions = new ArrayList<Object>();
        functions.add(new SetCount(new LootCondition[0], new RandomValueRange(1.0f)));
        if (stack.func_77942_o()) {
            functions.add(new SetNBT(new LootCondition[0], stack.func_77978_p()));
        }
        if (stack.func_77984_f()) {
            functions.add(new SetDamage(new LootCondition[0], new RandomValueRange((float)stack.func_77952_i())));
        } else if (stack.func_77960_j() > 0) {
            functions.add(new SetMetadata(new LootCondition[0], new RandomValueRange((float)stack.func_77960_j())));
        }
        LootEntryItem lootEntry = new LootEntryItem(stack.func_77973_b(), 1, 0, functions.toArray(new LootFunction[0]), new LootCondition[0], stack.func_77973_b().getRegistryName().toString());
        JsonObject json = GSON.toJsonTree((Object)lootEntry).getAsJsonObject();
        json.remove("quality");
        json.remove("entryName");
        this.printAndCopyToClipboard(player, GSON.toJson((JsonElement)json));
    }

    private ItemStack cycleMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("mode", this.getMode(stack).cycle().name().toLowerCase());
        return stack;
    }

    private Mode getMode(ItemStack stack) {
        if (stack.func_77942_o()) {
            return Mode.fromString(stack.func_77978_p().func_74779_i("mode"));
        }
        return Mode.INFO;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        super.registerClient();
        NetworkHandler.registerGui(57, GuiInfoTool.class);
    }

    static enum Mode {
        INFO("Info"),
        JSON("JSON"),
        LOOT_ENTRY("Loot Entry");

        private String displayName;
        private static final Map<String, Mode> NAME_MODE_MAP;

        private Mode(String displayName) {
            this.displayName = displayName;
        }

        public Mode cycle() {
            switch (this) {
                case INFO: {
                    return JSON;
                }
                case JSON: {
                    return LOOT_ENTRY;
                }
                case LOOT_ENTRY: {
                    return INFO;
                }
            }
            return INFO;
        }

        public static Mode fromString(String mode) {
            return NAME_MODE_MAP.getOrDefault(mode.toLowerCase(), INFO);
        }

        public String getDisplayName() {
            return this.displayName;
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Mode mode : Mode.values()) {
                builder.put((Object)mode.name().toLowerCase(), (Object)mode);
            }
            NAME_MODE_MAP = builder.build();
        }
    }
}

