/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.manual.elements;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.gui.manual.GuiManual;
import net.shadowmage.ancientwarfare.core.gui.manual.IElementWrapperCreator;
import net.shadowmage.ancientwarfare.core.gui.manual.elements.BaseElementWrapper;
import net.shadowmage.ancientwarfare.core.manual.ImageElement;
import net.shadowmage.ancientwarfare.core.util.TextureUtils;

public class ImageElementWrapper
extends BaseElementWrapper<ImageElement> {
    private static final int BOTTOM_PADDING = 4;
    private final ResourceLocation texture = TextureUtils.getTextureLocation("registry/manual/" + ((ImageElement)this.getElement()).getPath().replaceFirst("^/", ""));

    public ImageElementWrapper(GuiManual gui, int topLeftY, int width, int height, ImageElement element) {
        super(gui, 0, topLeftY, width, height, element);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        super.render(mouseX, mouseY, partialTick);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        int textureWidth = ((ImageElement)this.getElement()).getWidth();
        int textureHeight = ((ImageElement)this.getElement()).getHeight();
        float scale = ImageElementWrapper.getScale(this.width, textureWidth);
        int scaledWidth = (int)(scale * (float)textureWidth);
        int padding = Math.min(0, (this.width - scaledWidth) / 2);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Gui.func_152125_a((int)(this.renderX + padding), (int)this.renderY, (float)0.0f, (float)0.0f, (int)textureWidth, (int)textureHeight, (int)scaledWidth, (int)((int)((float)textureHeight * scale)), (float)textureWidth, (float)textureHeight);
    }

    private static float getScale(int width, int textureWidth) {
        return width < textureWidth ? (float)width / (float)textureWidth : 1.0f;
    }

    public static class Creator
    implements IElementWrapperCreator<ImageElement> {
        @Override
        public List<BaseElementWrapper<ImageElement>> construct(GuiManual gui, int topLeftY, int width, int remainingPageHeight, int emptyPageHeight, ImageElement element) {
            int scaledHeight = (int)(ImageElementWrapper.getScale(width, element.getWidth()) * (float)element.getHeight());
            return ImmutableList.of((Object)new ImageElementWrapper(gui, remainingPageHeight < scaledHeight ? 0 : topLeftY, width, scaledHeight + 4, element));
        }
    }
}

