/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.manual.elements;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;
import net.shadowmage.ancientwarfare.core.gui.manual.GuiManual;
import net.shadowmage.ancientwarfare.core.gui.manual.IElementWrapperCreator;
import net.shadowmage.ancientwarfare.core.gui.manual.elements.BaseElementWrapper;
import net.shadowmage.ancientwarfare.core.manual.HeadingElement;
import net.shadowmage.ancientwarfare.core.proxy.ClientProxy;

public class HeadingElementWrapper
extends BaseElementWrapper<HeadingElement> {
    private static final int TOP_PADDING = 3;
    private static final int BOTTOM_PADDING = 3;

    public HeadingElementWrapper(GuiManual gui, int topLeftY, int width, int height, HeadingElement element) {
        super(gui, 0, topLeftY, width, height, element);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        super.render(mouseX, mouseY, partialTick);
        TextFormatting prefix = ((HeadingElement)this.getElement()).getLevel() == 1 ? TextFormatting.BOLD : TextFormatting.UNDERLINE;
        ClientProxy.getUnicodeFontRenderer().func_78279_b(prefix + ((HeadingElement)this.getElement()).getText() + TextFormatting.RESET, this.renderX, this.renderY + 3, this.width, 0);
    }

    @Override
    public int getHeight() {
        return super.getHeight() + 3 + 3;
    }

    @Override
    public boolean shouldKeepWithNext() {
        return true;
    }

    public static class Creator
    implements IElementWrapperCreator<HeadingElement> {
        @Override
        public List<BaseElementWrapper<HeadingElement>> construct(GuiManual gui, int topLeftY, int width, int remainingPageHeight, int emptyPageHeight, HeadingElement element) {
            int textHeight = ClientProxy.getUnicodeFontRenderer().func_78267_b(element.getText(), width);
            return ImmutableList.of((Object)new HeadingElementWrapper(gui, topLeftY, width, textHeight + 3 + 3, element));
        }
    }
}

