/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.manual;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.manual.GuiManual;
import net.shadowmage.ancientwarfare.core.gui.manual.IElementWrapperCreator;
import net.shadowmage.ancientwarfare.core.gui.manual.elements.BaseElementWrapper;
import net.shadowmage.ancientwarfare.core.gui.manual.elements.HeadingElementWrapper;
import net.shadowmage.ancientwarfare.core.gui.manual.elements.ImageElementWrapper;
import net.shadowmage.ancientwarfare.core.gui.manual.elements.ItemElementWrapper;
import net.shadowmage.ancientwarfare.core.gui.manual.elements.TableOfContentsWrapper;
import net.shadowmage.ancientwarfare.core.gui.manual.elements.TextElementWrapper;
import net.shadowmage.ancientwarfare.core.manual.HeadingElement;
import net.shadowmage.ancientwarfare.core.manual.IContentElement;
import net.shadowmage.ancientwarfare.core.manual.ImageElement;
import net.shadowmage.ancientwarfare.core.manual.ItemElement;
import net.shadowmage.ancientwarfare.core.manual.TableOfContentsElement;
import net.shadowmage.ancientwarfare.core.manual.TextElement;

@SideOnly(value=Side.CLIENT)
public class ElementWrapperFactory {
    private static final Set<ElementWrapperMapping> MAPPINGS = ImmutableSet.of(new ElementWrapperMapping(TextElement.class, new TextElementWrapper.Creator()), new ElementWrapperMapping(HeadingElement.class, new HeadingElementWrapper.Creator()), new ElementWrapperMapping(TableOfContentsElement.class, new TableOfContentsWrapper.Creator()), new ElementWrapperMapping(ImageElement.class, new ImageElementWrapper.Creator()), new ElementWrapperMapping(ItemElement.class, new ItemElementWrapper.Creator()));

    private ElementWrapperFactory() {
    }

    public static <T extends IContentElement> List<BaseElementWrapper<T>> create(GuiManual gui, int topLeftY, int width, int remainingPageHeight, int emptyPageHeight, T element) {
        return MAPPINGS.stream().filter(m -> m.matches(element)).findFirst().map(m -> m.construct(gui, topLeftY, width, remainingPageHeight, emptyPageHeight, element)).orElse(Collections.emptyList());
    }

    public static List<List<BaseElementWrapper>> getPagedWrappedContent(GuiManual gui, List<IContentElement> elements, int width, int pageHeight) {
        ArrayList<List<BaseElementWrapper>> pagedWrappers = new ArrayList<List<BaseElementWrapper>>();
        int currentY = 0;
        List<BaseElementWrapper> currentPageWrappers = ElementWrapperFactory.addNewPage(pagedWrappers);
        ArrayList<Tuple<IContentElement, List<BaseElementWrapper<IContentElement>>>> keepTogether = new ArrayList<Tuple<IContentElement, List<BaseElementWrapper<IContentElement>>>>();
        for (IContentElement element : elements) {
            List<BaseElementWrapper<IContentElement>> pageElements = ElementWrapperFactory.create(gui, currentY, width, pageHeight - currentY, pageHeight, element);
            if (!pageElements.isEmpty() && pageElements.get(0).shouldKeepWithNext()) {
                keepTogether.add((Tuple<IContentElement, List<BaseElementWrapper<IContentElement>>>)new Tuple((Object)element, pageElements));
                currentY += pageElements.get(0).getHeight();
                continue;
            }
            if (!keepTogether.isEmpty()) {
                pageElements = ElementWrapperFactory.addAllToKeepAndClearCurrent(keepTogether, element, pageElements);
                currentY = ElementWrapperFactory.addKeepToCurrentElements(gui, width, pageHeight, keepTogether, pageElements);
                keepTogether.clear();
            }
            for (BaseElementWrapper<IContentElement> wrapper : pageElements) {
                if (!currentPageWrappers.isEmpty() && wrapper.getTopLeftY() == 0) {
                    currentPageWrappers = ElementWrapperFactory.addNewPage(pagedWrappers);
                    currentY = 0;
                }
                currentPageWrappers.add(wrapper);
                currentY += wrapper.getHeight();
            }
        }
        return pagedWrappers;
    }

    private static int addKeepToCurrentElements(GuiManual gui, int width, int pageHeight, List<Tuple<IContentElement, List<BaseElementWrapper<IContentElement>>>> keepTogether, List<BaseElementWrapper<IContentElement>> pageElements) {
        int currentY;
        boolean recalculateY;
        boolean bl = recalculateY = !ElementWrapperFactory.areOnTheSamePage(keepTogether);
        if (recalculateY) {
            currentY = ElementWrapperFactory.recalculateYPositions(gui, width, pageHeight, keepTogether, pageElements);
        } else {
            keepTogether.stream().map(Tuple::func_76340_b).forEach(pageElements::addAll);
            currentY = pageElements.get(0).getTopLeftY();
        }
        return currentY;
    }

    private static List<BaseElementWrapper<IContentElement>> addAllToKeepAndClearCurrent(List<Tuple<IContentElement, List<BaseElementWrapper<IContentElement>>>> keepTogether, IContentElement element, List<BaseElementWrapper<IContentElement>> pageElements) {
        keepTogether.add((Tuple<IContentElement, List<BaseElementWrapper<IContentElement>>>)new Tuple((Object)element, (Object)ImmutableList.copyOf(pageElements)));
        return new ArrayList<BaseElementWrapper<IContentElement>>();
    }

    private static int recalculateYPositions(GuiManual gui, int width, int pageHeight, List<Tuple<IContentElement, List<BaseElementWrapper<IContentElement>>>> keepTogether, List<BaseElementWrapper<IContentElement>> pageElements) {
        int updatedY = 0;
        for (Tuple<IContentElement, List<BaseElementWrapper<IContentElement>>> el : keepTogether) {
            List<BaseElementWrapper<IContentElement>> els = ElementWrapperFactory.create(gui, updatedY, width, pageHeight - updatedY, pageHeight, (IContentElement)el.func_76341_a());
            if (!els.isEmpty()) {
                updatedY += els.get(els.size() - 1).getHeight();
            }
            pageElements.addAll(els);
        }
        return updatedY;
    }

    private static boolean areOnTheSamePage(List<Tuple<IContentElement, List<BaseElementWrapper<IContentElement>>>> keepTogether) {
        int currentY = 0;
        for (Tuple<IContentElement, List<BaseElementWrapper<IContentElement>>> element : keepTogether) {
            List wrappers = (List)element.func_76340_b();
            if (wrappers.isEmpty()) continue;
            if (((BaseElementWrapper)wrappers.get(0)).getTopLeftY() < currentY) {
                return false;
            }
            if (!((BaseElementWrapper)wrappers.get(0)).shouldKeepWithNext()) {
                return true;
            }
            currentY = ((BaseElementWrapper)wrappers.get(0)).getTopLeftY();
        }
        return true;
    }

    private static List<BaseElementWrapper> addNewPage(List<List<BaseElementWrapper>> pagedWrappers) {
        ArrayList<BaseElementWrapper> currentPageWrappers = new ArrayList<BaseElementWrapper>();
        pagedWrappers.add(currentPageWrappers);
        return currentPageWrappers;
    }

    private static class ElementWrapperMapping<T extends IContentElement> {
        private final Class<T> elementClass;
        private final IElementWrapperCreator<T> creator;

        private ElementWrapperMapping(Class<T> elementClass, IElementWrapperCreator<T> creator) {
            this.elementClass = elementClass;
            this.creator = creator;
        }

        public boolean matches(IContentElement element) {
            return this.elementClass.isInstance(element);
        }

        public List<BaseElementWrapper<T>> construct(GuiManual gui, int topLeftY, int width, int remainingPageHeight, int emptyPageHeight, T element) {
            return this.creator.construct(gui, topLeftY, width, remainingPageHeight, emptyPageHeight, element);
        }
    }
}

