/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class Tooltip {
    private List<GuiElement> children = new ArrayList<GuiElement>();
    int width;
    int height;

    public Tooltip(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void renderTooltip(int mouseX, int mouseY, float partialTick) {
        int screenWidth = Minecraft.func_71410_x().field_71443_c;
        int screenHeight = Minecraft.func_71410_x().field_71440_d;
        if (mouseX + this.width > screenWidth) {
            mouseX -= 28 + this.width;
        }
        if (mouseY + this.height + 6 > screenHeight) {
            mouseY = screenHeight - this.height - 6;
        }
        Tooltip.pushViewport((mouseX += 12) - 4, mouseY - 4, this.width + 8, this.height + 8);
        for (GuiElement element : this.children) {
            element.updateGuiPosition(mouseX, mouseY);
        }
        GlStateManager.func_179097_i();
        GlStateManager.func_179140_f();
        GlStateManager.func_179101_C();
        this.drawBackground(mouseX, mouseY);
        RenderHelper.func_74518_a();
        for (GuiElement element : this.children) {
            element.render(-1000, -1000, partialTick);
        }
        Tooltip.disableViewport();
    }

    public final void addTooltipElement(GuiElement element) {
        if (this.width < element.width) {
            this.width = element.width + 2;
        }
        if (this.height < element.height) {
            this.height = element.height + 2;
        }
        this.children.add(element);
    }

    private void drawBackground(int mouseX, int mouseY) {
        int color1 = -267386864;
        this.drawGradientRect(mouseX - 3, mouseY - 4, mouseX + this.width + 3, mouseY - 3, color1, color1);
        this.drawGradientRect(mouseX - 3, mouseY + this.height + 3, mouseX + this.width + 3, mouseY + this.height + 4, color1, color1);
        this.drawGradientRect(mouseX - 3, mouseY - 3, mouseX + this.width + 3, mouseY + this.height + 3, color1, color1);
        this.drawGradientRect(mouseX - 4, mouseY - 3, mouseX - 3, mouseY + this.height + 3, color1, color1);
        this.drawGradientRect(mouseX + this.width + 3, mouseY - 3, mouseX + this.width + 4, mouseY + this.height + 3, color1, color1);
        int color2 = 0x505000FF;
        int color3 = (color2 & 0xFEFEFE) >> 1 | color2 & 0xFF000000;
        this.drawGradientRect(mouseX - 3, mouseY - 3 + 1, mouseX - 3 + 1, mouseY + this.height + 3 - 1, color2, color3);
        this.drawGradientRect(mouseX + this.width + 2, mouseY - 3 + 1, mouseX + this.width + 3, mouseY + this.height + 3 - 1, color2, color3);
        this.drawGradientRect(mouseX - 3, mouseY - 3, mouseX + this.width + 3, mouseY - 3 + 1, color2, color2);
        this.drawGradientRect(mouseX - 3, mouseY + this.height + 2, mouseX + this.width + 3, mouseY + this.height + 3, color3, color3);
    }

    private void drawGradientRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float f = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(par5 & 0xFF) / 255.0f;
        float f4 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(par6 & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b((double)par3, (double)par2, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferBuilder.func_181662_b((double)par1, (double)par2, 0.0).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferBuilder.func_181662_b((double)par1, (double)par4, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferBuilder.func_181662_b((double)par3, (double)par4, 0.0).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    private static void pushViewport(int x, int y, int w, int h) {
        int tlx = x;
        int tly = y;
        int brx = x + w;
        int bry = y + h;
        x = tlx;
        y = tly;
        w = brx - tlx;
        h = bry - tly;
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledRes = new ScaledResolution(mc);
        int guiScale = scaledRes.func_78325_e();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(x * guiScale), (int)(mc.field_71440_d - y * guiScale - h * guiScale), (int)(w * guiScale), (int)(h * guiScale));
    }

    private static void disableViewport() {
        GL11.glScissor((int)0, (int)0, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d);
        GL11.glDisable((int)3089);
    }
}

