/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.interfaces.IWidgetSelection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class Text
extends GuiElement {
    TextValidator textValidator = new TextValidator();
    IWidgetSelection selector;
    String text;
    int cursorIndex;
    protected static char[] allowedChars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    protected static char[] allowedCharSymbols = new char[]{' ', '!', '#', '$', '%', '^', '&', '*', '(', ')', '_', '-', '+', '=', '{', '}', '[', ']', ':', ';', '\"', '\'', ',', '<', '.', '>', '/', '?', '@'};
    protected static char[] allowedNums = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
    protected static char[] allowedNumSymbols = new char[]{'.', '-'};

    public Text(int topLeftX, int topLeftY, int width, String defaultText, IWidgetSelection selector) {
        super(topLeftX, topLeftY, width, 12);
        if (defaultText == null) {
            defaultText = "";
        }
        this.text = defaultText;
        this.cursorIndex = this.text.length();
        this.selector = selector;
        this.addDefaultListeners();
        this.addAllowedChars();
    }

    protected void addAllowedChars() {
        this.textValidator.addValidChars(allowedChars);
        this.textValidator.addValidChars(allowedCharSymbols);
        this.textValidator.addValidChars(allowedNums);
        this.textValidator.addValidChars(allowedNumSymbols);
    }

    protected void addDefaultListeners() {
        this.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (Text.this.enabled && Text.this.visible && Text.this.isMouseOverElement(evt.mx, evt.my)) {
                    if (Text.this.selected && evt.mButton == 1) {
                        String oldText = Text.this.text;
                        Text.this.setText("");
                        Text.this.onTextUpdated(oldText, Text.this.text);
                        return false;
                    }
                    Text.this.setSelected(true);
                    Text.this.selector.onWidgetSelected(Text.this);
                    Text.this.cursorIndex = Text.this.text.length();
                } else {
                    if (Text.this.selected) {
                        Text.this.selector.onWidgetDeselected(Text.this);
                    }
                    Text.this.setSelected(false);
                }
                return true;
            }
        });
        this.addNewListener(new Listener(2){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (Text.this.enabled && Text.this.visible && Text.this.selected) {
                    Text.this.handleKeyInput(evt.key, evt.ch);
                }
                return true;
            }
        });
    }

    public void onTextUpdated(String oldText, String newText) {
    }

    public void removeAllowedChars(char ... chars) {
        for (char ch : chars) {
            this.textValidator.removeValidChar(ch);
        }
    }

    public void setAllowedChars(Set<Character> allowedChars) {
        this.textValidator = new TextValidator(allowedChars);
    }

    public void setAllowedChars(char[] chars) {
        this.textValidator = new TextValidator(chars);
    }

    protected void handleKeyInput(int keyCode, char ch) {
        boolean handled = false;
        switch (keyCode) {
            case 203: {
                handled = true;
                --this.cursorIndex;
                if (this.cursorIndex >= 0) break;
                this.cursorIndex = 0;
                break;
            }
            case 205: {
                handled = true;
                ++this.cursorIndex;
                if (this.cursorIndex <= this.text.length()) break;
                this.cursorIndex = this.text.length();
                break;
            }
            case 28: {
                handled = true;
                this.onEnterPressed();
                break;
            }
            case 14: {
                handled = true;
                this.handleBackspaceAction();
                break;
            }
            case 211: {
                handled = true;
                this.handleDeleteAction();
                break;
            }
            case 199: {
                handled = true;
                this.cursorIndex = 0;
                break;
            }
            case 207: {
                handled = true;
                this.cursorIndex = this.text.length();
                break;
            }
            case 1: {
                this.selected = false;
                this.selector.onWidgetDeselected(this);
            }
        }
        if (!handled) {
            this.handleCharacter(ch);
        }
    }

    protected void onEnterPressed() {
    }

    protected void handleDeleteAction() {
        if (this.cursorIndex < this.text.length()) {
            String newText = "";
            for (int i = 0; i < this.text.length(); ++i) {
                if (i == this.cursorIndex) continue;
                newText = newText + this.text.charAt(i);
            }
            String oldText = this.text;
            this.text = newText;
            this.onTextUpdated(oldText, newText);
        }
    }

    protected void handleBackspaceAction() {
        if (this.cursorIndex > 0) {
            String newText = "";
            for (int i = 0; i < this.text.length(); ++i) {
                if (i == this.cursorIndex - 1) continue;
                newText = newText + this.text.charAt(i);
            }
            --this.cursorIndex;
            String oldText = this.text;
            this.setText(newText);
            this.onTextUpdated(oldText, newText);
        }
    }

    protected void handleCharacter(char ch) {
        if (this.isAllowedCharacter(ch)) {
            String newText = "";
            for (int i = 0; i <= this.text.length(); ++i) {
                if (i == this.cursorIndex) {
                    newText = newText + ch;
                }
                if (i >= this.text.length()) continue;
                newText = newText + this.text.charAt(i);
            }
            String oldText = this.text;
            this.text = newText;
            this.onTextUpdated(oldText, newText);
            ++this.cursorIndex;
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
        GlStateManager.func_187447_r((int)7);
        GL11.glVertex2f((float)this.renderX, (float)this.renderY);
        GL11.glVertex2f((float)this.renderX, (float)(this.renderY + this.height));
        GL11.glVertex2f((float)(this.renderX + this.width), (float)(this.renderY + this.height));
        GL11.glVertex2f((float)(this.renderX + this.width), (float)this.renderY);
        GlStateManager.func_187437_J();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_187447_r((int)7);
        GL11.glVertex2f((float)(this.renderX + 1), (float)(this.renderY + 1));
        GL11.glVertex2f((float)(this.renderX + 1), (float)(this.renderY + this.height - 1));
        GL11.glVertex2f((float)(this.renderX + this.width - 1), (float)(this.renderY + this.height - 1));
        GL11.glVertex2f((float)(this.renderX + this.width - 1), (float)(this.renderY + 1));
        GlStateManager.func_187437_J();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        Minecraft.func_71410_x().field_71466_p.func_78276_b(this.text, this.renderX + 2, this.renderY + 2, this.enabled ? -1 : -1448498689);
        if (this.selected) {
            int w = 0;
            for (int i = 0; i < this.cursorIndex && i < this.text.length(); ++i) {
                w += Minecraft.func_71410_x().field_71466_p.func_78263_a(this.text.charAt(i));
            }
            Minecraft.func_71410_x().field_71466_p.func_78276_b("_", this.renderX + 2 + w, this.renderY + 3, -65536);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        String in = text;
        text = "";
        for (int i = 0; i < in.length(); ++i) {
            if (!this.isAllowedCharacter(in.charAt(i))) continue;
            text = text + in.charAt(i);
        }
        this.text = text;
        if (this.cursorIndex > text.length()) {
            this.cursorIndex = text.length();
        }
    }

    public void addAllowedChar(char ch) {
        this.textValidator.addValidChar(ch);
    }

    protected boolean isAllowedCharacter(char ch) {
        return this.textValidator.isCharValid(ch);
    }

    public String getText() {
        return this.text;
    }

    public static class TextValidator {
        Set<Character> validChars = new HashSet<Character>();

        public TextValidator() {
        }

        public TextValidator(char[] chars) {
            for (char ch : chars) {
                this.validChars.add(Character.valueOf(ch));
            }
        }

        public TextValidator(Set<Character> chars) {
            this.validChars.addAll(chars);
        }

        public void addValidChar(char ch) {
            this.validChars.add(Character.valueOf(ch));
        }

        public void addValidChars(char[] chars) {
            for (char ch : chars) {
                this.validChars.add(Character.valueOf(ch));
            }
        }

        public boolean isCharValid(char ch) {
            return this.validChars.contains(Character.valueOf(ch));
        }

        public void removeValidChar(char ch) {
            this.validChars.remove(Character.valueOf(ch));
        }

        public void clearAllowedChars() {
            this.validChars.clear();
        }
    }
}

