/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.core.interfaces.IWidgetSelection;

public class NumberInput
extends Text {
    boolean allowDecimal = true;
    boolean allowNeg;
    boolean integerValue;
    float value;
    int decimalPlaces = 2;
    float incrementAmount = 1.0f;

    public NumberInput(int topLeftX, int topLeftY, int width, float defaultText, IWidgetSelection selector) {
        super(topLeftX, topLeftY, width, String.format("%.2f", Float.valueOf(defaultText)), selector);
        this.value = defaultText;
        this.setAllowedChars(allowedNums);
        this.scrollInput = true;
    }

    public int getIntegerValue() {
        return (int)this.value;
    }

    public float getFloatValue() {
        return this.value;
    }

    public NumberInput setAllowNegative() {
        this.allowNeg = true;
        return this;
    }

    public NumberInput setIntegerValue() {
        this.integerValue = true;
        this.decimalPlaces = 0;
        this.incrementAmount = 1.0f;
        this.allowDecimal = false;
        this.text = String.format("%." + this.decimalPlaces + "f", Float.valueOf(this.value));
        return this;
    }

    public NumberInput setIncrementAmount(float amount) {
        this.incrementAmount = amount;
        return this;
    }

    public NumberInput setDecimalPlaces(int places) {
        this.decimalPlaces = places = places < 0 ? 0 : places;
        return this;
    }

    @Override
    protected void addAllowedChars() {
        this.textValidator.addValidChars(allowedNums);
        this.textValidator.addValidChars(allowedNumSymbols);
    }

    @Override
    protected void addDefaultListeners() {
        super.addDefaultListeners();
        this.addNewListener(new Listener(16){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (NumberInput.this.isMouseOverElement(evt.mx, evt.my)) {
                    int d = evt.mw;
                    if (d < 0) {
                        NumberInput.this.setValue(NumberInput.this.value - NumberInput.this.incrementAmount);
                    } else if (d > 0) {
                        NumberInput.this.setValue(NumberInput.this.value + NumberInput.this.incrementAmount);
                    }
                }
                return true;
            }
        });
    }

    @Override
    public void setText(String text) {
        if (text == null || text.isEmpty()) {
            this.setValue(0.0f);
            this.text = "";
            return;
        }
        try {
            Float fl = Float.valueOf(Float.parseFloat(text));
            this.setValue(fl.floatValue());
            this.text = text;
        }
        catch (NumberFormatException e) {
            this.setValue(0.0f);
            this.text = String.format("%." + this.decimalPlaces + "f", Float.valueOf(0.0f));
        }
    }

    public NumberInput setValue(float val) {
        if (this.value == val) {
            return this;
        }
        if (!this.allowNeg && val < 0.0f) {
            val = 0.0f;
        }
        this.text = String.format("%." + this.decimalPlaces + "f", Float.valueOf(val));
        this.value = val;
        this.onValueUpdated(this.value);
        if (this.cursorIndex > this.text.length()) {
            this.cursorIndex = this.text.length();
        }
        return this;
    }

    @Override
    protected void handleCharacter(char ch) {
        boolean allowed = this.isAllowedCharacter(ch);
        if (ch == '.') {
            allowed = this.allowDecimal;
        } else if (ch == '-') {
            boolean bl = allowed = this.allowNeg && this.value > 0.0f && this.cursorIndex == 0;
        }
        if (allowed) {
            StringBuilder newText = new StringBuilder();
            for (int i = 0; i <= this.text.length(); ++i) {
                if (i == this.cursorIndex) {
                    newText.append(ch);
                }
                if (i >= this.text.length()) continue;
                newText.append(this.text.charAt(i));
            }
            this.text = newText.toString();
            ++this.cursorIndex;
            this.setText(this.text);
        }
    }

    @Override
    protected void onEnterPressed() {
        this.setText(this.getText());
    }

    public void onValueUpdated(float value) {
    }
}

