/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class Line
extends GuiElement {
    int lineWidth;
    int color;
    int x2;
    int y2;

    public Line(int topLeftX, int topLeftY, int x2, int y2, int lineWidth, int color) {
        super(topLeftX, topLeftY, x2 - topLeftX, y2 - topLeftY);
        this.color = color;
        this.x2 = x2 - topLeftX;
        this.y2 = y2 - topLeftY;
        this.lineWidth = lineWidth;
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_187441_d((float)(this.lineWidth * this.getScaleFactor()));
        this.setColor();
        GlStateManager.func_187447_r((int)2);
        GL11.glVertex2f((float)this.renderX, (float)this.renderY);
        GL11.glVertex2f((float)(this.renderX + this.x2), (float)(this.renderY + this.y2));
        GlStateManager.func_187437_J();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
    }

    private void setColor() {
        float r = (this.color & 0xFF000000) >> 24;
        float g = (this.color & 0xFF0000) >> 16;
        float b = (this.color & 0xFF00) >> 8;
        float a = (this.color & 0xFF) >> 0;
        GlStateManager.func_179131_c((float)(r /= 255.0f), (float)(g /= 255.0f), (float)(b /= 255.0f), (float)(a /= 255.0f));
    }

    private int getScaleFactor() {
        Minecraft mc = Minecraft.func_71410_x();
        int scaledWidth = mc.field_71443_c;
        int scaledHeight = mc.field_71440_d;
        int scaleFactor = 1;
        int guiScale = mc.field_71474_y.field_74335_Z;
        if (guiScale == 0) {
            guiScale = 1000;
        }
        while (scaleFactor < guiScale && scaledWidth / (scaleFactor + 1) >= 320 && scaledHeight / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        return scaleFactor;
    }
}

