/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui.elements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Composite;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.Tab;
import net.shadowmage.ancientwarfare.core.interfaces.ITabCallback;
import net.shadowmage.ancientwarfare.core.util.RenderTools;

@SideOnly(value=Side.CLIENT)
public class CompositeTabbed
extends Composite
implements ITabCallback {
    protected HashMap<Tab, List<GuiElement>> tabElements = new HashMap();
    protected HashMap<String, Tab> tabs = new HashMap();
    protected Tab currentTab = null;
    protected boolean hasTopTabs = false;
    protected boolean hasBottomTabs = false;

    public CompositeTabbed(GuiContainerBase gui, int topLeftX, int topLeftY, int width, int height) {
        super(gui, topLeftX, topLeftY, width, height);
    }

    @Override
    protected void addDefaultListeners() {
        this.addNewListener(new Listener(-1){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                block9: {
                    block8: {
                        if ((evt.type & 3) == 0) break block8;
                        if (CompositeTabbed.this.currentTab == null) break block9;
                        for (GuiElement element : CompositeTabbed.this.tabElements.get(CompositeTabbed.this.currentTab)) {
                            element.handleKeyboardInput(evt);
                        }
                        break block9;
                    }
                    if ((evt.type & 0x3C) != 0) {
                        if (CompositeTabbed.this.isMouseOverElement(evt.mx, evt.my)) {
                            for (GuiElement element : CompositeTabbed.this.tabElements.get(CompositeTabbed.this.currentTab)) {
                                element.handleMouseInput(evt);
                            }
                            for (GuiElement element : CompositeTabbed.this.elements) {
                                element.handleMouseInput(evt);
                            }
                        } else if (evt.type == 4) {
                            for (GuiElement element : CompositeTabbed.this.tabElements.get(CompositeTabbed.this.currentTab)) {
                                element.setSelected(false);
                            }
                        }
                    }
                }
                return true;
            }
        });
    }

    public void addTab(String tabName, boolean top) {
        int w = 3;
        for (Tab t : this.tabs.values()) {
            if (t.top != top) continue;
            w += t.width;
        }
        Tab t = new Tab(w, top ? 0 : this.height - 16, top, tabName, this);
        this.tabs.put(tabName, t);
        this.elements.add(t);
        this.tabElements.put(t, new ArrayList());
        if (this.currentTab == null) {
            this.onTabSelected(t);
        }
        if (top) {
            this.hasTopTabs = true;
        } else {
            this.hasBottomTabs = true;
        }
    }

    @Override
    public void addGuiElement(GuiElement element) {
        if (this.currentTab == null) {
            throw new IllegalArgumentException("cannot add elements to a null tab, you must create at least one tab first");
        }
        this.tabElements.get(this.currentTab).add(element);
    }

    public void addGuiElement(String tabName, GuiElement element) {
        if (!this.tabs.containsKey(tabName)) {
            throw new IllegalArgumentException("cannot add elements to a null tab, you must create the tab first");
        }
        this.tabElements.get(this.tabs.get(tabName)).add(element);
    }

    public void removeGuiElement(String tabName, GuiElement element) {
        if (!this.tabs.containsKey(tabName)) {
            throw new IllegalArgumentException("cannot remove elements from a null tab, you must create the tab first");
        }
        this.tabElements.get(this.tabs.get(tabName)).remove(element);
    }

    public void removeTab(String tabName) {
        Tab tab = this.tabs.get(tabName);
        if (tab == null) {
            return;
        }
        this.tabs.remove(tabName);
        this.tabElements.remove(tab);
        if (tab == this.currentTab) {
            this.currentTab = this.tabs.isEmpty() ? null : this.tabs.values().iterator().next();
        }
    }

    public void setActiveTab(String tabName) {
        this.onTabSelected(this.tabs.get(tabName));
    }

    @Override
    public void onTabSelected(Tab tab) {
        this.currentTab = tab;
        for (GuiElement guiElement : this.tabs.values()) {
            guiElement.setSelected(false);
        }
        tab.setSelected(true);
        for (GuiElement guiElement : this.tabElements.get(this.currentTab)) {
            guiElement.updateGuiPosition(0, this.hasTopTabs ? 13 : 0);
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        if (!this.isMouseOverElement(mouseX, mouseY)) {
            mouseX = Integer.MIN_VALUE;
            mouseY = Integer.MIN_VALUE;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(backgroundTextureLocation);
        int topY = this.renderY;
        int height = this.height;
        if (this.hasTopTabs) {
            topY += 13;
            height -= 13;
        }
        if (this.hasBottomTabs) {
            height -= 13;
        }
        RenderTools.renderQuarteredTexture(256, 256, 0, 0, 256, 240, this.renderX, topY, this.width, height);
        this.setViewport();
        for (GuiElement guiElement : this.tabs.values()) {
            guiElement.render(mouseX, mouseY, partialTick);
        }
        for (GuiElement guiElement : this.tabElements.get(this.currentTab)) {
            guiElement.render(mouseX, mouseY, partialTick);
        }
        this.popViewport();
    }

    @Override
    protected void updateElementPositions() {
        super.updateElementPositions();
        for (GuiElement element : this.tabElements.get(this.currentTab)) {
            element.updateGuiPosition(this.renderX, this.renderY + (this.hasTopTabs ? 13 : 0));
        }
    }
}

