/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.crafting.AWCraftingManager;
import net.shadowmage.ancientwarfare.core.crafting.ResearchRecipeBase;
import net.shadowmage.ancientwarfare.core.crafting.ShapedResearchRecipe;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.interfaces.ITooltipRenderer;
import net.shadowmage.ancientwarfare.core.registry.ResearchRegistry;
import net.shadowmage.ancientwarfare.core.research.ResearchGoal;
import net.shadowmage.ancientwarfare.core.research.ResearchTracker;

public class GuiResearchBook
extends GuiContainerBase {
    private ResearchRecipeBase selectedRecipe = null;
    private ResearchGoal selectedGoal = null;
    private CompositeScrolled area;
    private CompositeScrolled detailsArea;
    private boolean researchMode = true;
    private Checkbox modeBox;

    public GuiResearchBook(ContainerBase container) {
        super(container, 400, 240);
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 40, this.field_146999_f / 2, this.field_147000_g - 40);
        this.addGuiElement(this.area);
        this.modeBox = new Checkbox(8, 8, 16, 16, "guistrings.research.research_mode"){

            @Override
            public void onToggled() {
                GuiResearchBook.this.researchMode = this.checked();
                GuiResearchBook.this.refreshGui();
            }
        };
        this.modeBox.setChecked(this.researchMode);
        this.addGuiElement(this.modeBox);
        this.detailsArea = new CompositeScrolled(this, this.field_146999_f / 2, 40, this.field_146999_f / 2, this.field_147000_g - 40);
        this.addGuiElement(this.detailsArea);
    }

    @Override
    public void setupElements() {
        this.area.clearElements();
        this.detailsArea.clearElements();
        this.modeBox.setChecked(this.researchMode);
        if (this.researchMode) {
            this.addResearchModeControls();
        } else {
            this.addRecipeModeControls();
        }
    }

    private void addRecipeModeControls() {
        int totalHeight = 8;
        for (ResearchRecipeBase recipe : AWCraftingManager.getRecipes().stream().sorted(Comparator.comparing(r -> r.getRecipeOutput().func_82833_r())).collect(Collectors.toCollection(LinkedHashSet::new))) {
            this.area.addGuiElement(new RecipeButton(8, totalHeight, recipe));
            totalHeight += 12;
        }
        this.area.setAreaSize(totalHeight);
        totalHeight = 8;
        this.detailsArea.addGuiElement(this.getRecipeButton(8, totalHeight, this.selectedRecipe));
        totalHeight += 14;
        if (this.selectedRecipe != null) {
            String depResearch = this.selectedRecipe.getNeededResearch();
            boolean canShow = ResearchTracker.INSTANCE.hasPlayerCompleted((World)this.field_146297_k.field_71441_e, this.field_146297_k.field_71439_g.func_70005_c_(), depResearch);
            int recipeWidth = 3;
            int recipeHeight = 3;
            if (this.selectedRecipe instanceof ShapedResearchRecipe) {
                recipeWidth = ((ShapedResearchRecipe)this.selectedRecipe).getRecipeWidth();
                recipeHeight = ((ShapedResearchRecipe)this.selectedRecipe).getRecipeHeight();
            }
            if (canShow) {
                int i;
                NonNullList ingredients = NonNullList.func_191197_a((int)(recipeWidth * recipeHeight), (Object)ItemStack.field_190927_a);
                for (i = 0; i < this.selectedRecipe.getIngredients().size(); ++i) {
                    Ingredient ingredient = (Ingredient)this.selectedRecipe.getIngredients().get(i);
                    if (ingredient.func_193365_a().length <= 0) continue;
                    ingredients.set(i, (Object)ingredient.func_193365_a()[0]);
                }
                for (i = 0; i < recipeWidth; ++i) {
                    for (int j = 0; j < recipeHeight; ++j) {
                        this.detailsArea.addGuiElement(new ItemSlot(9 + 18 * i, totalHeight + 18 * j, (ItemStack)ingredients.get(i + j * recipeWidth), this));
                    }
                }
                this.detailsArea.addGuiElement(new Label(8 + 18 * (recipeWidth + 1), (totalHeight += (recipeHeight - 1) * 9) + 2, "->"));
            }
            this.detailsArea.addGuiElement(new ItemSlot(9 + 18 * (recipeWidth + 2), totalHeight, this.selectedRecipe.getRecipeOutput(), this));
            totalHeight = canShow ? (totalHeight += (recipeHeight + 1) * 9) : (totalHeight += 20);
            this.detailsArea.addGuiElement(new Label(8, totalHeight, "guistrings.research.research_needed"));
            totalHeight += 14;
            ResearchGoal goal = ResearchRegistry.getResearch(depResearch);
            if (goal != null) {
                GoalButton button = new GoalButton(8, totalHeight, goal);
                this.detailsArea.addGuiElement(button);
            }
        }
    }

    private void addResearchModeControls() {
        ArrayList<ResearchGoal> goals = new ArrayList<ResearchGoal>(ResearchRegistry.getAllResearchGoals());
        goals.sort(new ResearchSorter());
        int totalHeight = 8;
        for (ResearchGoal goal : goals) {
            this.area.addGuiElement(new GoalButton(8, totalHeight, goal));
            totalHeight += 12;
        }
        this.area.setAreaSize(totalHeight);
        totalHeight = 8;
        this.detailsArea.addGuiElement(this.getResearchButton(8, totalHeight, this.selectedGoal));
        totalHeight += 16;
        if (this.selectedGoal != null) {
            Set<ResearchGoal> deps;
            Collection<ResearchRecipeBase> recipes = AWCraftingManager.getRecipes();
            ArrayList<ResearchRecipeBase> list = new ArrayList<ResearchRecipeBase>();
            for (ResearchRecipeBase recipe : recipes) {
                if (!recipe.getNeededResearch().equals(this.selectedGoal.getName())) continue;
                list.add(recipe);
            }
            if (!list.isEmpty()) {
                this.detailsArea.addGuiElement(new Label(8, totalHeight, "guistrings.research.researched_items"));
                totalHeight += 14;
                for (int i = 0; i < list.size(); ++i) {
                    RecipeSlot slot = new RecipeSlot(i, totalHeight, (ResearchRecipeBase)((Object)list.get(i)), this);
                    this.detailsArea.addGuiElement(slot);
                }
                totalHeight += 18 * (1 + list.size() / 9);
            }
            if (!(deps = this.selectedGoal.getDependencies()).isEmpty()) {
                this.detailsArea.addGuiElement(new Label(8, totalHeight, "guistrings.research.research_needed"));
                totalHeight += 14;
                for (ResearchGoal goal : deps) {
                    GoalButton button = new GoalButton(8, totalHeight, goal);
                    this.detailsArea.addGuiElement(button);
                    totalHeight += 12;
                }
            }
        }
    }

    private Button getRecipeButton(int topLeftX, int topLeftY, ResearchRecipeBase recipe) {
        return new Button(topLeftX, topLeftY, 160, 12, recipe == null ? "guistrings.no_selection" : recipe.getRecipeOutput().func_82833_r());
    }

    private Button getResearchButton(int topLeftX, int topLeftY, ResearchGoal goal) {
        return new Button(topLeftX, topLeftY, 160, 10, goal == null ? "guistrings.no_selection" : goal.getUnlocalizedName());
    }

    private class ResearchSorter
    implements Comparator<ResearchGoal> {
        private ResearchSorter() {
        }

        @Override
        public int compare(ResearchGoal arg0, ResearchGoal arg1) {
            String nameA = I18n.func_135052_a((String)arg0.getName(), (Object[])new Object[0]);
            String nameB = I18n.func_135052_a((String)arg1.getName(), (Object[])new Object[0]);
            return nameA.compareTo(nameB);
        }
    }

    private class GoalButton
    extends Button {
        final ResearchGoal goal;

        public GoalButton(int topLeftX, int topLeftY, ResearchGoal goal) {
            super(topLeftX, topLeftY, 160, 10, goal == null ? "guistrings.no_selection" : goal.getUnlocalizedName());
            this.goal = goal;
        }

        @Override
        protected void onPressed() {
            GuiResearchBook.this.selectedGoal = this.goal;
            GuiResearchBook.this.researchMode = true;
            GuiResearchBook.this.refreshGui();
        }
    }

    private class RecipeButton
    extends Button {
        final ResearchRecipeBase recipe;

        public RecipeButton(int topLeftX, int topLeftY, ResearchRecipeBase recipe) {
            super(topLeftX, topLeftY, 160, 12, recipe == null ? "guistrings.no_selection" : recipe.getRecipeOutput().func_82833_r());
            this.recipe = recipe;
        }

        @Override
        protected void onPressed() {
            GuiResearchBook.this.selectedRecipe = this.recipe;
            GuiResearchBook.this.refreshGui();
        }
    }

    private class RecipeSlot
    extends ItemSlot {
        private final ResearchRecipeBase researched;

        public RecipeSlot(int i, int totalHeight, ResearchRecipeBase recipe, ITooltipRenderer render) {
            super(8 + 18 * (i % 9), totalHeight + 18 * (i / 9), recipe.getRecipeOutput(), render);
            this.setRenderItemQuantity(false);
            this.researched = recipe;
        }

        @Override
        public void onSlotClicked(ItemStack stack, boolean rightClicked) {
            GuiResearchBook.this.selectedRecipe = this.researched;
            GuiResearchBook.this.researchMode = false;
            GuiResearchBook.this.refreshGui();
        }
    }
}

