/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.datafixes;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.shadowmage.ancientwarfare.core.util.StreamUtils;

public class ResearchEntryIdNameFixer {
    private static final Map<Integer, String> research = new ImmutableMap.Builder().put((Object)0, (Object)"invention").put((Object)1, (Object)"agriculture").put((Object)2, (Object)"leadership").put((Object)3, (Object)"engineering").put((Object)4, (Object)"farming").put((Object)5, (Object)"animal_husbandry").put((Object)6, (Object)"fishing").put((Object)7, (Object)"conscription").put((Object)8, (Object)"command").put((Object)9, (Object)"mining").put((Object)10, (Object)"the_wheel").put((Object)11, (Object)"construction").put((Object)12, (Object)"mathematics").put((Object)13, (Object)"trade").put((Object)14, (Object)"tactics").put((Object)15, (Object)"combustion").put((Object)16, (Object)"chemistry").put((Object)17, (Object)"theory_of_gravity").put((Object)18, (Object)"seafaring").put((Object)19, (Object)"explosives").put((Object)20, (Object)"refining").put((Object)21, (Object)"machinery").put((Object)22, (Object)"navigation").put((Object)23, (Object)"siege_warfare").put((Object)24, (Object)"gunpowder").put((Object)25, (Object)"mass_production").put((Object)26, (Object)"flight").put((Object)27, (Object)"naval_warfare").put((Object)28, (Object)"advanced_siege_warfare").put((Object)29, (Object)"ballistics").put((Object)30, (Object)"rocketry").build();

    private ResearchEntryIdNameFixer() {
    }

    public static NBTTagCompound fix(NBTTagCompound tag) {
        if (tag.func_150297_b("currentResearch", 3)) {
            String researchName = research.get(tag.func_74762_e("currentResearch"));
            if (researchName != null) {
                tag.func_74778_a("currentResearch", researchName);
            } else {
                tag.func_82580_o("currentResearch");
            }
        }
        if (tag.func_150297_b("completedResearch", 11)) {
            tag.func_74782_a("completedResearch", (NBTBase)ResearchEntryIdNameFixer.fixArray(tag.func_74759_k("completedResearch")));
        }
        if (tag.func_150297_b("queuedResearch", 11)) {
            tag.func_74782_a("queuedResearch", (NBTBase)ResearchEntryIdNameFixer.fixArray(tag.func_74759_k("queuedResearch")));
        }
        return tag;
    }

    private static NBTTagList fixArray(int[] researches) {
        return Arrays.stream(researches).mapToObj(i -> new NBTTagString(research.get(i))).collect(StreamUtils.toNBTTagList);
    }
}

