/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.datafixes;

import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IDataWalker;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.shadowmage.ancientwarfare.automation.datafixes.ItemMapDataWalker;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStorage;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStorageLarge;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStorageMedium;
import net.shadowmage.ancientwarfare.core.datafixes.ResearchNoteFixer;
import net.shadowmage.ancientwarfare.core.datafixes.TileIdFixer;
import net.shadowmage.ancientwarfare.core.datafixes.TileOwnerFixer;
import net.shadowmage.ancientwarfare.core.datafixes.VehicleOwnerFixer;
import net.shadowmage.ancientwarfare.npc.datafixes.FactionEntityFixer;
import net.shadowmage.ancientwarfare.npc.datafixes.FactionExpansionEntityFixer;
import net.shadowmage.ancientwarfare.npc.datafixes.FactionExpansionItemFixer;
import net.shadowmage.ancientwarfare.npc.datafixes.FactionSpawnerItemFixer;
import net.shadowmage.ancientwarfare.npc.datafixes.FoodBundleDataFixer;
import net.shadowmage.ancientwarfare.npc.datafixes.NpcSkinFixer;
import net.shadowmage.ancientwarfare.npc.datafixes.RoutingOrderFilterCountsFixer;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.init.AWNPCEntities;
import net.shadowmage.ancientwarfare.structure.datafixes.LootSettingsPotionRegistryNameFixer;
import net.shadowmage.ancientwarfare.structure.datafixes.TileLootFixer;
import net.shadowmage.ancientwarfare.structure.datafixes.WoodenCoffinFixer;

public class AWDataFixes {
    private static final int DATA_FIXER_VERSION = 11;

    private AWDataFixes() {
    }

    public static void registerDataFixes() {
        CompoundDataFixer dataFixer = FMLCommonHandler.instance().getDataFixer();
        AWNPCEntities.getNpcMap().values().forEach(npc -> NpcBase.registerFixesNpc((DataFixer)dataFixer, npc.getEntityClass()));
        ModFixs fixes = dataFixer.init("ancientwarfare", 11);
        fixes.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)new VehicleOwnerFixer());
        fixes.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileOwnerFixer());
        fixes.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileIdFixer());
        fixes.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)new FactionEntityFixer());
        fixes.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new FactionSpawnerItemFixer());
        fixes.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new ResearchNoteFixer());
        fixes.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)new FactionExpansionEntityFixer());
        fixes.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new FactionExpansionItemFixer());
        fixes.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new RoutingOrderFilterCountsFixer());
        fixes.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new RoutingOrderFilterCountsFixer());
        fixes.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new FoodBundleDataFixer());
        fixes.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileLootFixer());
        fixes.registerFix((IFixType)FixTypes.ENTITY, (IFixableData)new NpcSkinFixer());
        dataFixer.func_188258_a(FixTypes.BLOCK_ENTITY, (IDataWalker)new ItemMapDataWalker(new Class[]{TileWarehouseStorage.class, TileWarehouseStorageMedium.class, TileWarehouseStorageLarge.class}, "inventory/itemMap/entryList"));
        fixes.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new LootSettingsPotionRegistryNameFixer());
        fixes.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new WoodenCoffinFixer());
    }
}

