/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.crafting.wrappers;

import java.util.Optional;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.shadowmage.ancientwarfare.core.crafting.ICraftingRecipe;
import net.shadowmage.ancientwarfare.core.crafting.RecipeResourceLocation;
import net.shadowmage.ancientwarfare.core.crafting.ResearchRecipeBase;
import net.shadowmage.ancientwarfare.core.crafting.ShapedResearchRecipe;

public class ResearchCraftingWrapper
implements ICraftingRecipe {
    private static final NonNullList<ItemStack> EMPTY_STACK_LIST = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private final ResearchRecipeBase recipe;
    private final RecipeResourceLocation registryName;

    public ResearchCraftingWrapper(ResearchRecipeBase researchRecipe) {
        this.recipe = researchRecipe;
        if (researchRecipe.getRegistryName() == null) {
            throw new IllegalArgumentException("Null registryName recipes are not allowed here");
        }
        this.registryName = new RecipeResourceLocation(RecipeResourceLocation.RecipeType.RESEARCH, researchRecipe.getRegistryName());
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return this.recipe.getIngredients();
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inv) {
        return this.recipe.getCraftingResult();
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.recipe.getRecipeOutput();
    }

    @Override
    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting invCrafting) {
        return EMPTY_STACK_LIST;
    }

    @Override
    public RecipeResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Override
    public Optional<String> getNeededResearch() {
        return Optional.of(this.recipe.getNeededResearch());
    }

    @Override
    public int getRecipeWidth() {
        return this.recipe instanceof ShapedResearchRecipe ? ((ShapedResearchRecipe)this.recipe).getRecipeWidth() : 3;
    }

    @Override
    public int getRecipeHeight() {
        return this.recipe instanceof ShapedResearchRecipe ? ((ShapedResearchRecipe)this.recipe).getRecipeHeight() : 3;
    }
}

