/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.crafting;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.crafting.ICraftingRecipe;
import net.shadowmage.ancientwarfare.core.crafting.IIngredientCount;
import net.shadowmage.ancientwarfare.core.crafting.IngredientCount;
import net.shadowmage.ancientwarfare.core.crafting.IngredientNBTRelaxed;
import net.shadowmage.ancientwarfare.core.crafting.IngredientOreCount;
import net.shadowmage.ancientwarfare.core.crafting.RecipeResourceLocation;
import net.shadowmage.ancientwarfare.core.crafting.ResearchRecipeBase;
import net.shadowmage.ancientwarfare.core.crafting.ResearchRecipeFactory;
import net.shadowmage.ancientwarfare.core.crafting.wrappers.NoRecipeWrapper;
import net.shadowmage.ancientwarfare.core.crafting.wrappers.RegularCraftingWrapper;
import net.shadowmage.ancientwarfare.core.crafting.wrappers.ResearchCraftingWrapper;
import net.shadowmage.ancientwarfare.core.research.ResearchTracker;
import net.shadowmage.ancientwarfare.core.util.FileUtils;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.TriFunction;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.util.TriConsumer;

public class AWCraftingManager {
    private static final IForgeRegistry<ResearchRecipeBase> RESEARCH_RECIPES = new RegistryBuilder().setName(new ResourceLocation("ancientwarfare", "research_recipes")).setType(ResearchRecipeBase.class).setMaxID(0x3FFFFFF).disableSaving().allowModification().create();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final ResearchRecipeFactory factory = new ResearchRecipeFactory();
    private static final Method LOAD_CONSTANTS = ReflectionHelper.findMethod(JsonContext.class, (String)"loadConstants", null, (Class[])new Class[]{JsonObject[].class});

    private AWCraftingManager() {
    }

    public static void init() {
    }

    private static List<ICraftingRecipe> findMatchingResearchRecipes(InventoryCrafting inventory, World world, String playerName) {
        return AWCraftingManager.findMatchingResearchRecipes(inventory, world, playerName, true);
    }

    private static List<ICraftingRecipe> findMatchingResearchRecipes(InventoryCrafting inventory, @Nullable World world, String playerName, boolean checkPlayerResearch) {
        ArrayList<ICraftingRecipe> ret = new ArrayList<ICraftingRecipe>();
        if (world == null) {
            return ret;
        }
        for (ResearchRecipeBase recipe : RESEARCH_RECIPES) {
            if (!recipe.matches(inventory, world) || checkPlayerResearch && !AWCraftingManager.canPlayerCraft(recipe, world, playerName)) continue;
            ret.add(new ResearchCraftingWrapper(recipe));
        }
        return ret;
    }

    private static List<ICraftingRecipe> findMatchingRegularRecipes(InventoryCrafting inventory, @Nullable World world) {
        ArrayList<ICraftingRecipe> ret = new ArrayList<ICraftingRecipe>();
        if (world == null) {
            return ret;
        }
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            if (!recipe.func_77569_a(inventory, world)) continue;
            ret.add(new RegularCraftingWrapper(recipe));
        }
        return ret;
    }

    private static List<ICraftingRecipe> findMatchingRecipesNoResearchCheck(InventoryCrafting inventory, World world) {
        List<ICraftingRecipe> recipes = AWCraftingManager.findMatchingResearchRecipes(inventory, world, "", false);
        recipes.addAll(AWCraftingManager.findMatchingRegularRecipes(inventory, world));
        return recipes;
    }

    public static List<ICraftingRecipe> findMatchingRecipes(InventoryCrafting inventory, World world, String playerName) {
        List<ICraftingRecipe> recipes = AWCraftingManager.findMatchingResearchRecipes(inventory, world, playerName);
        recipes.addAll(AWCraftingManager.findMatchingRegularRecipes(inventory, world));
        return recipes;
    }

    public static boolean canPlayerCraft(World world, String playerName, String research) {
        return ResearchTracker.INSTANCE.hasPlayerCompleted(world, playerName, research);
    }

    private static boolean canPlayerCraft(ResearchRecipeBase recipe, World world, String playerName) {
        return !AWCoreStatics.useResearchSystem || AWCraftingManager.canPlayerCraft(world, playerName, recipe.getNeededResearch());
    }

    private static void addRecipe(ResearchRecipeBase recipe, boolean checkForExistence) {
        Item item = recipe.getRecipeOutput().func_77973_b();
        if (AWCoreStatics.isItemCraftable(item)) {
            if (AWCoreStatics.isItemResearcheable(item) && AWCoreStatics.useResearchSystem || AWCraftingManager.hasCountIngredient(recipe)) {
                NonNullList subItems = NonNullList.func_191196_a();
                item.func_150895_a(item.func_77640_w(), subItems);
                if (!(!subItems.stream().anyMatch(s -> recipe.getRecipeOutput().func_77969_a(s)) || checkForExistence && RESEARCH_RECIPES.containsKey(recipe.getRegistryName()))) {
                    RESEARCH_RECIPES.register((IForgeRegistryEntry)recipe);
                }
            } else if (!ForgeRegistries.RECIPES.containsKey(recipe.getRegistryName())) {
                ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe.getCraftingRecipe());
            }
        }
    }

    private static boolean hasCountIngredient(ResearchRecipeBase recipe) {
        return recipe.getIngredients().stream().anyMatch(i -> i instanceof IIngredientCount);
    }

    public static Collection<ResearchRecipeBase> getRecipes() {
        return RESEARCH_RECIPES.getValuesCollection();
    }

    public static void loadRecipes() {
        ModContainer awModContainer = Loader.instance().activeModContainer();
        AWCraftingManager.loadRecipes(awModContainer, new File("config/ancientwarfare/research_recipes"), "");
        Loader.instance().getActiveModList().forEach(m -> AWCraftingManager.loadRecipes(m, m.getSource(), "assets/" + m.getModId() + "/research_recipes"));
        Loader.instance().setActiveModContainer(awModContainer);
    }

    public static void registerIngredients() {
        CraftingHelper.register((ResourceLocation)new ResourceLocation("ancientwarfare", "item_count"), (c, j) -> new IngredientCount(CraftingHelper.getItemStack((JsonObject)j, (JsonContext)c)));
        CraftingHelper.register((ResourceLocation)new ResourceLocation("ancientwarfare", "ore_dict_count"), (c, j) -> new IngredientOreCount(JsonUtils.func_151200_h((JsonObject)j, (String)"ore"), JsonUtils.func_151208_a((JsonObject)j, (String)"count", (int)1)));
        CraftingHelper.register((ResourceLocation)new ResourceLocation("ancientwarfare", "item_nbt_relaxed"), (c, j) -> new IngredientNBTRelaxed(CraftingHelper.getItemStack((JsonObject)j, (JsonContext)c)));
    }

    private static void loadRecipes(ModContainer mod, File source, String base) {
        JsonContext ctx = new JsonContext(mod.getModId());
        FileUtils.findFiles(source, base, root -> {
            Path fPath = root.resolve("_constants.json");
            if (fPath != null && Files.exists(fPath, new LinkOption[0])) {
                BufferedReader reader = null;
                try {
                    reader = Files.newBufferedReader(fPath);
                    JsonObject[] json = (JsonObject[])JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject[].class);
                    LOAD_CONSTANTS.invoke((Object)ctx, new Object[]{json});
                }
                catch (IOException | IllegalAccessException | InvocationTargetException e) {
                    AncientWarfareCore.LOG.error("Error loading _constants.json: ", (Throwable)e);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            return true;
        }, (root, file) -> {
            Loader.instance().setActiveModContainer(mod);
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                return;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            ResourceLocation key = new ResourceLocation(ctx.getModId(), name);
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file);
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                String type = ctx.appendModId(JsonUtils.func_151200_h((JsonObject)json, (String)"type"));
                if (type.equals("ancientwarfare:research_recipe") || type.equals("ancientwarfare:shapeless_research_recipe")) {
                    ResearchRecipeBase recipe = factory.parse(ctx, json);
                    recipe.setRegistryName(key);
                    AWCraftingManager.addRecipe(recipe, mod.getModId().equals("ancientwarfare"));
                } else {
                    AncientWarfareCore.LOG.info("Skipping recipe {} of type {} because it's not AW research recipe", (Object)key, (Object)type);
                }
            }
            catch (JsonParseException e) {
                AncientWarfareCore.LOG.error("Parsing error loading recipe {}", (Object)key, (Object)e);
            }
            catch (IOException e) {
                AncientWarfareCore.LOG.error("Couldn't read recipe {} from {}", (Object)key, file, (Object)e);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        });
    }

    public static ICraftingRecipe getRecipe(RecipeResourceLocation recipe) {
        switch (recipe.getRecipeType()) {
            case REGULAR: {
                IRecipe regRecipe = (IRecipe)CraftingManager.field_193380_a.func_82594_a((Object)recipe.getResourceLocation());
                return regRecipe != null ? new RegularCraftingWrapper(regRecipe) : NoRecipeWrapper.INSTANCE;
            }
            case RESEARCH: {
                ResearchRecipeBase resRecipe = (ResearchRecipeBase)RESEARCH_RECIPES.getValue(recipe.getResourceLocation());
                return resRecipe != null ? new ResearchCraftingWrapper(resRecipe) : NoRecipeWrapper.INSTANCE;
            }
        }
        return NoRecipeWrapper.INSTANCE;
    }

    public static InventoryCrafting fillCraftingMatrixFromInventory(List<ItemStack> resources) {
        InventoryCrafting invCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer playerIn) {
                return true;
            }

            public void func_75130_a(IInventory inventoryIn) {
            }
        }, 3, 3);
        for (int i = 0; i < resources.size(); ++i) {
            invCrafting.func_70299_a(i, resources.get(i));
        }
        return invCrafting;
    }

    public static ICraftingRecipe findMatchingRecipe(World world, NonNullList<ItemStack> inputs, ItemStack result) {
        InventoryCrafting inv = AWCraftingManager.fillCraftingMatrixFromInventory(inputs);
        List<ICraftingRecipe> recipes = AWCraftingManager.findMatchingRecipesNoResearchCheck(inv, world);
        if (recipes.isEmpty()) {
            return NoRecipeWrapper.INSTANCE;
        }
        if (recipes.size() == 1) {
            return recipes.get(0);
        }
        return recipes.stream().filter(r -> AWCraftingManager.recipeResultsEqual(result, r, inv)).findFirst().orElse(recipes.get(0));
    }

    private static boolean recipeResultsEqual(ItemStack result, ICraftingRecipe r, InventoryCrafting inv) {
        ItemStack otherResult = r.getCraftingResult(inv);
        if (otherResult.func_190926_b()) {
            return false;
        }
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)result);
        if (oreIDs.length > 0) {
            int[] foundRecipeOreIDs = OreDictionary.getOreIDs((ItemStack)otherResult);
            return oreIDs.length == foundRecipeOreIDs.length && IntStream.of(oreIDs).allMatch(o -> IntStream.of(foundRecipeOreIDs).anyMatch(of -> o == of));
        }
        return otherResult.func_77969_a(result);
    }

    public static NonNullList<ItemStack> getRecipeInventoryMatch(ICraftingRecipe recipe, IItemHandler inventory) {
        return AWCraftingManager.getRecipeInventoryMatch(recipe, (List<ItemStack>)NonNullList.func_191196_a(), inventory);
    }

    public static NonNullList<ItemStack> getRecipeInventoryMatch(ICraftingRecipe recipe, List<ItemStack> exactStacks, IItemHandler inventory) {
        return AWCraftingManager.getRecipeInventoryMatch(recipe, exactStacks, s -> InventoryTools.hasCountOrMore(inventory, s), inventory);
    }

    public static NonNullList<ItemStack> getRecipeInventoryMatch(ICraftingRecipe recipe, List<ItemStack> exactStacks, Function<ItemStack, Boolean> hasCountOrMore, IItemHandler inventory) {
        return AWCraftingManager.getRecipeInventoryMatch(recipe, exactStacks, hasCountOrMore, inventory, () -> NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a), (T list, Integer slot, ItemStack stack) -> {
            list.set(slot.intValue(), stack);
            return list;
        }, (T a, Ingredient in) -> NonNullList.func_191196_a());
    }

    public static <T> T getRecipeInventoryMatch(ICraftingRecipe recipe, IItemHandler inventory, Supplier<T> initialize, TriConsumer<T, Integer, ItemStack> onMatch, BiConsumer<T, Ingredient> onFail) {
        return AWCraftingManager.getRecipeInventoryMatch(recipe, (List<ItemStack>)NonNullList.func_191196_a(), (ItemStack s) -> InventoryTools.hasCountOrMore(inventory, s), inventory, initialize, onMatch, onFail);
    }

    public static <T> T getRecipeInventoryMatch(ICraftingRecipe recipe, List<ItemStack> exactStacks, Function<ItemStack, Boolean> hasCountOrMore, IItemHandler inventory, Supplier<T> initialize, TriConsumer<T, Integer, ItemStack> onMatch, BiConsumer<T, Ingredient> onFail) {
        return (T)AWCraftingManager.getRecipeInventoryMatch(recipe, exactStacks, hasCountOrMore, inventory, initialize, (T t, Integer i, ItemStack s) -> {
            onMatch.accept(t, i, s);
            return t;
        }, (T t, Ingredient in) -> {
            onFail.accept((Object)t, (Ingredient)in);
            return t;
        });
    }

    private static <T> T getRecipeInventoryMatch(ICraftingRecipe recipe, List<ItemStack> exactStacks, Function<ItemStack, Boolean> hasCountOrMore, IItemHandler inventory, Supplier<T> initialize, TriFunction<T, Integer, ItemStack, T> onMatch, BiFunction<T, Ingredient, T> onFail) {
        T ret = initialize.get();
        if (!recipe.isValid()) {
            ret = onFail.apply(ret, Ingredient.field_193370_a);
            return ret;
        }
        Map<Integer, IngredientMatchData> ingredientsData = AWCraftingManager.getIngredientData(recipe.getIngredients());
        Map<Integer, Ingredient> remainingIngredients = AWCraftingManager.getSlotIngredients(ingredientsData);
        ret = AWCraftingManager.matchExactStacks(exactStacks, hasCountOrMore, onMatch, ret, ingredientsData, remainingIngredients);
        if (remainingIngredients.isEmpty()) {
            return ret;
        }
        ret = AWCraftingManager.matchUsingRecipeIngredients(inventory, onMatch, ret, ingredientsData, remainingIngredients);
        ret = AWCraftingManager.processFailedIngredients(onFail, ret, remainingIngredients);
        return ret;
    }

    private static <T> T matchUsingRecipeIngredients(IItemHandler inventory, TriFunction<T, Integer, ItemStack, T> onMatch, T ret, Map<Integer, IngredientMatchData> ingredientsData, Map<Integer, Ingredient> remainingIngredients) {
        for (int slot = 0; slot < inventory.getSlots() && !remainingIngredients.isEmpty(); ++slot) {
            ItemStack resourceStack = inventory.getStackInSlot(slot);
            if (resourceStack.func_190926_b()) continue;
            ret = AWCraftingManager.matchIngredientsToStack(onMatch, ret, ingredientsData, remainingIngredients, resourceStack);
        }
        return ret;
    }

    private static <T> T matchIngredientsToStack(TriFunction<T, Integer, ItemStack, T> onMatch, T ret, Map<Integer, IngredientMatchData> ingredientsData, Map<Integer, Ingredient> remainingIngredients, ItemStack resourceStack) {
        int currentStackCount = resourceStack.func_190916_E();
        Iterator<Map.Entry<Integer, Ingredient>> it = remainingIngredients.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, Ingredient> entry = it.next();
            Ingredient ingredient = entry.getValue();
            if (!ingredient.apply(resourceStack)) continue;
            IngredientMatchData ingredientData = ingredientsData.get(entry.getKey());
            int countToRemove = Math.min(ingredientData.remainingCount, currentStackCount);
            currentStackCount -= countToRemove;
            ingredientData.remainingCount -= countToRemove;
            if (ingredientData.remainingCount < 1) {
                ret = AWCraftingManager.addSuccessfulMatch(ret, onMatch, resourceStack, ingredientData.count, ingredientData.index);
                it.remove();
            }
            if (currentStackCount > 0) continue;
            break;
        }
        return ret;
    }

    private static <T> T matchExactStacks(List<ItemStack> exactStacks, Function<ItemStack, Boolean> hasCountOrMore, TriFunction<T, Integer, ItemStack, T> onMatch, T ret, Map<Integer, IngredientMatchData> ingredientsData, Map<Integer, Ingredient> remainingIngredients) {
        Map<ItemStack, Set<Integer>> consolidatedStacks = AWCraftingManager.consolidateStacks(exactStacks, ingredientsData);
        for (Map.Entry<ItemStack, Set<Integer>> consolidatedStack : consolidatedStacks.entrySet()) {
            ItemStack stack = consolidatedStack.getKey();
            if (hasCountOrMore.apply(stack).booleanValue()) {
                for (Integer ingredientIndex : consolidatedStack.getValue()) {
                    remainingIngredients.remove(ingredientIndex);
                    if (ingredientsData.containsKey(ingredientIndex)) {
                        IngredientMatchData ingredientData = ingredientsData.get(ingredientIndex);
                        ret = AWCraftingManager.addSuccessfulMatch(ret, onMatch, stack, ingredientData.count, ingredientData.index);
                        continue;
                    }
                    ret = AWCraftingManager.addSuccessfulMatch(ret, onMatch, stack, 1, ingredientIndex);
                }
                continue;
            }
            for (int ingredientIndex : consolidatedStack.getValue()) {
                if (remainingIngredients.containsKey(ingredientIndex)) continue;
                IngredientCount ingredient = new IngredientCount(consolidatedStack.getKey()){

                    @Override
                    public int getCount() {
                        return 1;
                    }
                };
                remainingIngredients.put(ingredientIndex, ingredient);
                ingredientsData.put(ingredientIndex, AWCraftingManager.getSlotIngredient(ingredientIndex, ingredient));
            }
        }
        return ret;
    }

    private static <T> T addSuccessfulMatch(T ret, TriFunction<T, Integer, ItemStack, T> onMatch, ItemStack resourceStack, int count, int index) {
        ItemStack stackFound = resourceStack.func_77946_l();
        stackFound.func_190920_e(count);
        ret = onMatch.apply(ret, index, stackFound);
        return ret;
    }

    private static Map<ItemStack, Set<Integer>> consolidateStacks(List<ItemStack> exactStacks, Map<Integer, IngredientMatchData> ingredientsData) {
        HashMap<ItemStack, Set<Integer>> ret = new HashMap<ItemStack, Set<Integer>>();
        HashSet<Integer> matchedIngredientIndexes = new HashSet<Integer>();
        int slot = 0;
        for (ItemStack stack : exactStacks) {
            AWCraftingManager.consolidateStack(ingredientsData, ret, matchedIngredientIndexes, stack, slot);
            ++slot;
        }
        return ret;
    }

    private static void consolidateStack(Map<Integer, IngredientMatchData> ingredientsData, Map<ItemStack, Set<Integer>> stackIngredientIndexes, Set<Integer> matchedIngredientIndexes, ItemStack stack, int slot) {
        if (stack.func_190926_b()) {
            return;
        }
        int index = AWCraftingManager.getIngredientIndexForStack(ingredientsData, matchedIngredientIndexes, stack);
        int count = 1;
        if (index == -1) {
            index = slot;
        } else {
            count = ingredientsData.get((Object)Integer.valueOf((int)index)).count;
        }
        matchedIngredientIndexes.add(index);
        Optional<Map.Entry<ItemStack, Set<Integer>>> matching = AWCraftingManager.getMatchingStackEntry(stackIngredientIndexes, stack);
        if (matching.isPresent()) {
            Map.Entry<ItemStack, Set<Integer>> entry = matching.get();
            entry.getKey().func_190917_f(count);
            entry.getValue().add(index);
        } else {
            HashSet<Integer> indexes = new HashSet<Integer>();
            indexes.add(index);
            ItemStack stackCopy = stack.func_77946_l();
            stackCopy.func_190920_e(count);
            stackIngredientIndexes.put(stackCopy, indexes);
        }
    }

    private static int getIngredientIndexForStack(Map<Integer, IngredientMatchData> ingredientsData, Set<Integer> matchedIngredientIndexes, ItemStack stack) {
        for (Map.Entry<Integer, IngredientMatchData> ingredientData : ingredientsData.entrySet()) {
            IngredientMatchData data = ingredientData.getValue();
            if (matchedIngredientIndexes.contains(data.index) || !data.ingredient.apply(stack)) continue;
            return data.index;
        }
        return -1;
    }

    private static Optional<Map.Entry<ItemStack, Set<Integer>>> getMatchingStackEntry(Map<ItemStack, Set<Integer>> stacks, ItemStack stackToFind) {
        for (Map.Entry<ItemStack, Set<Integer>> entry : stacks.entrySet()) {
            if (!InventoryTools.doItemStacksMatch(entry.getKey(), stackToFind)) continue;
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    private static Map<Integer, Ingredient> getSlotIngredients(Map<Integer, IngredientMatchData> ingredientsData) {
        HashMap<Integer, Ingredient> ret = new HashMap<Integer, Ingredient>();
        ingredientsData.forEach((slot, ingredientData) -> ret.put((Integer)slot, ingredientData.ingredient));
        return ret;
    }

    private static <T> T processFailedIngredients(BiFunction<T, Ingredient, T> onFail, T ret, Map<Integer, Ingredient> remainingIngredients) {
        for (Ingredient ingredient : remainingIngredients.values()) {
            ret = onFail.apply(ret, ingredient);
        }
        return ret;
    }

    private static Map<Integer, IngredientMatchData> getIngredientData(NonNullList<Ingredient> ingredients) {
        LinkedHashMap<Integer, IngredientMatchData> ret = new LinkedHashMap<Integer, IngredientMatchData>();
        for (int slot = 0; slot < ingredients.size(); ++slot) {
            Ingredient ingredient = (Ingredient)ingredients.get(slot);
            if (ingredient.apply(ItemStack.field_190927_a)) continue;
            ret.put(slot, AWCraftingManager.getSlotIngredient(slot, ingredient));
        }
        return ret;
    }

    private static IngredientMatchData getSlotIngredient(int slot, Ingredient ingredient) {
        return new IngredientMatchData(ingredient, slot, ingredient instanceof IIngredientCount ? ((IIngredientCount)ingredient).getCount() : 1);
    }

    public static ItemStack getIngredientInventoryMatch(IItemHandler clonedResourceInventory, Ingredient ingredient) {
        ItemStack stackFound = ItemStack.field_190927_a;
        int count = ingredient instanceof IIngredientCount ? ((IIngredientCount)ingredient).getCount() : 1;
        for (int slot = 0; slot < clonedResourceInventory.getSlots(); ++slot) {
            ItemStack removedStack;
            ItemStack resourceStack = clonedResourceInventory.getStackInSlot(slot);
            if (resourceStack.func_190926_b()) continue;
            ItemStack properCountStack = resourceStack.func_77946_l();
            properCountStack.func_190920_e(count);
            if (!ingredient.apply(properCountStack) || (removedStack = InventoryTools.removeItems(clonedResourceInventory, resourceStack, count, true)).func_190916_E() != count) continue;
            InventoryTools.removeItems(clonedResourceInventory, resourceStack, count, false);
            stackFound = removedStack;
            break;
        }
        return stackFound;
    }

    public static NonNullList<ItemStack> getReusableStacks(ICraftingRecipe recipe, InventoryCrafting craftMatrix) {
        return recipe.getRemainingItems(craftMatrix).stream().filter(s -> !s.func_190926_b() && recipe.getIngredients().stream().anyMatch(i -> i.apply(s))).collect(Collectors.toCollection(NonNullList::func_191196_a));
    }

    private static class IngredientMatchData {
        public Ingredient ingredient;
        public int index;
        public int count;
        public int remainingCount;

        private IngredientMatchData(Ingredient ingredient, int index, int count) {
            this.ingredient = ingredient;
            this.index = index;
            this.count = count;
            this.remainingCount = count;
        }
    }
}

