/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.container;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;
import net.shadowmage.ancientwarfare.core.container.ContainerCraftingRecipeMemory;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.core.container.ICraftingContainer;
import net.shadowmage.ancientwarfare.core.crafting.AWCraftingManager;
import net.shadowmage.ancientwarfare.core.crafting.ICraftingRecipe;
import net.shadowmage.ancientwarfare.core.tile.TileEngineeringStation;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class ContainerEngineeringStation
extends ContainerTileBase<TileEngineeringStation>
implements ICraftingContainer {
    private static final int BOOK_SLOT = 1;
    private static final int CRAFTING_SLOT = 0;
    public ContainerCraftingRecipeMemory containerCrafting;
    private int currentCraftTotalSize = 0;

    public ContainerEngineeringStation(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        int y1;
        this.containerCrafting = new ContainerCraftingRecipeMemory(((TileEngineeringStation)this.tileEntity).craftingRecipeMemory, player){

            @Override
            protected ContainerCraftingRecipeMemory.OnTakeResult handleOnTake(EntityPlayer player, ItemStack stack) {
                ICraftingRecipe recipe = ((TileEngineeringStation)ContainerEngineeringStation.this.tileEntity).craftingRecipeMemory.getRecipe();
                NonNullList<ItemStack> reusableStacks = AWCraftingManager.getReusableStacks(recipe, ContainerEngineeringStation.this.containerCrafting.getCraftMatrix());
                NonNullList<ItemStack> resources = InventoryTools.removeItems(AWCraftingManager.getRecipeInventoryMatch(recipe, this.getCraftingStacks(), (IItemHandler)new CombinedInvWrapper(new IItemHandlerModifiable[]{((TileEngineeringStation)ContainerEngineeringStation.this.tileEntity).extraSlots, new ItemStackHandler(reusableStacks)})), reusableStacks);
                if (!resources.isEmpty()) {
                    InventoryTools.removeItems((IItemHandler)((TileEngineeringStation)ContainerEngineeringStation.this.tileEntity).extraSlots, resources);
                    ForgeHooks.setCraftingPlayer((EntityPlayer)player);
                    NonNullList<ItemStack> remainingItems = InventoryTools.removeItems(((TileEngineeringStation)ContainerEngineeringStation.this.tileEntity).craftingRecipeMemory.getRemainingItems(AWCraftingManager.fillCraftingMatrixFromInventory(resources)), reusableStacks);
                    ForgeHooks.setCraftingPlayer(null);
                    InventoryTools.insertOrDropItems((IItemHandler)((TileEngineeringStation)ContainerEngineeringStation.this.tileEntity).extraSlots, remainingItems, ((TileEngineeringStation)ContainerEngineeringStation.this.tileEntity).func_145831_w(), ((TileEngineeringStation)ContainerEngineeringStation.this.tileEntity).func_174877_v());
                    return new ContainerCraftingRecipeMemory.OnTakeResult(EnumActionResult.SUCCESS, stack);
                }
                return new ContainerCraftingRecipeMemory.OnTakeResult(EnumActionResult.PASS, stack);
            }

            @Override
            protected boolean canTakeStackFromOutput(EntityPlayer player) {
                return true;
            }
        };
        for (Slot slot : this.containerCrafting.getSlots()) {
            this.func_75146_a(slot);
        }
        for (y1 = 0; y1 < 2; ++y1) {
            int y2 = y1 * 18 + 8 + 54 + 4;
            for (int x1 = 0; x1 < 9; ++x1) {
                int x2 = x1 * 18 + 8;
                int slotNum = y1 * 9 + x1;
                SlotItemHandler slot = new SlotItemHandler((IItemHandler)((TileEngineeringStation)this.tileEntity).extraSlots, slotNum, x2, y2);
                this.func_75146_a((Slot)slot);
            }
        }
        y1 = 110;
        y1 = this.addPlayerSlots(y1);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("recipe")) {
            this.containerCrafting.handleRecipeUpdate(tag);
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack result = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        this.currentCraftTotalSize = 0;
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190896_a(List<ItemStack> p_190896_1_) {
        this.containerCrafting.setOpening(true);
        super.func_190896_a(p_190896_1_);
        this.containerCrafting.setOpening(false);
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        this.containerCrafting.setOpening(true);
        super.func_75141_a(slotID, stack);
        this.containerCrafting.setOpening(false);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotClickedIndex) {
        if (slotClickedIndex == 0 && !this.updateAndCheckCraftStackOrLessInTotal()) {
            return ItemStack.field_190927_a;
        }
        ItemStack slotStackCopy = ItemStack.field_190927_a;
        Slot theSlot = this.func_75139_a(slotClickedIndex);
        if (theSlot != null && theSlot.func_75216_d()) {
            ItemStack slotStack = theSlot.func_75211_c();
            slotStackCopy = slotStack.func_77946_l();
            int craftSlotStart = 2;
            int storageSlotsStart = craftSlotStart + ((TileEngineeringStation)this.tileEntity).craftingRecipeMemory.craftMatrix.func_70302_i_();
            int playerSlotStart = storageSlotsStart + ((TileEngineeringStation)this.tileEntity).extraSlots.getSlots();
            int playerSlotEnd = playerSlotStart + this.playerSlots;
            if (slotClickedIndex < craftSlotStart ? !this.func_75135_a(slotStack, playerSlotStart, playerSlotEnd, false) : (slotClickedIndex < storageSlotsStart ? !this.func_75135_a(slotStack, storageSlotsStart, playerSlotStart, false) : (slotClickedIndex < playerSlotStart ? !this.func_75135_a(slotStack, playerSlotStart, playerSlotEnd, false) : slotClickedIndex < playerSlotEnd && !this.func_75135_a(slotStack, 1, 2, false) && !this.func_75135_a(slotStack, storageSlotsStart, playerSlotStart, false)))) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190916_E() == 0) {
                theSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                theSlot.func_75218_e();
            }
            if (slotStack.func_190916_E() == slotStackCopy.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            theSlot.func_190901_a(par1EntityPlayer, slotStack);
        }
        return slotStackCopy;
    }

    private boolean updateAndCheckCraftStackOrLessInTotal() {
        ItemStack craftedStack = this.func_75139_a(0).func_75211_c();
        this.currentCraftTotalSize += craftedStack.func_190916_E();
        return this.currentCraftTotalSize <= craftedStack.func_77976_d();
    }

    @Override
    public ContainerCraftingRecipeMemory getCraftingMemoryContainer() {
        return this.containerCrafting;
    }

    @Override
    public IItemHandlerModifiable[] getInventories() {
        return new IItemHandlerModifiable[]{((TileEngineeringStation)this.tileEntity).extraSlots, new PlayerInvWrapper(this.player.field_71071_by)};
    }

    @Override
    public boolean pushCraftingMatrixToInventories() {
        InvWrapper craftMatrixWrapper = new InvWrapper((IInventory)((TileEngineeringStation)this.tileEntity).craftingRecipeMemory.craftMatrix);
        NonNullList<ItemStack> craftingItems = InventoryTools.getItems((IItemHandler)craftMatrixWrapper);
        CombinedInvWrapper inventories = new CombinedInvWrapper(new IItemHandlerModifiable[]{((TileEngineeringStation)this.tileEntity).extraSlots, new PlayerInvWrapper(this.player.field_71071_by)});
        if (InventoryTools.insertItems((IItemHandler)inventories, craftingItems, true).isEmpty()) {
            InventoryTools.insertItems((IItemHandler)inventories, craftingItems, false);
            InventoryTools.removeItems((IItemHandler)craftMatrixWrapper, craftingItems);
            return true;
        }
        return false;
    }
}

