/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.container;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.init.AWCoreItems;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class ContainerBackpack
extends ContainerBase {
    private ItemStack backpackStack;
    public final int backpackSlotIndex;
    public final EnumHand hand;
    public final int guiHeight;
    private final IItemHandler handler;

    public ContainerBackpack(EntityPlayer player, int x, int y, int z) {
        super(player);
        this.hand = EntityTools.getHandHoldingItem((EntityLivingBase)player, AWCoreItems.BACKPACK);
        this.backpackStack = player.func_184586_b(this.hand);
        this.backpackSlotIndex = this.hand == EnumHand.MAIN_HAND ? player.field_71071_by.field_70461_c : -1;
        this.handler = InventoryTools.cloneItemHandler((IItemHandler)this.backpackStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            int xPos = i % 9 * 18 + 8;
            int yPos = i / 9 * 18 + 8;
            this.func_75146_a((Slot)new SlotItemHandler(this.handler, i, xPos, yPos){

                public boolean func_75214_a(ItemStack itemStack) {
                    return itemStack.func_77973_b() != AWCoreItems.BACKPACK && super.func_75214_a(itemStack);
                }
            });
        }
        int height = (this.backpackStack.func_77952_i() + 1) * 18 + 8;
        this.guiHeight = this.addPlayerSlots(height + 8) + 8;
    }

    @Override
    protected int addPlayerSlots(int tx, int ty, int gap) {
        int yPos;
        int xPos;
        int slotNum;
        int x;
        IItemHandler playerInventory = (IItemHandler)this.player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        for (x = 0; x < 9; ++x) {
            slotNum = x;
            if (slotNum == this.backpackSlotIndex) continue;
            xPos = tx + x * 18;
            yPos = ty + gap + 54;
            this.func_75146_a((Slot)new SlotItemHandler(playerInventory, x, xPos, yPos));
        }
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                slotNum = y * 9 + x + 9;
                xPos = tx + x * 18;
                yPos = ty + y * 18;
                this.func_75146_a((Slot)new SlotItemHandler(playerInventory, slotNum, xPos, yPos));
            }
        }
        this.playerSlots = 35;
        return ty + 72 + gap;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        IItemHandlerModifiable backpackHandler = (IItemHandlerModifiable)this.backpackStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int slot = 0; slot < this.handler.getSlots(); ++slot) {
            backpackHandler.setStackInSlot(slot, this.handler.getStackInSlot(slot));
        }
        super.func_75134_a(playerIn);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotClickedIndex) {
        ItemStack slotStackCopy = ItemStack.field_190927_a;
        Slot theSlot = this.func_75139_a(slotClickedIndex);
        int size = this.handler.getSlots();
        if (theSlot != null && theSlot.func_75216_d()) {
            ItemStack slotStack = theSlot.func_75211_c();
            slotStackCopy = slotStack.func_77946_l();
            if (slotClickedIndex < size ? !this.func_75135_a(slotStack, size, size + this.playerSlots, false) : !this.func_75135_a(slotStack, 0, size, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190916_E() == 0) {
                theSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                theSlot.func_75218_e();
            }
            if (slotStack.func_190916_E() == slotStackCopy.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            theSlot.func_190901_a(par1EntityPlayer, slotStack);
        }
        return slotStackCopy;
    }
}

