/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.shadowmage.ancientwarfare.core.compat.jei.PacketTransferRecipe;
import net.shadowmage.ancientwarfare.core.config.AWCoreStatics;
import net.shadowmage.ancientwarfare.core.container.ICraftingContainer;
import net.shadowmage.ancientwarfare.core.crafting.AWCraftingManager;
import net.shadowmage.ancientwarfare.core.crafting.ICraftingRecipe;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class MultiRecipeTransferHandler<C extends Container>
implements IRecipeTransferHandler<C> {
    private final IRecipeTransferHandlerHelper handlerHelper;
    private Class<C> containerClass;

    public MultiRecipeTransferHandler(Class<C> containerClass, IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
        this.containerClass = containerClass;
    }

    public Class<C> getContainerClass() {
        return this.containerClass;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IRecipeTransferError transferRecipe(C container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        ItemStack result = (ItemStack)((IGuiIngredient)stacks.getGuiIngredients().get(0)).getDisplayedIngredient();
        NonNullList inputs = NonNullList.func_191196_a();
        for (int i = 0; i < stacks.getGuiIngredients().size(); ++i) {
            IGuiIngredient ingredient = (IGuiIngredient)stacks.getGuiIngredients().get(i);
            if (!ingredient.isInput()) continue;
            if (ingredient.getAllIngredients().isEmpty()) {
                inputs.add((Object)ItemStack.field_190927_a);
                continue;
            }
            inputs.add((Object)this.getNonNullIngredientStack(ingredient.getAllIngredients()));
        }
        ICraftingRecipe recipe = AWCraftingManager.findMatchingRecipe((World)Minecraft.func_71410_x().field_71441_e, (NonNullList<ItemStack>)inputs, result);
        if (AWCoreStatics.useResearchSystem && recipe.getNeededResearch().isPresent()) {
            String tooltipMessage;
            if (((ICraftingContainer)container).getCraftingMemoryContainer().getCrafterName() == null) {
                tooltipMessage = I18n.func_135052_a((String)"jei.tooltip.error.recipe.transfer.no.research_book", (Object[])new Object[0]);
                return this.handlerHelper.createUserErrorWithTooltip(tooltipMessage);
            }
            if (!AWCraftingManager.canPlayerCraft((World)Minecraft.func_71410_x().field_71441_e, ((ICraftingContainer)container).getCraftingMemoryContainer().getCrafterName(), recipe.getNeededResearch().get())) {
                tooltipMessage = I18n.func_135052_a((String)"jei.tooltip.error.recipe.transfer.missing.research", (Object[])new Object[0]);
                return this.handlerHelper.createUserErrorWithTooltip(tooltipMessage);
            }
        }
        List<Slot> craftingSlots = ((ICraftingContainer)container).getCraftingMemoryContainer().getCraftingMatrixSlots();
        NonNullList craftingMatrixStacks = NonNullList.func_191196_a();
        for (Slot slot : craftingSlots) {
            ItemStack stack = slot.func_75211_c();
            if (stack.func_190926_b()) continue;
            craftingMatrixStacks.add((Object)stack.func_77946_l());
        }
        CombinedInvWrapper inventories = new CombinedInvWrapper(((ICraftingContainer)container).getInventories());
        CombinedInvWrapper allInventories = new CombinedInvWrapper(new IItemHandlerModifiable[]{new ItemStackHandler(craftingMatrixStacks), inventories});
        if (!InventoryTools.insertItems((IItemHandler)inventories, (List<ItemStack>)craftingMatrixStacks, true).isEmpty()) {
            String message = I18n.func_135052_a((String)"jei.tooltip.error.recipe.transfer.inventory.full", (Object[])new Object[0]);
            return this.handlerHelper.createUserErrorWithTooltip(message);
        }
        List<Integer> missingItems = this.getMissingItems((NonNullList<ItemStack>)inputs, recipe, (IItemHandlerModifiable)allInventories);
        if (!missingItems.isEmpty()) {
            String message = I18n.func_135052_a((String)"jei.tooltip.error.recipe.transfer.missing", (Object[])new Object[0]);
            return this.handlerHelper.createUserErrorForSlots(message, missingItems);
        }
        if (doTransfer) {
            NetworkHandler.sendToServer(new PacketTransferRecipe(recipe));
        }
        return null;
    }

    private List<Integer> getMissingItems(NonNullList<ItemStack> inputs, ICraftingRecipe recipe, IItemHandlerModifiable allInventories) {
        return AWCraftingManager.getRecipeInventoryMatch(recipe, inputs, s -> InventoryTools.hasCountOrMore((IItemHandler)allInventories, s), (IItemHandler)allInventories, ArrayList::new, (a, i, s) -> {}, (a, in) -> this.addMissingItem((List<Integer>)a, (Ingredient)in, inputs));
    }

    private ItemStack getNonNullIngredientStack(List<ItemStack> allIngredients) {
        for (ItemStack stack : allIngredients) {
            if (stack == null) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private void addMissingItem(List<Integer> missingItems, Ingredient missingIngredient, NonNullList<ItemStack> inputs) {
        List matchingStacks = inputs.stream().filter(s -> missingIngredient.apply(s) && !missingItems.contains(this.getInputIndex(inputs.indexOf(s)))).collect(Collectors.toList());
        if (!matchingStacks.isEmpty()) {
            ItemStack matched = (ItemStack)matchingStacks.get(matchingStacks.size() - 1);
            for (int i = inputs.size() - 1; i >= 0; --i) {
                if (missingItems.contains(this.getInputIndex(i)) || inputs.get(i) != matched) continue;
                missingItems.add(this.getInputIndex(i));
            }
        }
    }

    private int getInputIndex(int craftMatrixIndex) {
        int firstInputIndex = 1;
        return craftMatrixIndex + firstInputIndex;
    }
}

