/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.command;

import com.google.common.collect.AbstractIterator;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import net.shadowmage.ancientwarfare.core.command.ISubCommand;
import net.shadowmage.ancientwarfare.core.command.RootCommand;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketManualReload;
import net.shadowmage.ancientwarfare.core.util.FileUtils;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;

public class CommandUtils
extends RootCommand {
    private static final Field BIOME_NAME = ObfuscationReflectionHelper.findField(Biome.class, (String)"field_76791_y");

    public CommandUtils() {
        this.registerSubCommand(new EntityListCommand());
        this.registerSubCommand(new EntityListCommand());
        this.registerSubCommand(new BiomeListCommand());
        this.registerSubCommand(new BlockListCommand());
        this.registerSubCommand(new ReloadManualCommand());
        this.registerSubCommand(new LootTableListCommand());
        this.registerSubCommand(new ChunkLoadCommand());
    }

    public String func_71517_b() {
        return "awutils";
    }

    private static class ChunkLoadCommand
    implements ISubCommand {
        private PlayerMover playerMover = new PlayerMover();

        private ChunkLoadCommand() {
            MinecraftForge.EVENT_BUS.register((Object)this.playerMover);
        }

        @Override
        public String getName() {
            return "loadChunks";
        }

        @Override
        public void execute(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length < 1) {
                throw new WrongUsageException(this.getUsage(sender), new Object[0]);
            }
            if (!(sender instanceof EntityPlayerMP)) {
                return;
            }
            int chunkLoadRadius = server.func_184103_al().func_72395_o();
            int range = Integer.parseInt(args[0]);
            this.playerMover.startMoving((EntityPlayerMP)sender, sender.func_130014_f_(), chunkLoadRadius, range);
        }

        @Override
        public int getMaxArgs() {
            return 1;
        }

        @Override
        public String getUsage(ICommandSender sender) {
            return this.getName() + " <diameterInChunks>";
        }

        private static class PlayerMover {
            private EntityPlayerMP player;
            private int chunkLoadRadius;
            private int range;
            private BlockPos originalPosition;
            private ChunkPos originalChunkPos;
            private boolean finishedMoving = true;
            private Iterator<ChunkPos> iterator;
            private int timeout = 0;

            private PlayerMover() {
            }

            @SubscribeEvent
            public void serverTick(TickEvent.ServerTickEvent evt) {
                if (evt.phase == TickEvent.Phase.END) {
                    if (this.timeout <= 0) {
                        this.movePlayer();
                        this.timeout = 200;
                    } else {
                        --this.timeout;
                    }
                }
            }

            private void startMoving(EntityPlayerMP player, World world, int chunkLoadRadius, int range) {
                this.player = player;
                this.originalPosition = player.func_180425_c();
                this.originalChunkPos = world.func_175726_f(this.originalPosition).func_76632_l();
                this.chunkLoadRadius = chunkLoadRadius;
                this.range = range;
                this.finishedMoving = false;
                this.iterator = this.getAllChunkPosStops();
            }

            private Iterator<ChunkPos> getAllChunkPosStops() {
                return new AbstractIterator<ChunkPos>(){
                    private boolean first = true;
                    private int currentX;
                    private int currentZ;

                    protected ChunkPos computeNext() {
                        if (this.first) {
                            this.currentX = this.getInitialX();
                            this.currentZ = this.getInitialZ();
                            this.first = false;
                        } else {
                            if (this.currentX + chunkLoadRadius >= ((PlayerMover)this).originalChunkPos.field_77276_a + range && this.currentZ + chunkLoadRadius >= ((PlayerMover)this).originalChunkPos.field_77275_b + range) {
                                return (ChunkPos)this.endOfData();
                            }
                            if (this.currentX + chunkLoadRadius < ((PlayerMover)this).originalChunkPos.field_77276_a + range) {
                                this.currentX += 2 * chunkLoadRadius;
                            } else if (this.currentZ + chunkLoadRadius < ((PlayerMover)this).originalChunkPos.field_77275_b + range) {
                                this.currentX = this.getInitialX();
                                this.currentZ += 2 * chunkLoadRadius;
                            }
                        }
                        return new ChunkPos(this.currentX, this.currentZ);
                    }

                    private int getInitialZ() {
                        return ((PlayerMover)this).originalChunkPos.field_77275_b - range + chunkLoadRadius;
                    }

                    private int getInitialX() {
                        return ((PlayerMover)this).originalChunkPos.field_77276_a - range + chunkLoadRadius;
                    }
                };
            }

            private void movePlayer() {
                if (!this.finishedMoving) {
                    if (!this.iterator.hasNext()) {
                        this.player.field_71135_a.func_147364_a((double)this.originalPosition.func_177958_n(), (double)this.originalPosition.func_177956_o(), (double)this.originalPosition.func_177952_p(), this.player.field_70177_z, this.player.field_70125_A);
                        this.finishedMoving = true;
                        return;
                    }
                    ChunkPos chunkPos = this.iterator.next();
                    this.player.field_71135_a.func_147364_a((double)chunkPos.func_180334_c() + 8.0, 255.0, (double)chunkPos.func_180333_d() + 8.0, this.player.field_70177_z, this.player.field_70125_A);
                }
            }
        }
    }

    private static class LootTableListCommand
    extends ExportCommand {
        private LootTableListCommand() {
        }

        @Override
        protected String getHeader() {
            return "Registry Name";
        }

        @Override
        protected String getDefaultFileName() {
            return "loottablelist.csv";
        }

        @Override
        protected List<String> getLines() {
            return LootTableList.func_186374_a().stream().map(ResourceLocation::toString).collect(Collectors.toList());
        }

        @Override
        public String getName() {
            return "exportloottables";
        }

        @Override
        public String getUsage(ICommandSender sender) {
            return this.getName() + " [fileName - defaults to \"loottablelist.csv\"]";
        }
    }

    private static class ReloadManualCommand
    implements ISubCommand {
        private ReloadManualCommand() {
        }

        @Override
        public String getName() {
            return "reloadmanual";
        }

        @Override
        public void execute(MinecraftServer server, ICommandSender sender, String[] args) {
            Entity senderEntity = sender.func_174793_f();
            if (senderEntity instanceof EntityPlayer) {
                NetworkHandler.sendToPlayer((EntityPlayerMP)senderEntity, new PacketManualReload());
            }
        }

        @Override
        public int getMaxArgs() {
            return 0;
        }

        @Override
        public String getUsage(ICommandSender sender) {
            return this.getName();
        }
    }

    private static class BlockListCommand
    extends ExportCommand {
        private BlockListCommand() {
        }

        @Override
        protected String getHeader() {
            return "Registry Name,Block Name,Skippable,Skippable Material,Target,Target Material";
        }

        @Override
        protected String getDefaultFileName() {
            return "blocklist.csv";
        }

        @Override
        protected List<String> getLines() {
            return ForgeRegistries.BLOCKS.getValuesCollection().stream().map(b -> String.join((CharSequence)",", b.getRegistryName().toString(), b.func_149732_F(), AWStructureStatics.isSkippable(b.func_176223_P()) ? "Y" : "N", AWStructureStatics.isSkippableMaterial(b.func_176223_P().func_185904_a()) ? "Y" : "N", AWStructureStatics.isValidTargetBlock(b.func_176223_P()) ? "Y" : "N", AWStructureStatics.isValidTargetMaterial(b.func_176223_P().func_185904_a()) ? "Y" : "N")).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        }

        @Override
        public String getName() {
            return "exportblocks";
        }

        @Override
        public String getUsage(ICommandSender sender) {
            return this.getName() + " [fileName - defaults to \"blocklist.csv\"]";
        }
    }

    private static class BiomeListCommand
    extends ExportCommand {
        private BiomeListCommand() {
        }

        @Override
        protected String getHeader() {
            return "Registry Name,Biome Name,Temperature Category,High Humidity,Height Variation,Top Block,Biome Types,Biome Class";
        }

        @Override
        protected String getDefaultFileName() {
            return "biomelist.csv";
        }

        @Override
        protected List<String> getLines() {
            return ForgeRegistries.BIOMES.getValuesCollection().stream().map(b -> String.join((CharSequence)",", b.getRegistryName().toString(), this.getBiomeName((Biome)b), b.func_150561_m().name(), Boolean.toString(b.func_76736_e()), Float.toString(b.func_185360_m()), b.field_76752_A.func_177230_c().getRegistryName().toString(), BiomeDictionary.getTypes((Biome)b).stream().map(BiomeDictionary.Type::getName).collect(Collectors.joining("|")), b.func_150562_l().toString())).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        }

        private String getBiomeName(Biome b) {
            try {
                return (String)BIOME_NAME.get(b);
            }
            catch (IllegalAccessException e) {
                AncientWarfareCore.LOG.error((Object)e);
                return "";
            }
        }

        @Override
        public String getName() {
            return "exportbiomes";
        }

        @Override
        public String getUsage(ICommandSender sender) {
            return this.getName() + " [fileName - defaults to \"biomelist.csv\"]";
        }
    }

    private static class EntityListCommand
    extends ExportCommand {
        private EntityListCommand() {
        }

        @Override
        protected String getHeader() {
            return "Registry Name,Entity Name,Entity Class";
        }

        @Override
        protected String getDefaultFileName() {
            return "entitylist.csv";
        }

        @Override
        protected List<String> getLines() {
            return ForgeRegistries.ENTITIES.getValuesCollection().stream().map(e -> String.join((CharSequence)",", e.getRegistryName().toString(), e.getName(), e.getEntityClass().toString())).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        }

        @Override
        public String getName() {
            return "exportentities";
        }

        @Override
        public String getUsage(ICommandSender sender) {
            return this.getName() + " [fileName - defaults to \"entitylist.csv\"]";
        }
    }

    private static abstract class ExportCommand
    implements ISubCommand {
        private ExportCommand() {
        }

        @Override
        public void execute(MinecraftServer server, ICommandSender sender, String[] args) {
            List<String> lines = this.getLines();
            String fileName = args.length > 0 ? args[0] : this.getDefaultFileName();
            String filePath = "config/ancientwarfare//export/";
            File file = new File(filePath, fileName);
            ExportCommand.exportToFile(file, this.getHeader(), lines);
            ExportCommand.notifyPlayer(sender, file);
        }

        protected abstract String getHeader();

        protected abstract String getDefaultFileName();

        protected abstract List<String> getLines();

        private static void exportToFile(File exportFile, String header, List<String> data) {
            ArrayList<String> rows = new ArrayList<String>();
            rows.add(header);
            rows.addAll(data);
            FileUtils.exportToFile(exportFile, rows);
        }

        private static void notifyPlayer(ICommandSender sender, File exportFile) {
            sender.func_145747_a((ITextComponent)new TextComponentString("File exported to " + exportFile.getAbsoluteFile()));
        }

        @Override
        public int getMaxArgs() {
            return 1;
        }
    }
}

