/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.HorizontalAABB;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.ITree;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.ITreeScanner;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.Tree;
import net.shadowmage.ancientwarfare.core.util.BlockTools;

public class DefaultTreeScanner
implements ITreeScanner {
    private final Predicate<IBlockState> trunkMatcher;
    private final Set<Predicate<IBlockState>> leafMatchers = new HashSet<Predicate<IBlockState>>();
    private int maxLeafDistance;
    private INextPositionGetter nextPositionGetter;
    private static final int MAX_TRUNK_DISTANCE = 1;
    public static final INextPositionGetter ALL_AROUND = currentPos -> {
        Iterable<BlockPos> blocksInBox = DefaultTreeScanner.getPositionsInBoxOrderedByY(currentPos.func_177982_a(-1, -1, -1), currentPos.func_177982_a(1, 1, 1));
        return StreamSupport.stream(blocksInBox.spliterator(), false);
    };
    public static final INextPositionGetter CONNECTED_AROUND = currentPos -> Arrays.stream(EnumFacing.field_82609_l).map(arg_0 -> ((BlockPos)currentPos).func_177972_a(arg_0));
    public static final INextPositionGetter CONNECTED_UP_OR_LEVEL = new INextPositionGetter(){
        private final EnumFacing[] offsets = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.UP};

        @Override
        public Stream<BlockPos> getPositionsToScan(BlockPos currentPos) {
            return Arrays.stream(this.offsets).map(arg_0 -> ((BlockPos)currentPos).func_177972_a(arg_0));
        }
    };
    public static final INextPositionGetter CONNECTED_DOWN_OR_LEVEL = new INextPositionGetter(){
        private final EnumFacing[] offsets = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.DOWN};

        @Override
        public Stream<BlockPos> getPositionsToScan(BlockPos currentPos) {
            return Arrays.stream(this.offsets).map(arg_0 -> ((BlockPos)currentPos).func_177972_a(arg_0));
        }
    };
    public static final INextPositionGetter ALL_UP_OR_LEVEL = currentPos -> {
        Iterable<BlockPos> blocksInBox = DefaultTreeScanner.getPositionsInBoxOrderedByY(currentPos.func_177982_a(-1, 0, -1), currentPos.func_177982_a(1, 1, 1));
        return StreamSupport.stream(blocksInBox.spliterator(), false);
    };

    public Predicate<IBlockState> getTrunkMatcher() {
        return this.trunkMatcher;
    }

    public void addLeafMatcher(Predicate<IBlockState> leafMatcher) {
        this.leafMatchers.add(leafMatcher);
    }

    public DefaultTreeScanner(Predicate<IBlockState> trunkMatcher, Predicate<IBlockState> leafMatcher) {
        this(trunkMatcher, leafMatcher, CONNECTED_UP_OR_LEVEL, 5);
    }

    public DefaultTreeScanner(Predicate<IBlockState> trunkMatcher, Predicate<IBlockState> leafMatcher, INextPositionGetter nextPosGetter, int maxLeafDistance) {
        this.trunkMatcher = trunkMatcher;
        this.leafMatchers.add(leafMatcher);
        this.maxLeafDistance = maxLeafDistance;
        this.nextPositionGetter = nextPosGetter;
    }

    @Override
    public ITree scanTree(World world, BlockPos pos, BlockPos minPos, BlockPos maxPos) {
        HorizontalAABB trunkBounds = new HorizontalAABB(pos);
        if (!this.isTrunk(world.func_180495_p(pos))) {
            return Tree.EMPTY;
        }
        ArrayList<Object> openList = new ArrayList<Object>();
        HashSet<BlockPos> alreadyScanned = new HashSet<BlockPos>();
        openList.add(pos);
        alreadyScanned.add(pos);
        Tree tree = new Tree(pos);
        while (!openList.isEmpty()) {
            BlockPos current = (BlockPos)openList.remove(0);
            Set toScan = this.nextPositionGetter.getPositionsToScan(current).filter(p -> !alreadyScanned.contains(p)).collect(Collectors.toCollection(LinkedHashSet::new));
            openList.addAll(this.addTreeBlocks(toScan, world, tree, trunkBounds, minPos, maxPos));
            alreadyScanned.addAll(toScan);
        }
        return tree;
    }

    private Collection<? extends BlockPos> addTreeBlocks(Set<BlockPos> toScan, World world, Tree tree, HorizontalAABB trunkBounds, BlockPos minPos, BlockPos maxPos) {
        HashSet<BlockPos> treeBlocks = new HashSet<BlockPos>();
        for (BlockPos pos : toScan) {
            if (!BlockTools.isPositionWithinHorizontalBounds(pos, minPos, maxPos)) continue;
            IBlockState state = world.func_180495_p(pos);
            if (this.isTrunk(state)) {
                tree.addTrunkPosition(pos);
                treeBlocks.add(pos);
                if (trunkBounds.distanceTo(pos) > 1) continue;
                trunkBounds.include(pos);
                continue;
            }
            if (!this.isLeaf(state) || trunkBounds.distanceTo(pos) > this.maxLeafDistance) continue;
            tree.addLeafPosition(pos);
            treeBlocks.add(pos);
        }
        return treeBlocks;
    }

    private boolean isLeaf(IBlockState state) {
        return this.leafMatchers.stream().anyMatch(m -> m.test(state));
    }

    private boolean isTrunk(IBlockState state) {
        return this.trunkMatcher.test(state);
    }

    private static Iterable<BlockPos> getPositionsInBoxOrderedByY(BlockPos corner1, BlockPos corner2) {
        return DefaultTreeScanner.getPositionsInBoxOrderedByY(Math.min(corner1.func_177958_n(), corner2.func_177958_n()), Math.min(corner1.func_177956_o(), corner2.func_177956_o()), Math.min(corner1.func_177952_p(), corner2.func_177952_p()), Math.max(corner1.func_177958_n(), corner2.func_177958_n()), Math.max(corner1.func_177956_o(), corner2.func_177956_o()), Math.max(corner1.func_177952_p(), corner2.func_177952_p()));
    }

    private static Iterable<BlockPos> getPositionsInBoxOrderedByY(final int x1, final int y1, final int z1, final int x2, final int y2, final int z2) {
        return () -> new AbstractIterator<BlockPos>(){
            private boolean first = true;
            private int lastPosX;
            private int lastPosY;
            private int lastPosZ;

            protected BlockPos computeNext() {
                if (this.first) {
                    this.first = false;
                    this.lastPosX = x1;
                    this.lastPosY = y1;
                    this.lastPosZ = z1;
                    return new BlockPos(x1, y1, z1);
                }
                if (this.lastPosX == x2 && this.lastPosY == y2 && this.lastPosZ == z2) {
                    return (BlockPos)this.endOfData();
                }
                if (this.lastPosX < x2) {
                    ++this.lastPosX;
                } else if (this.lastPosZ < z2) {
                    this.lastPosX = x1;
                    ++this.lastPosZ;
                } else if (this.lastPosY < y2) {
                    this.lastPosX = x1;
                    this.lastPosZ = z1;
                    ++this.lastPosY;
                }
                return new BlockPos(this.lastPosX, this.lastPosY, this.lastPosZ);
            }
        };
    }

    @Override
    public boolean matches(IBlockState state) {
        return this.trunkMatcher.test(state);
    }

    public static interface INextPositionGetter {
        public Stream<BlockPos> getPositionsToScan(BlockPos var1);
    }
}

