/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.worksite;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.shadowmage.ancientwarfare.automation.tile.worksite.IWorksiteAction;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBase;
import net.shadowmage.ancientwarfare.core.crafting.AWCraftingManager;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.tile.CraftingRecipeMemory;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class TileAutoCrafting
extends TileWorksiteBase {
    public CraftingRecipeMemory craftingRecipeMemory = new CraftingRecipeMemory(this);
    public ItemStackHandler outputInventory = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            TileAutoCrafting.this.func_70296_d();
        }
    };
    public ItemStackHandler resourceInventory = new ItemStackHandler(18){

        protected void onContentsChanged(int slot) {
            TileAutoCrafting.this.func_70296_d();
        }
    };
    private boolean canHoldLastCheck = false;
    private static final CraftAction CRAFT_ACTION = new CraftAction();

    @Override
    public void onBlockBroken(IBlockState state) {
        this.craftingRecipeMemory.dropInventory();
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.outputInventory, this.field_174879_c);
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.resourceInventory, this.field_174879_c);
        super.onBlockBroken(state);
    }

    public boolean tryCraftItem() {
        if (this.canHold()) {
            NonNullList<ItemStack> reusableStacks = AWCraftingManager.getReusableStacks(this.craftingRecipeMemory.getRecipe(), this.craftingRecipeMemory.craftMatrix);
            NonNullList<ItemStack> resources = InventoryTools.removeItems(AWCraftingManager.getRecipeInventoryMatch(this.craftingRecipeMemory.getRecipe(), this.craftingRecipeMemory.getCraftingStacks(), (IItemHandler)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.resourceInventory, new ItemStackHandler(reusableStacks)})), reusableStacks);
            if (!resources.isEmpty()) {
                this.craftItem(resources, reusableStacks);
                return true;
            }
        }
        return false;
    }

    private void craftItem(NonNullList<ItemStack> resources, NonNullList<ItemStack> reusableStacks) {
        InventoryCrafting invCrafting = AWCraftingManager.fillCraftingMatrixFromInventory(resources);
        ItemStack result = this.craftingRecipeMemory.getCraftingResult(invCrafting);
        InventoryTools.removeItems((IItemHandler)this.resourceInventory, resources);
        NonNullList<ItemStack> remainingItems = InventoryTools.removeItems(this.craftingRecipeMemory.getRemainingItems(invCrafting), reusableStacks);
        for (ItemStack stack : remainingItems) {
            if (stack.func_190926_b()) continue;
            if (!InventoryTools.removeItem(resources, is -> ItemStack.func_77989_b((ItemStack)stack, (ItemStack)is), stack.func_190916_E(), true).func_190926_b()) {
                InventoryTools.insertOrDropItem((IItemHandler)this.resourceInventory, stack, this.field_145850_b, this.field_174879_c);
                continue;
            }
            InventoryTools.insertOrDropItem((IItemHandler)this.outputInventory, stack, this.field_145850_b, this.field_174879_c);
        }
        InventoryTools.insertOrDropItem((IItemHandler)this.outputInventory, result, this.field_145850_b, this.field_174879_c);
    }

    @Override
    public IWorkSite.WorkType getWorkType() {
        return IWorkSite.WorkType.CRAFTING;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.craftingRecipeMemory.readFromNBT(tag);
        this.resourceInventory.deserializeNBT(tag.func_74775_l("resourceInventory"));
        this.outputInventory.deserializeNBT(tag.func_74775_l("outputInventory"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.craftingRecipeMemory.writeToNBT(tag);
        tag.func_74782_a("resourceInventory", (NBTBase)this.resourceInventory.serializeNBT());
        tag.func_74782_a("outputInventory", (NBTBase)this.outputInventory.serializeNBT());
        return tag;
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        this.craftingRecipeMemory.writeToNBT(tag);
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.craftingRecipeMemory.readFromNBT(tag);
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player, @Nullable EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 15, this.field_174879_c);
        }
        return true;
    }

    @Override
    protected Optional<IWorksiteAction> getNextAction() {
        return this.canHoldLastCheck && !this.craftingRecipeMemory.getRecipe().getRecipeOutput().func_190926_b() ? Optional.of(CRAFT_ACTION) : Optional.empty();
    }

    @Override
    protected boolean processAction(IWorksiteAction action) {
        return this.tryCraftItem();
    }

    @Override
    protected void updateWorksite() {
        this.canHoldLastCheck = this.canHold();
    }

    private boolean canHold() {
        ItemStack test = this.craftingRecipeMemory.getRecipe().getRecipeOutput();
        return !test.func_190926_b() && InventoryTools.canInventoryHold((IItemHandler)this.outputInventory, test);
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.outputInventory;
            }
            return (T)this.resourceInventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    private static class CraftAction
    implements IWorksiteAction {
        private CraftAction() {
        }

        @Override
        public double getEnergyConsumed(double efficiencyBonusFactor) {
            return IWorkSite.WorksiteImplementation.getEnergyPerActivation(efficiencyBonusFactor);
        }
    }
}

