/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseStorage;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IWarehouseStorageTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileControlled;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseBase;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.WarehouseStorageFilter;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.inventory.InventorySlotlessBasic;
import net.shadowmage.ancientwarfare.core.inventory.ItemQuantityMap;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.tile.IBlockBreakHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;

public class TileWarehouseStorage
extends TileControlled
implements IWarehouseStorageTile,
IInteractableTile,
IBlockBreakHandler {
    private InventorySlotlessBasic inventory;
    private final List<WarehouseStorageFilter> filters = new ArrayList<WarehouseStorageFilter>();
    private final Set<ContainerWarehouseStorage> viewers = new HashSet<ContainerWarehouseStorage>();

    public TileWarehouseStorage() {
        this.inventory = new InventorySlotlessBasic(this.getStorageAdditionSize());
    }

    @Override
    public ItemStack tryAdd(ItemStack cursorStack) {
        int moved = this.insertItem(cursorStack, cursorStack.func_190916_E());
        this.getController().ifPresent(controller -> {
            ItemStack filter = cursorStack.func_77946_l();
            filter.func_190920_e(1);
            controller.changeCachedQuantity(filter, moved);
        });
        cursorStack.func_190918_g(moved);
        if (cursorStack.func_190916_E() <= 0) {
            return ItemStack.field_190927_a;
        }
        return cursorStack;
    }

    @Override
    protected void updateTile() {
    }

    @Override
    public void onBlockBroken(IBlockState state) {
        ItemQuantityMap qtm = new ItemQuantityMap();
        this.addItems(qtm);
        NonNullList<ItemStack> list = qtm.getItems();
        for (ItemStack stack : list) {
            InventoryTools.dropItemInWorld(this.field_145850_b, stack, this.field_174879_c);
        }
    }

    @Override
    public int getStorageAdditionSize() {
        return 576;
    }

    @Override
    public void onWarehouseInventoryUpdated(TileWarehouseBase warehouse) {
    }

    @Override
    public List<WarehouseStorageFilter> getFilters() {
        return this.filters;
    }

    @Override
    public void setFilters(List<WarehouseStorageFilter> filters) {
        ArrayList<WarehouseStorageFilter> old = new ArrayList<WarehouseStorageFilter>();
        old.addAll(this.filters);
        this.filters.clear();
        this.filters.addAll(filters);
        this.getController().ifPresent(controller -> controller.onStorageFilterChanged(this, old, this.filters));
        this.updateViewers();
        this.func_70296_d();
    }

    @Override
    public void addItems(ItemQuantityMap map) {
        this.inventory.getItems(map);
    }

    @Override
    public int getQuantityStored(ItemStack filter) {
        return this.inventory.getQuantityStored(filter);
    }

    @Override
    public int getAvailableSpaceFor(ItemStack filter) {
        return this.inventory.getAvailableSpaceFor(filter);
    }

    @Override
    public int extractItem(ItemStack filter, int amount) {
        int removed = this.inventory.extractItem(filter, amount);
        this.updateViewersForInventory();
        if (removed > 0) {
            this.func_70296_d();
        }
        return removed;
    }

    @Override
    public int insertItem(ItemStack filter, int amount) {
        int inserted = this.inventory.insertItem(filter, amount);
        this.updateViewersForInventory();
        if (inserted > 0) {
            this.func_70296_d();
        }
        return inserted;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag.func_74775_l("inventory"));
        this.filters.addAll(NBTHelper.deserializeListFrom(tag, "filterList", WarehouseStorageFilter::new));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagCompound()));
        NBTHelper.writeSerializablesTo(tag, "filterList", this.filters);
        return tag;
    }

    @Override
    public void addViewer(ContainerWarehouseStorage containerWarehouseStorage) {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        this.viewers.add(containerWarehouseStorage);
    }

    @Override
    public void removeViewer(ContainerWarehouseStorage containerWarehouseStorage) {
        this.viewers.remove((Object)containerWarehouseStorage);
    }

    private void updateViewers() {
        for (ContainerWarehouseStorage viewer : this.viewers) {
            viewer.onFilterListUpdated();
        }
    }

    private void updateViewersForInventory() {
        for (ContainerWarehouseStorage viewer : this.viewers) {
            viewer.onStorageInventoryUpdated();
        }
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player, @Nullable EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 19, this.field_174879_c);
        }
        return true;
    }

    @Override
    public void handleSlotClick(EntityPlayer player, ItemStack filter, boolean shiftClick, boolean rightClick) {
        if (!shiftClick && !player.field_71071_by.func_70445_o().func_190926_b()) {
            this.tryAddItem(player, player.field_71071_by.func_70445_o());
        } else {
            this.tryGetItem(player, filter, shiftClick, rightClick);
        }
    }

    private void tryAddItem(EntityPlayer player, ItemStack cursorStack) {
        int stackSize = cursorStack.func_190916_E();
        int moved = this.insertItem(cursorStack, cursorStack.func_190916_E());
        this.getController().ifPresent(controller -> {
            ItemStack filter = cursorStack.func_77946_l();
            filter.func_190920_e(1);
            controller.changeCachedQuantity(filter, moved);
        });
        cursorStack.func_190918_g(moved);
        if (cursorStack.func_190916_E() <= 0) {
            player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
        }
        if (stackSize != cursorStack.func_190916_E()) {
            ((EntityPlayerMP)player).func_71113_k();
        }
    }

    private void tryGetItem(EntityPlayer player, ItemStack filter, boolean shiftClick, boolean rightClick) {
        int toMove;
        int stackSize = 0;
        if (!player.field_71071_by.func_70445_o().func_190926_b()) {
            stackSize = player.field_71071_by.func_70445_o().func_190916_E();
            ItemStack comparableStack = player.field_71071_by.func_70445_o().func_77946_l();
            comparableStack.func_190920_e(filter.func_190916_E());
            if (!ItemStack.func_77989_b((ItemStack)filter, (ItemStack)comparableStack)) {
                return;
            }
        }
        int count = this.getQuantityStored(filter);
        int toMoveMax = filter.func_77976_d();
        if (rightClick && toMoveMax > 1) {
            if (shiftClick) {
                toMoveMax = Math.min(stackSize + 1, toMoveMax);
            } else {
                if (toMoveMax > count) {
                    toMoveMax = count;
                }
                toMoveMax = (int)Math.ceil((double)toMoveMax / 2.0);
            }
        }
        int n = toMove = (toMove = toMoveMax - stackSize) > count ? count : toMove;
        if (toMove > 0) {
            this.extractItem(filter, toMove);
            int cacheChange = toMove;
            this.getController().ifPresent(controller -> controller.changeCachedQuantity(filter, -cacheChange));
        }
        ItemStack newCursorStack = filter.func_77946_l();
        newCursorStack.func_190920_e(stackSize + toMove);
        InventoryTools.updateCursorItem((EntityPlayerMP)player, newCursorStack, !rightClick && shiftClick);
    }
}

