/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.shadowmage.ancientwarfare.automation.block.BlockWarehouseStockLinker;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseStockLinker;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IControllerTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileControlled;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseBase;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.owner.IOwnable;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;

public class TileWarehouseStockLinker
extends TileControlled
implements IOwnable,
IInteractableTile {
    private static final String FILTER_LIST_TAG = "filterList";
    private final List<WarehouseStockFilter> filters = new ArrayList<WarehouseStockFilter>();
    private Owner owner = Owner.EMPTY;
    private BlockPos warehouseBlockPos;
    private final Set<ContainerWarehouseStockLinker> viewers = new HashSet<ContainerWarehouseStockLinker>();
    private int searchCooldown = 0;
    private int blockUpdateCooldown = 0;
    private boolean currentEquality;

    private void updateViewers() {
        for (ContainerWarehouseStockLinker viewer : this.viewers) {
            viewer.onFiltersChanged();
        }
    }

    public void addViewer(ContainerWarehouseStockLinker viewer) {
        this.viewers.add(viewer);
    }

    public void removeViewer(ContainerWarehouseStockLinker viewer) {
        this.viewers.remove((Object)viewer);
    }

    public void setWarehousePos(BlockPos pos) {
        this.warehouseBlockPos = pos;
    }

    public List<WarehouseStockFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<WarehouseStockFilter> filters) {
        this.filters.clear();
        this.filters.addAll(filters);
        BlockTools.notifyBlockUpdate(this);
        this.recountFilters();
        BlockTools.notifyNeighbors(this);
    }

    public boolean getEqualityHandle() {
        if (!this.filters.isEmpty()) {
            for (WarehouseStockFilter stockFilter : this.filters) {
                if (!this.handleEqualitySign(stockFilter, stockFilter.getCompareValue(), stockFilter.getQuantity())) continue;
                return true;
            }
        }
        return false;
    }

    private void recountFilters() {
        block3: {
            Optional<TileWarehouseBase> controller;
            block2: {
                controller = this.getController();
                if (controller.isPresent()) break block2;
                for (WarehouseStockFilter filter : this.filters) {
                    filter.setQuantity(0);
                    filter.setEqualitySignType((byte)0);
                    filter.setCompareValue(0);
                }
                break block3;
            }
            if (!controller.get().isActive()) break block3;
            for (WarehouseStockFilter filter : this.filters) {
                filter.setQuantity(filter.getFilterItem().func_190926_b() ? 0 : controller.get().getCountOf(filter.getFilterItem()));
                filter.setEqualitySignType((byte)filter.getEqualitySignType().ordinal());
                filter.setCompareValue(filter.getCompareValue());
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void searchForController() {
        this.linkToWarehouse();
    }

    private void linkToWarehouse() {
        TileEntity te;
        if (this.warehouseBlockPos != null && this.field_145850_b.func_175667_e(this.warehouseBlockPos) && (te = this.field_145850_b.func_175625_s(this.warehouseBlockPos)) instanceof TileWarehouseBase && this.isValidController((IControllerTile)te)) {
            TileWarehouseBase warehouse = (TileWarehouseBase)te;
            warehouse.addControlledTile(this);
            this.setController(warehouse);
        }
    }

    @Override
    public boolean isValidController(IControllerTile tile) {
        return tile instanceof TileWarehouseBase;
    }

    @Override
    protected void onControllerChanged() {
        this.onWarehouseInventoryUpdated();
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        return this.owner.isOwnerOrSameTeamOrFriend((Entity)player);
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.owner = new Owner(player);
    }

    @Override
    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player, @Nullable EnumHand hand) {
        if (!player.field_70170_p.field_72995_K && this.isOwner(player)) {
            NetworkHandler.INSTANCE.openGui(player, 32, this.field_174879_c);
        }
        return true;
    }

    @Override
    protected void updateTile() {
        if (this.searchCooldown > 0) {
            --this.searchCooldown;
        }
        if (!this.getController().isPresent() && this.canSearchForWarehouseAgain()) {
            this.linkToWarehouse();
            this.searchCooldown = 40;
        }
        if (this.blockUpdateCooldown > 0) {
            --this.blockUpdateCooldown;
        }
        if (this.canDoBlockUpdateAgain()) {
            BlockWarehouseStockLinker.setActiveState(this.getEqualityHandle(), this.field_145850_b, this.field_174879_c);
            this.blockUpdateCooldown = 60;
            this.currentEquality = this.getEqualityHandle();
        }
    }

    private boolean canSearchForWarehouseAgain() {
        return this.searchCooldown <= 0;
    }

    private boolean canDoBlockUpdateAgain() {
        return this.blockUpdateCooldown <= 0 && this.currentEquality != this.getEqualityHandle();
    }

    void onWarehouseInventoryUpdated() {
        if (!this.field_145850_b.field_72995_K) {
            this.recountFilters();
            BlockTools.notifyNeighbors(this);
            BlockTools.notifyBlockUpdate(this);
        }
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        NBTHelper.writeSerializablesTo(tag, FILTER_LIST_TAG, this.filters);
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.filters.clear();
        this.filters.addAll(NBTHelper.deserializeListFrom(tag, FILTER_LIST_TAG, WarehouseStockFilter::new));
        BlockTools.notifyBlockUpdate(this);
        this.updateViewers();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.filters.addAll(NBTHelper.deserializeListFrom(tag, FILTER_LIST_TAG, WarehouseStockFilter::new));
        this.owner = Owner.deserializeFromNBT(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTHelper.writeSerializablesTo(tag, FILTER_LIST_TAG, this.filters);
        this.owner.serializeToNBT(tag);
        return tag;
    }

    private boolean handleEqualitySign(WarehouseStockFilter w, int compareValue, int quantity) {
        switch (w.equalitySignType) {
            case EQUAL_TO: {
                return w.equalToTarget(compareValue, quantity);
            }
            case GREATER_THAN: {
                return w.greaterThanTarget(compareValue, quantity);
            }
            case LESS_THAN: {
                return w.lessThanTarget(compareValue, quantity);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return w.greaterThanOrEqualToTarget(compareValue, quantity);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return w.lessThanOrEqualToTarget(compareValue, quantity);
            }
        }
        return false;
    }

    public static enum EqualitySignType {
        EQUAL_TO("equality.equal"),
        GREATER_THAN("equality.greaterthan"),
        LESS_THAN("equality.lessthan"),
        GREATER_THAN_OR_EQUAL_TO("equality.greaterthanorequalto"),
        LESS_THAN_OR_EQUAL_TO("equality.lessthanorequalto");

        final String key;

        private EqualitySignType(String key) {
            this.key = key;
        }

        public String getTranslationKey() {
            return this.key;
        }

        public EqualitySignType next() {
            int ordinal = this.ordinal() + 1;
            if (ordinal >= EqualitySignType.values().length) {
                ordinal = 0;
            }
            return EqualitySignType.values()[ordinal];
        }

        public EqualitySignType previous() {
            int ordinal = this.ordinal() - 1;
            if (ordinal < 0) {
                ordinal = EqualitySignType.values().length - 1;
            }
            return EqualitySignType.values()[ordinal];
        }
    }

    public static class WarehouseStockFilter
    implements INBTSerializable<NBTTagCompound> {
        private static final String ITEM_TAG = "item";
        private static final String QUANTITY_TAG = "quantity";
        private static final String EQUALITY_TAG = "equality_sign";
        private static final String COMPARE_VALUE_TAG = "compare_value";
        private ItemStack item = ItemStack.field_190927_a;
        public EqualitySignType equalitySignType = EqualitySignType.EQUAL_TO;
        public int compareValue;
        public int quantity;

        public WarehouseStockFilter() {
        }

        public WarehouseStockFilter(ItemStack item, int equalitySign, int qty, int compareValue) {
            this.setItem(item);
            this.setEqualitySignType((byte)equalitySign);
            this.setQuantity(qty);
            this.setCompareValue(compareValue);
        }

        public void setItem(ItemStack item) {
            this.item = item;
        }

        private void setEqualitySignType(byte equalitySignType) {
            this.equalitySignType = EqualitySignType.values()[equalitySignType];
        }

        private void setQuantity(int quantity) {
            this.quantity = quantity;
        }

        public void setCompareValue(int compareValue) {
            this.compareValue = compareValue;
        }

        public ItemStack getFilterItem() {
            return this.item;
        }

        private EqualitySignType getEqualitySignType() {
            return this.equalitySignType;
        }

        private int getCompareValue() {
            return this.compareValue;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public void changeEqualitySign(boolean isRmb) {
            this.equalitySignType = isRmb ? this.equalitySignType.previous() : this.equalitySignType.next();
        }

        private boolean equalToTarget(int compareValue, int quantity) {
            if (compareValue != 0) {
                return quantity == compareValue;
            }
            return false;
        }

        private boolean greaterThanTarget(int compareValue, int quantity) {
            if (compareValue != 0) {
                return quantity > compareValue;
            }
            return false;
        }

        private boolean lessThanTarget(int compareValue, int quantity) {
            if (compareValue != 0) {
                return quantity < compareValue;
            }
            return false;
        }

        private boolean greaterThanOrEqualToTarget(int compareValue, int quantity) {
            if (compareValue != 0) {
                return quantity >= compareValue;
            }
            return false;
        }

        private boolean lessThanOrEqualToTarget(int compareValue, int quantity) {
            if (compareValue != 0) {
                return quantity <= compareValue;
            }
            return false;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            if (!this.item.func_190926_b()) {
                tag.func_74782_a(ITEM_TAG, (NBTBase)this.item.func_77955_b(new NBTTagCompound()));
            }
            tag.func_74774_a(EQUALITY_TAG, (byte)this.equalitySignType.ordinal());
            tag.func_74768_a(QUANTITY_TAG, this.quantity);
            tag.func_74768_a(COMPARE_VALUE_TAG, this.compareValue);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound tag) {
            this.setItem(tag.func_74764_b(ITEM_TAG) ? new ItemStack(tag.func_74775_l(ITEM_TAG)) : ItemStack.field_190927_a);
            this.setEqualitySignType(tag.func_74771_c(EQUALITY_TAG));
            this.setQuantity(tag.func_74762_e(QUANTITY_TAG));
            this.setCompareValue(tag.func_74762_e(COMPARE_VALUE_TAG));
        }
    }
}

