/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.warehouse2;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IControlledTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.IWarehouseStorageTile;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseBase;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public class TileWarehouse
extends TileWarehouseBase {
    private InventoryTools.ComparatorItemHashEntry.SortType sortType = InventoryTools.ComparatorItemHashEntry.SortType.NAME;
    private InventoryTools.ComparatorItemHashEntry.SortOrder sortOrder = InventoryTools.ComparatorItemHashEntry.SortOrder.DESCENDING;

    public void func_145843_s() {
        BlockPos max = this.getWorkBoundsMax();
        BlockPos min = this.getWorkBoundsMin();
        List<TileEntity> tiles = WorldTools.getTileEntitiesInArea(this.field_145850_b, min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p());
        for (TileEntity te : tiles) {
            if (!(te instanceof IControlledTile) || !((IControlledTile)te).getController().map(controller -> controller == this).orElse(false).booleanValue()) continue;
            ((IControlledTile)te).setController(null);
        }
    }

    @Override
    public void handleSlotClick(EntityPlayer player, ItemStack filter, boolean shiftClick, boolean rightClick) {
        if (!shiftClick && !player.field_71071_by.func_70445_o().func_190926_b()) {
            this.tryAddItem(player, player.field_71071_by.func_70445_o());
        } else if (!filter.func_190926_b()) {
            this.tryGetItem(player, filter, shiftClick, rightClick);
        }
    }

    private void tryAddItem(EntityPlayer player, ItemStack cursorStack) {
        if (cursorStack.func_190926_b()) {
            return;
        }
        ItemStack result = this.tryAddItem(cursorStack, cursorStack.func_190916_E());
        if (result.func_190916_E() != cursorStack.func_190916_E()) {
            player.field_71071_by.func_70437_b(result);
            ((EntityPlayerMP)player).func_71113_k();
        }
    }

    private ItemStack tryAddItem(ItemStack stack, int count) {
        List<IWarehouseStorageTile> destinations = this.storageMap.getDestinations(stack);
        int addedTotal = 0;
        for (IWarehouseStorageTile tile : destinations) {
            int moved = tile.insertItem(stack, count - addedTotal);
            this.changeCachedQuantity(stack, moved);
            this.updateViewers();
            if ((addedTotal += moved) < count) continue;
            return ItemStack.field_190927_a;
        }
        ItemStack result = stack.func_77946_l();
        result.func_190918_g(addedTotal);
        return result;
    }

    private void tryGetItem(EntityPlayer player, ItemStack filter, boolean shiftClick, boolean rightClick) {
        int stackSize = 0;
        if (!player.field_71071_by.func_70445_o().func_190926_b()) {
            if (shiftClick && rightClick) {
                stackSize = player.field_71071_by.func_70445_o().func_190916_E();
            }
            ItemStack comparableStack = player.field_71071_by.func_70445_o().func_77946_l();
            comparableStack.func_190920_e(filter.func_190916_E());
            if (!ItemStack.func_77989_b((ItemStack)filter, (ItemStack)comparableStack)) {
                return;
            }
        }
        List<IWarehouseStorageTile> destinations = this.storageMap.getDestinations();
        int toMoveMax = filter.func_77976_d();
        if (rightClick && toMoveMax > 1) {
            if (shiftClick) {
                toMoveMax = Math.min(stackSize + 1, toMoveMax);
            } else {
                int available = 0;
                for (IWarehouseStorageTile tile : destinations) {
                    available += tile.getQuantityStored(filter);
                }
                if (toMoveMax > available) {
                    toMoveMax = available;
                }
                toMoveMax = (int)Math.ceil((double)toMoveMax / 2.0);
            }
        }
        int toRemove = toMoveMax - stackSize;
        ItemStack removedStack = this.tryGetItem(filter, toRemove);
        ItemStack newCursorStack = filter.func_77946_l();
        newCursorStack.func_190920_e(stackSize + removedStack.func_190916_E());
        InventoryTools.updateCursorItem((EntityPlayerMP)player, newCursorStack, !rightClick && shiftClick);
    }

    private ItemStack tryGetItem(ItemStack filter, int toRemove) {
        if (this.field_145850_b.field_72995_K) {
            return this.tryGetItemClient(filter, toRemove);
        }
        int removed = 0;
        for (IWarehouseStorageTile tile : this.storageMap.getDestinations()) {
            int count = tile.getQuantityStored(filter);
            int removeFromTile = Math.min(toRemove - removed, count);
            if (removeFromTile > 0) {
                removed += removeFromTile;
                tile.extractItem(filter, removeFromTile);
                this.changeCachedQuantity(filter, -removeFromTile);
                this.updateViewers();
            }
            if (removed < toRemove) continue;
            break;
        }
        if (removed == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = filter.func_77946_l();
        result.func_190920_e(removed);
        return result;
    }

    private ItemStack tryGetItemClient(ItemStack filter, int toRemove) {
        int maxRemove = this.cachedItemMap.getCount(filter);
        int removed = Math.min(toRemove, maxRemove);
        this.cachedItemMap.decreaseCount(filter, removed);
        ItemStack result = filter.func_77946_l();
        result.func_190920_e(removed);
        return result;
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        this.writeSort(tag);
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.readSort(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.writeSort(tag);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readSort(tag);
    }

    private void writeSort(NBTTagCompound tag) {
        tag.func_74774_a("sortOrder", (byte)this.getSortOrder().ordinal());
        tag.func_74774_a("sortType", (byte)this.getSortType().ordinal());
    }

    private void readSort(NBTTagCompound tag) {
        this.setSortOrder(InventoryTools.ComparatorItemHashEntry.SortOrder.values()[tag.func_74771_c("sortOrder")]);
        this.setSortType(InventoryTools.ComparatorItemHashEntry.SortType.values()[tag.func_74771_c("sortType")]);
    }

    public InventoryTools.ComparatorItemHashEntry.SortType getSortType() {
        return this.sortType;
    }

    public void setSortType(InventoryTools.ComparatorItemHashEntry.SortType sortType) {
        this.sortType = sortType;
    }

    public InventoryTools.ComparatorItemHashEntry.SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(InventoryTools.ComparatorItemHashEntry.SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public IItemHandlerModifiable getItemHandler() {
        int additionalSlots = 10;
        NonNullList<ItemStack> cachedItems = this.cachedItemMap.getItems();
        for (int i = 0; i < additionalSlots; ++i) {
            cachedItems.add((Object)ItemStack.field_190927_a);
        }
        return new WarehouseItemHandler(cachedItems);
    }

    private class WarehouseItemHandler
    implements IItemHandlerModifiable {
        private final NonNullList<ItemStack> cachedItems;

        private WarehouseItemHandler(NonNullList<ItemStack> cachedItems) {
            this.cachedItems = cachedItems;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            ItemStack currentStack = (ItemStack)this.cachedItems.get(slot);
            if (currentStack.func_190926_b()) {
                this.insertItem(slot, stack, false);
            } else {
                int countChange = stack.func_190916_E() - currentStack.func_190916_E();
                if (countChange == 0) {
                    return;
                }
                if (countChange > 0) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190920_e(countChange);
                    this.insertItem(slot, copy, false);
                } else {
                    this.extractItem(slot, -countChange, false);
                }
            }
        }

        public int getSlots() {
            return this.cachedItems.size();
        }

        public ItemStack getStackInSlot(int slot) {
            return slot < this.cachedItems.size() ? (ItemStack)this.cachedItems.get(slot) : ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            ItemStack cachedStack = (ItemStack)this.cachedItems.get(slot);
            if (cachedStack.func_190926_b() || InventoryTools.doItemStacksMatchRelaxed(stack, cachedStack)) {
                int maxToAdd = Math.min(stack.func_77976_d() - cachedStack.func_190916_E(), stack.func_190916_E());
                if (!simulate) {
                    cachedStack.func_190920_e(cachedStack.func_190916_E() + maxToAdd);
                    ItemStack result = TileWarehouse.this.tryAddItem(stack, maxToAdd);
                    if (maxToAdd == stack.func_190916_E()) {
                        return result;
                    }
                    ItemStack ret = stack.func_77946_l();
                    ret.func_190920_e(stack.func_190916_E() - maxToAdd + result.func_190916_E());
                    return ret;
                }
                ItemStack ret = ItemStack.field_190927_a;
                if (maxToAdd < stack.func_190916_E()) {
                    ret = stack.func_77946_l();
                    ret.func_190920_e(stack.func_190916_E() - maxToAdd);
                }
                return ret;
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack cachedStack = (ItemStack)this.cachedItems.get(slot);
            if (cachedStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            int maxToRemove = Math.min(cachedStack.func_190916_E(), amount);
            if (!simulate) {
                ItemStack result = TileWarehouse.this.tryGetItem(cachedStack, maxToRemove);
                cachedStack.func_190920_e(cachedStack.func_190916_E() - maxToRemove);
                return result;
            }
            ItemStack ret = cachedStack.func_77946_l();
            ret.func_190920_e(maxToRemove);
            return ret;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    }
}

