/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque;

import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueSingleCell;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.util.BlockTools;

public class TileWaterwheelGenerator
extends TileTorqueSingleCell {
    public float wheelRotation;
    public float lastWheelRotationDiff;
    private float rotTick;
    private byte rotationDirection = 1;
    private int updateTick;
    public boolean validSetup = false;

    public TileWaterwheelGenerator() {
        this.torqueCell = new ITorque.TorqueCell(0.0, 4.0, AWAutomationStatics.low_transfer_max, AWAutomationStatics.low_efficiency_factor);
        float maxWheelRpm = 20.0f;
        this.rotTick = maxWheelRpm * 0.3f;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            --this.updateTick;
            if (this.updateTick <= 0) {
                this.updateTick = 20;
                boolean valid = this.validateBlocks();
                if (valid != this.validSetup) {
                    this.validSetup = valid;
                    BlockTools.notifyBlockUpdate(this);
                }
            }
            if (this.validSetup) {
                this.torqueCell.setEnergy(this.torqueCell.getEnergy() + AWAutomationStatics.waterwheel_generator_output);
            }
        }
    }

    @Override
    protected void updateRotation() {
        super.updateRotation();
        if (this.validSetup) {
            this.lastWheelRotationDiff = this.rotTick * (float)this.rotationDirection * ((float)Math.PI / 180);
            this.wheelRotation += this.lastWheelRotationDiff;
            this.wheelRotation %= (float)Math.PI * 2;
        }
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.validSetup = tag.func_74767_n("validSetup");
        this.rotationDirection = tag.func_74771_c("rotationDirection");
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        tag.func_74757_a("validSetup", this.validSetup);
        tag.func_74774_a("rotationDirection", this.rotationDirection);
    }

    private boolean validateBlocks() {
        int levelRight;
        EnumFacing d = this.orientation.func_176734_d();
        BlockPos innerPos = this.field_174879_c.func_177972_a(d);
        if (this.getValidationType(innerPos.func_177984_a()) != 1 || this.getValidationType(innerPos) != 1) {
            return false;
        }
        BlockPos right = innerPos.func_177972_a(d.func_176746_e());
        BlockPos left = innerPos.func_177972_a(d.func_176735_f());
        byte[] validationGrid = new byte[]{this.getValidationType(left.func_177984_a()), this.getValidationType(right.func_177984_a()), this.getValidationType(left), this.getValidationType(right), this.getValidationType(left.func_177977_b()), this.getValidationType(right.func_177977_b())};
        for (byte aValue : validationGrid) {
            if (aValue != 0) continue;
            return false;
        }
        if (validationGrid[2] == 2 && validationGrid[4] == 2) {
            if (validationGrid[1] == 1 && validationGrid[3] == 1) {
                this.rotationDirection = (byte)-1;
                return true;
            }
            return false;
        }
        if (validationGrid[3] == 2 && validationGrid[5] == 2) {
            if (validationGrid[0] == 1 && validationGrid[2] == 1) {
                this.rotationDirection = 1;
                return true;
            }
            return false;
        }
        if (validationGrid[4] != 2 || validationGrid[5] != 2 || this.getValidationType(innerPos.func_177977_b()) != 2) {
            return false;
        }
        IBlockState stateLeft = this.field_145850_b.func_180495_p(left.func_177977_b());
        IBlockState stateRight = this.field_145850_b.func_180495_p(right.func_177977_b());
        int levelLeft = stateLeft.func_185904_a() != Material.field_151586_h ? 0 : (Integer)stateLeft.func_177229_b((IProperty)BlockLiquid.field_176367_b);
        int n = levelRight = stateRight.func_185904_a() != Material.field_151586_h ? 0 : (Integer)stateRight.func_177229_b((IProperty)BlockLiquid.field_176367_b);
        this.rotationDirection = (byte)(levelLeft < levelRight ? -1 : (levelRight < levelLeft ? 1 : 0));
        return true;
    }

    private byte getValidationType(BlockPos pos) {
        if (this.field_145850_b.func_175623_d(pos)) {
            return 1;
        }
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        if (state.func_185904_a() == Material.field_151586_h) {
            return 2;
        }
        return 0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 3), (double)(this.field_174879_c.func_177956_o() - 3), (double)(this.field_174879_c.func_177952_p() - 3), (double)(this.field_174879_c.func_177958_n() + 4), (double)(this.field_174879_c.func_177956_o() + 4), (double)(this.field_174879_c.func_177952_p() + 4));
    }

    @Override
    public float getClientOutputRotation(EnumFacing from, float delta) {
        if (from == this.orientation.func_176734_d()) {
            return this.getRenderRotation(this.wheelRotation, this.lastWheelRotationDiff, delta);
        }
        return super.getClientOutputRotation(from, delta);
    }
}

