/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque;

import cofh.redstoneflux.api.IEnergyReceiver;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.automation.proxy.RFProxy;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IInteractableTile;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketBlockEvent;
import net.shadowmage.ancientwarfare.core.tile.TileUpdatable;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyReceiver", modid="redstoneflux", striprefs=true)
public abstract class TileTorqueBase
extends TileUpdatable
implements ITorque.ITorqueTile,
IInteractableTile,
BlockRotationHandler.IRotatableTile,
IEnergyReceiver,
ITickable {
    public static final int DIRECTION_LENGTH = EnumFacing.field_82609_l.length;
    private static final String ORIENTATION_TAG = "orientation";
    protected EnumFacing orientation = EnumFacing.NORTH;
    protected int networkUpdateTicks;
    private TileEntity[] rfCache;
    private ITorque.ITorqueTile[] torqueCache;
    protected double torqueIn;
    protected double torqueOut;
    protected double torqueLoss;
    protected double prevEnergy;

    @Optional.Method(modid="redstoneflux")
    public final int getEnergyStored(EnumFacing from) {
        return (int)(this.getTorqueStored(from) * AWAutomationStatics.torqueToRf);
    }

    @Optional.Method(modid="redstoneflux")
    public final int getMaxEnergyStored(EnumFacing from) {
        return (int)(this.getMaxTorque(from) * AWAutomationStatics.torqueToRf);
    }

    @Optional.Method(modid="redstoneflux")
    public final boolean canConnectEnergy(EnumFacing from) {
        return this.canOutputTorque(from) || this.canInputTorque(from);
    }

    @Optional.Method(modid="redstoneflux")
    public final int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (!this.canInputTorque(from)) {
            return 0;
        }
        if (simulate) {
            return Math.min(maxReceive, (int)(AWAutomationStatics.torqueToRf * this.getMaxTorqueInput(from)));
        }
        return (int)(AWAutomationStatics.torqueToRf * this.addTorque(from, (double)maxReceive * AWAutomationStatics.rfToTorque));
    }

    public final ITorque.ITorqueTile[] getTorqueCache() {
        if (this.torqueCache == null) {
            this.buildTorqueCache();
        }
        return this.torqueCache;
    }

    public final TileEntity[] getRFCache() {
        if (this.rfCache == null) {
            this.buildRFCache();
        }
        return this.rfCache;
    }

    private void buildTorqueCache() {
        if (!this.func_145830_o()) {
            throw new RuntimeException("Attempt to build neighbor cache on null world!!");
        }
        ITorque.ITorqueTile[] torqueCache = new ITorque.ITorqueTile[DIRECTION_LENGTH];
        for (int i = 0; i < torqueCache.length; ++i) {
            BlockPos offsetPos;
            EnumFacing dir = EnumFacing.values()[i];
            if (!this.canOutputTorque(dir) && !this.canInputTorque(dir) || !this.field_145850_b.func_175667_e(offsetPos = this.field_174879_c.func_177972_a(dir))) continue;
            int index = i;
            WorldTools.getTile((IBlockAccess)this.field_145850_b, offsetPos, ITorque.ITorqueTile.class).ifPresent(t -> {
                torqueCache[index] = t;
            });
        }
        this.torqueCache = torqueCache;
    }

    private void buildRFCache() {
        TileEntity[] rfCache = new TileEntity[DIRECTION_LENGTH];
        for (int i = 0; i < rfCache.length; ++i) {
            BlockPos offsetPos;
            EnumFacing dir = EnumFacing.values()[i];
            if (!this.canOutputTorque(dir) && !this.canInputTorque(dir) || !this.field_145850_b.func_175667_e(offsetPos = this.field_174879_c.func_177972_a(dir))) continue;
            EnumFacing direction = dir;
            WorldTools.getTile((IBlockAccess)this.field_145850_b, offsetPos).filter(t -> RFProxy.instance.isRFTile((TileEntity)t)).ifPresent(t -> {
                rfCache[direction.ordinal()] = t;
            });
        }
        this.rfCache = rfCache;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.invalidateTorqueCache();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.invalidateTorqueCache();
    }

    public void onNeighborTileChanged() {
        this.invalidateTorqueCache();
    }

    private void invalidateTorqueCache() {
        this.torqueCache = null;
        this.rfCache = null;
        this.onNeighborCacheInvalidated();
    }

    protected void onNeighborCacheInvalidated() {
    }

    public boolean hasFastRenderer() {
        return true;
    }

    @Override
    public final void setPrimaryFacing(EnumFacing d) {
        this.orientation = d;
        this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
        this.invalidateTorqueCache();
        BlockTools.notifyBlockUpdate(this);
    }

    @Override
    public final EnumFacing getPrimaryFacing() {
        return this.orientation;
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player, @Nullable EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            if (!this.field_145850_b.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.automation.torque.values", new Object[]{String.format("%.2f", this.getTotalTorque()), String.format("%.2f", this.getTorqueIn()), String.format("%.2f", this.getTorqueOut()), String.format("%.2f", this.getTorqueLoss())}));
            }
            return true;
        }
        return false;
    }

    protected void updateRotation() {
        throw new UnsupportedOperationException();
    }

    protected void clientNetworkUpdate() {
        throw new UnsupportedOperationException();
    }

    protected void serverNetworkSynch() {
        throw new UnsupportedOperationException();
    }

    protected abstract void handleClientRotationData(EnumFacing var1, int var2);

    protected abstract double getTotalTorque();

    private double getTorqueOut() {
        return this.torqueOut;
    }

    private double getTorqueIn() {
        return this.torqueIn;
    }

    private double getTorqueLoss() {
        return this.torqueLoss;
    }

    protected final void serverNetworkUpdate() {
        --this.networkUpdateTicks;
        if (this.networkUpdateTicks <= 0) {
            this.networkUpdateTicks = AWAutomationStatics.energyMinNetworkUpdateFrequency;
            this.serverNetworkSynch();
        }
    }

    protected void sendSideRotation(EnumFacing side, int value) {
        int valueBits = value & 0xFF;
        this.sendDataToClient(side.ordinal(), valueBits);
    }

    protected final double transferPowerTo(EnumFacing from) {
        double transferred = 0.0;
        ITorque.ITorqueTile[] tc = this.getTorqueCache();
        if (tc[from.ordinal()] != null) {
            if (tc[from.ordinal()].canInputTorque(from.func_176734_d())) {
                return this.drainTorque(from, tc[from.ordinal()].addTorque(from.func_176734_d(), this.getMaxTorqueOutput(from)));
            }
        } else if (Loader.isModLoaded((String)"redstoneflux") && (transferred = RFProxy.instance.transferPower(this, from, this.getRFCache()[from.ordinal()])) > 0.0) {
            return transferred;
        }
        return transferred;
    }

    protected final double applyPowerDrain(ITorque.TorqueCell cell) {
        double e = cell.getEnergy();
        cell.setEnergy(e * cell.getEfficiency());
        return cell.getEnergy() - e;
    }

    protected final void sendDataToClient(int type, int data) {
        PacketBlockEvent pkt = new PacketBlockEvent(this.field_174879_c, this.func_145838_q(), (short)type, (short)data);
        NetworkHandler.sendToAllTrackingChunk(this.field_145850_b, this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4, pkt);
    }

    protected final float getRenderRotation(double rotation, double lastRotationDiff, float partialTicks) {
        return (float)(rotation - lastRotationDiff * (double)(1.0f - partialTicks));
    }

    public boolean func_145842_c(int a, int b) {
        if (this.field_145850_b.field_72995_K && a < DIRECTION_LENGTH) {
            this.networkUpdateTicks = AWAutomationStatics.energyMinNetworkUpdateFrequency;
            this.handleClientRotationData(EnumFacing.values()[a], b);
        }
        return true;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.orientation = EnumFacing.field_82609_l[tag.func_74762_e(ORIENTATION_TAG)];
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a(ORIENTATION_TAG, this.orientation.ordinal());
        return tag;
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        tag.func_74768_a(ORIENTATION_TAG, this.orientation.ordinal());
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.orientation = EnumFacing.field_82609_l[tag.func_74762_e(ORIENTATION_TAG)];
        this.invalidateTorqueCache();
        BlockTools.notifyBlockUpdate(this);
    }
}

