/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.tile.torque;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.automation.config.AWAutomationStatics;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueSingleCell;
import net.shadowmage.ancientwarfare.core.interfaces.ITorque;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.tile.IBlockBreakHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;

public class TileStirlingGenerator
extends TileTorqueSingleCell
implements IBlockBreakHandler {
    private final ItemStackHandler fuelHandler = new ItemStackHandler(1){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0 ? super.insertItem(slot, stack, simulate) : stack;
        }
    };
    private int burnTime = 0;
    private int burnTimeBase = 0;

    public TileStirlingGenerator() {
        this.torqueCell = new ITorque.TorqueCell(0.0, 4.0, 1600.0, AWAutomationStatics.med_efficiency_factor);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.burnTime <= 0 && this.torqueCell.getEnergy() < this.torqueCell.getMaxEnergy()) {
                int ticks = TileEntityFurnace.func_145952_a((ItemStack)this.fuelHandler.getStackInSlot(0));
                if (ticks > 0) {
                    this.fuelHandler.extractItem(0, 1, false);
                    this.burnTime = ticks;
                    this.burnTimeBase = ticks;
                }
            } else if (this.burnTime > 0) {
                this.torqueCell.setEnergy(this.torqueCell.getEnergy() + AWAutomationStatics.stirling_generator_output);
                --this.burnTime;
            }
        }
    }

    @Override
    public boolean onBlockClicked(EntityPlayer player, @Nullable EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 31, this.field_174879_c);
        }
        return true;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public int getBurnTimeBase() {
        return this.burnTimeBase;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.burnTime = tag.func_74762_e("burnTicks");
        this.burnTimeBase = tag.func_74762_e("burnTicksBase");
        if (tag.func_74764_b("inventory")) {
            this.fuelHandler.deserializeNBT(tag.func_74775_l("inventory"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("burnTicks", this.burnTime);
        tag.func_74768_a("burnTicksBase", this.burnTimeBase);
        tag.func_74782_a("inventory", (NBTBase)this.fuelHandler.serializeNBT());
        return tag;
    }

    @Override
    public boolean canInputTorque(EnumFacing from) {
        return false;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.fuelHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void onBlockBroken(IBlockState state) {
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.fuelHandler, this.field_174879_c);
    }
}

