/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.render;

import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCModelState;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.RedundantTransformation;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.shadowmage.ancientwarfare.automation.block.BlockWindmillBlade;
import net.shadowmage.ancientwarfare.automation.render.AnimatedBlockRenderer;
import net.shadowmage.ancientwarfare.automation.render.property.AutomationProperties;
import net.shadowmage.ancientwarfare.automation.tile.torque.multiblock.TileWindmillBlade;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public class WindmillBladeRenderer
extends AnimatedBlockRenderer {
    public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("ancientwarfare:automation/windmill_blade", "normal");
    public static final WindmillBladeRenderer INSTANCE = new WindmillBladeRenderer();
    private static final ModelProperties.PerspectiveProperties MODEL_PROPERTIES;
    private final Collection<CCModel> bladeShaft;
    private final Collection<CCModel> windmillShaft;
    private final Collection<CCModel> blade;
    private final Collection<CCModel> bladeJoint;
    private final CCModel cube = ((CCModel)OBJParser.parseModels((ResourceLocation)new ResourceLocation("ancientwarfare", "models/block/automation/windmill_blade_cube.obj"), (int)7, (Transformation)new RedundantTransformation()).values().iterator().next()).backfacedCopy();
    public TextureAtlasSprite cubeSprite;
    private IconTransformation cubeIconTransform;

    private WindmillBladeRenderer() {
        super("automation/windmill_blade.obj");
        this.bladeShaft = this.removeGroups(s -> s.startsWith("bladeShaft."));
        this.windmillShaft = this.transformModels(this.removeGroups(s -> s.startsWith("windmillShaft.")), (Transformation)new Translation(0.0, 0.5, 0.0));
        this.blade = this.removeGroups(s -> s.startsWith("blade."));
        this.bladeJoint = this.removeGroups(s -> s.startsWith("bladeJoint."));
    }

    private Collection<CCModel> transformModels(Collection<CCModel> groups, Transformation transform) {
        return groups.stream().map(e -> e.copy().apply(transform)).collect(Collectors.toSet());
    }

    public void setCubeSprite(TextureAtlasSprite sprite) {
        this.cubeSprite = sprite;
        this.cubeIconTransform = new IconTransformation(this.cubeSprite);
    }

    @Override
    public List<BakedQuad> bakeQuads(@Nullable EnumFacing face, IExtendedBlockState state) {
        if (!(!((Boolean)state.getValue(BlockWindmillBlade.FORMED)).booleanValue() || ((Boolean)state.getValue(AutomationProperties.DYNAMIC)).booleanValue() && ((Boolean)state.getValue(AutomationProperties.IS_CONTROL)).booleanValue())) {
            return Collections.emptyList();
        }
        return super.bakeQuads(face, state);
    }

    @Override
    protected void renderBlockModels(Collection<CCModel> modelGroups, CCRenderState ccrs, EnumFacing face, IExtendedBlockState state) {
        if (!((Boolean)state.getValue(BlockWindmillBlade.FORMED)).booleanValue()) {
            this.cube.render(ccrs, new IVertexOperation[]{this.cubeIconTransform});
        } else {
            super.renderBlockModels(modelGroups, ccrs, face, state);
        }
    }

    @Override
    protected Collection<CCModel> applyModelTransforms(Collection<CCModel> modelGroups, EnumFacing face, IExtendedBlockState state) {
        if (!((Boolean)state.getValue(BlockWindmillBlade.FORMED)).booleanValue()) {
            return Collections.singleton(this.cube);
        }
        if (!((Boolean)state.getValue(AutomationProperties.DYNAMIC)).booleanValue() || !((Boolean)state.getValue(AutomationProperties.IS_CONTROL)).booleanValue()) {
            return Collections.emptySet();
        }
        EnumFacing frontFacing = (EnumFacing)state.getValue(CoreProperties.UNLISTED_HORIZONTAL_FACING);
        int height = ((Integer)state.getValue(AutomationProperties.HEIGHT) - 1) / 2;
        float rotation = ((Float)state.getValue(AutomationProperties.ROTATION)).floatValue();
        return this.transformBlades(frontFacing, height, rotation);
    }

    @Override
    protected IconTransformation getIconTransform(IExtendedBlockState state) {
        return (Boolean)state.getValue(BlockWindmillBlade.FORMED) == false ? this.cubeIconTransform : this.iconTransform;
    }

    private Set<CCModel> transformBlades(EnumFacing frontFacing, int height, float rotation) {
        HashSet transformedGroups = Sets.newHashSet();
        Vector3 center = new Vector3(0.5, 0.5, 0.5);
        Transformation baseRotation = new Rotation((double)rotation, 0.0, 0.0, 1.0).at(center);
        transformedGroups.addAll(this.rotateModels(this.windmillShaft, frontFacing, baseRotation));
        for (int i = 0; i < 4; ++i) {
            TransformationList bladeTransform = new Rotation((double)((float)i * (float)Math.PI / 2.0f), 0.0, 0.0, 1.0).at(center).with(baseRotation);
            if (i < 2) {
                transformedGroups.addAll(this.rotateModels(this.bladeShaft, frontFacing, (Transformation)bladeTransform));
            }
            for (int k = 1; k < height; ++k) {
                transformedGroups.addAll(this.rotateModels(this.blade, frontFacing, (Transformation)bladeTransform));
                if (k == height - 1) {
                    transformedGroups.addAll(this.rotateModels(this.bladeJoint, frontFacing, (Transformation)bladeTransform));
                    continue;
                }
                bladeTransform = new Translation(0.0, 1.0, 0.0).with((Transformation)bladeTransform);
            }
        }
        return transformedGroups;
    }

    @Override
    public IExtendedBlockState handleState(IExtendedBlockState state, IBlockAccess access, BlockPos pos) {
        return WorldTools.getTile(access, pos, TileWindmillBlade.class).map(t -> this.getWindmillState(state, (TileWindmillBlade)((Object)t))).orElse(state);
    }

    private IExtendedBlockState getWindmillState(IExtendedBlockState state, TileWindmillBlade blade) {
        return state.withProperty(BlockWindmillBlade.FORMED, (Object)blade.isFormed()).withProperty(AutomationProperties.IS_CONTROL, (Object)false).withProperty(AutomationProperties.HEIGHT, (Object)0).withProperty(AutomationProperties.ROTATION, (Object)Float.valueOf(0.0f)).withProperty(CoreProperties.UNLISTED_HORIZONTAL_FACING, (Object)EnumFacing.NORTH).withProperty(AutomationProperties.DYNAMIC, (Object)false);
    }

    @Override
    public ModelProperties.PerspectiveProperties getModelProperties(ItemStack stack) {
        return MODEL_PROPERTIES;
    }

    @Override
    protected void renderItemModels(CCRenderState ccrs, ItemStack stack) {
        this.transformBlades(EnumFacing.NORTH, 2, 0.0f).forEach(m -> m.render(ccrs, new IVertexOperation[]{this.iconTransform}));
    }

    static {
        TRSRTransformation thirdPerson = TransformUtils.create((float)0.0f, (float)2.5f, (float)0.0f, (float)75.0f, (float)225.0f, (float)0.0f, (float)0.375f);
        ImmutableMap.Builder defaultBlockBuilder = ImmutableMap.builder();
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)TransformUtils.create((float)0.0f, (float)0.0f, (float)0.0f, (float)30.0f, (float)225.0f, (float)90.0f, (float)0.32f));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)TransformUtils.create((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.125f));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)TransformUtils.create((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.25f));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdPerson);
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)TransformUtils.flipLeft((TRSRTransformation)thirdPerson));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)TransformUtils.create((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)135.0f, (float)0.0f, (float)0.2f));
        defaultBlockBuilder.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)TransformUtils.create((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)135.0f, (float)0.0f, (float)0.2f));
        MODEL_PROPERTIES = new ModelProperties.PerspectiveProperties((IModelState)new CCModelState((Map)defaultBlockBuilder.build()), true, true);
    }
}

