/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.render;

import codechicken.lib.render.CCModel;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.shadowmage.ancientwarfare.automation.block.BlockTorqueTransportShaft;
import net.shadowmage.ancientwarfare.automation.render.TorqueTieredRenderer;
import net.shadowmage.ancientwarfare.automation.render.property.AutomationProperties;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileTorqueShaft;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;

public class TorqueShaftRenderer
extends TorqueTieredRenderer<TileTorqueShaft> {
    public static final ModelResourceLocation LIGHT_MODEL_LOCATION = new ModelResourceLocation("ancientwarfare:automation/torque_shaft", "light");
    public static final ModelResourceLocation MEDIUM_MODEL_LOCATION = new ModelResourceLocation("ancientwarfare:automation/torque_shaft", "medium");
    public static final ModelResourceLocation HEAVY_MODEL_LOCATION = new ModelResourceLocation("ancientwarfare:automation/torque_shaft", "heavy");
    public static final TorqueShaftRenderer INSTANCE = new TorqueShaftRenderer();
    private Collection<CCModel> inputHead = this.removeGroups(s -> s.startsWith("southShaft."));
    private Collection<CCModel> outputHead = this.removeGroups(s -> s.startsWith("northShaft."));
    private Collection<CCModel> shaft = this.removeGroups(s -> s.startsWith("shaft."));
    private Collection<CCModel> gearbox = this.removeGroups(s -> s.startsWith("gearBox."));

    private TorqueShaftRenderer() {
        super("automation/torque_shaft.obj");
    }

    @Override
    protected Transformation getBaseTransformation() {
        return new Translation(0.0, 0.5, 0.0);
    }

    @Override
    protected Collection<CCModel> applyModelTransforms(Collection<CCModel> modelGroups, EnumFacing face, IExtendedBlockState state) {
        modelGroups = super.applyModelTransforms(modelGroups, face, state);
        if (!((Boolean)state.getValue(AutomationProperties.DYNAMIC)).booleanValue() && !((Boolean)state.getValue(BlockTorqueTransportShaft.HAS_PREVIOUS)).booleanValue()) {
            modelGroups.addAll(this.rotateFacing(this.gearbox, (EnumFacing)state.getValue(CoreProperties.UNLISTED_FACING)));
        }
        return modelGroups;
    }

    @Override
    protected void transformMovingParts(Collection<CCModel> transformedGroups, EnumFacing frontFacing, float[] rotations, @Nullable IExtendedBlockState state) {
        boolean hasNext;
        float rotation = rotations[frontFacing.ordinal()];
        transformedGroups.addAll(this.rotateModels(this.shaft, frontFacing, new Rotation((double)rotation, 0.0, 0.0, 1.0).at(new Vector3(0.5, 0.5, 0.5))));
        boolean hasPrevious = state != null && (Boolean)state.getValue(BlockTorqueTransportShaft.HAS_PREVIOUS) != false;
        boolean useInput = state != null && (Boolean)state.getValue(AutomationProperties.USE_INPUT) != false;
        boolean bl = hasNext = state != null && (Boolean)state.getValue(BlockTorqueTransportShaft.HAS_NEXT) != false;
        if (!hasNext) {
            transformedGroups.addAll(this.rotateModels(this.outputHead, frontFacing, new Rotation((double)rotation, 0.0, 0.0, 1.0).at(new Vector3(0.5, 0.5, 0.5))));
        }
        if (!hasPrevious) {
            if (useInput) {
                rotation = ((Float)state.getValue(AutomationProperties.INPUT_ROTATION)).floatValue();
            }
            transformedGroups.addAll(this.rotateModels(this.inputHead, frontFacing, new Rotation((double)rotation, 0.0, 0.0, 1.0).at(new Vector3(0.5, 0.5, 0.5))));
        }
    }

    @Override
    protected IExtendedBlockState handleAdditionalProperties(IExtendedBlockState state, TileTorqueShaft tileEntity) {
        state = super.handleAdditionalProperties(state, tileEntity);
        TileTorqueShaft prev = tileEntity.prev();
        state = state.withProperty(BlockTorqueTransportShaft.HAS_NEXT, (Object)false);
        state = state.withProperty(BlockTorqueTransportShaft.HAS_PREVIOUS, (Object)(prev != null ? 1 : 0));
        state = state.withProperty(AutomationProperties.USE_INPUT, (Object)false);
        state = state.withProperty(AutomationProperties.INPUT_ROTATION, (Object)Float.valueOf(0.0f));
        return state;
    }
}

