/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.render;

import codechicken.lib.render.CCModel;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import java.util.Collection;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.shadowmage.ancientwarfare.automation.render.BaseTorqueRenderer;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileStirlingGenerator;

public class StirlingGeneratorRenderer
extends BaseTorqueRenderer<TileStirlingGenerator> {
    public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("ancientwarfare:automation/stirling_generator", "normal");
    public static final StirlingGeneratorRenderer INSTANCE = new StirlingGeneratorRenderer();
    private final Collection<CCModel> flywheel;
    private final Collection<CCModel> pistonCrank;
    private final Collection<CCModel> pistonCrank2;
    private final Collection<CCModel> flywheelArm = this.removeGroups(s -> s.startsWith("part1.flywheel_mount.flywheel2.flywheel_arm"));
    private final Collection<CCModel> pistonArm = this.removeGroups(s -> s.startsWith("part1.crank_mount.piston_crank.piston_arm."));
    private final Collection<CCModel> pistonArm2 = this.removeGroups(s -> s.startsWith("part1.crank_mount.piston_crank.piston_arm2."));
    private float armAngle;
    private float armAngle2;

    private StirlingGeneratorRenderer() {
        super("automation/stirling_generator.obj");
        this.flywheel = this.removeGroups(s -> s.startsWith("part1.flywheel_mount.flywheel2."));
        this.pistonCrank = this.removeGroups(s -> s.startsWith("part1.crank_mount.piston_crank."));
        this.pistonCrank2 = this.removeGroups(s -> s.startsWith("part1.piston_crank2."));
    }

    @Override
    protected void transformMovingParts(Collection<CCModel> transformedGroups, EnumFacing frontFacing, float[] rotations, IExtendedBlockState state) {
        float rotation = rotations[frontFacing.func_176745_a()];
        this.calculateArmAngle1(-rotation);
        this.calculateArmAngle2(-rotation - 90.0f);
        Transformation flywheelRotation = new Rotation((double)rotation, 0.0, 0.0, 1.0).at(new Vector3(0.5, 0.5, 0.0));
        transformedGroups.addAll(this.rotateModels(this.flywheel, frontFacing, flywheelRotation));
        Transformation pistonCrankRotation = new Rotation((double)(-rotation), 0.0, 0.0, 1.0).at(new Vector3(0.75, 0.75, 0.0));
        transformedGroups.addAll(this.rotateModels(this.pistonCrank, frontFacing, pistonCrankRotation));
        transformedGroups.addAll(this.rotateModels(this.pistonCrank2, frontFacing, new Rotation((double)rotation, 0.0, 0.0, 1.0).at(new Vector3(0.75, 0.6875, 0.0))));
        transformedGroups.addAll(this.rotateModels(this.flywheelArm, frontFacing, (Transformation)new Rotation((double)(-rotation), 0.0, 0.0, 1.0).at(new Vector3(0.5625, 0.5, 0.46875)).with(flywheelRotation)));
        transformedGroups.addAll(this.rotateModels(this.pistonArm, frontFacing, (Transformation)new Rotation((double)(rotation + this.armAngle), 0.0, 0.0, 1.0).at(new Vector3(0.6875, 0.75, 0.0)).with(pistonCrankRotation)));
        transformedGroups.addAll(this.rotateModels(this.pistonArm2, frontFacing, (Transformation)new Rotation((double)(rotation + this.armAngle2), 0.0, 0.0, 1.0).at(new Vector3(0.6875, 0.75, 0.0)).with(pistonCrankRotation)));
    }

    private void calculateArmAngle1(float crankAngle) {
        float crankDistance = 1.0f;
        float crankLength = 9.0f;
        this.calculatePistonPosition1(crankAngle, crankDistance, crankLength);
    }

    private void calculatePistonPosition1(float crankAngleRadians, float radius, float length) {
        float cA = MathHelper.func_76134_b((float)crankAngleRadians);
        float sA = MathHelper.func_76126_a((float)crankAngleRadians);
        float pistonPos = radius * cA + MathHelper.func_76129_c((float)(length * length - radius * radius * sA * sA));
        float bx = sA * radius;
        float by = cA * radius;
        float cx = 0.0f;
        this.armAngle = (float)Math.atan2(cx - bx, pistonPos - by);
    }

    private void calculateArmAngle2(float crankAngle) {
        float crankDistance = 1.0f;
        float crankLength = 7.0f;
        this.calculatePistonPosition2(crankAngle, crankDistance, crankLength);
    }

    private void calculatePistonPosition2(float crankAngleRadians, float radius, float length) {
        float cA = MathHelper.func_76134_b((float)crankAngleRadians);
        float sA = MathHelper.func_76126_a((float)crankAngleRadians);
        float pistonPos2 = radius * cA + MathHelper.func_76129_c((float)(length * length - radius * radius * sA * sA));
        float bx = sA * radius;
        float by = cA * radius;
        float cx = -2.0f;
        this.armAngle2 = (float)Math.atan2(cx - bx, pistonPos2 - by);
    }
}

