/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.render;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.lighting.LightModel;
import codechicken.lib.model.bakery.generation.ILayeredBlockBakery;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.RedundantTransformation;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.automation.block.TorqueTier;
import net.shadowmage.ancientwarfare.automation.render.ITESRRenderer;
import net.shadowmage.ancientwarfare.automation.render.property.AutomationProperties;
import net.shadowmage.ancientwarfare.automation.tile.torque.multiblock.TileFlywheelStorage;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@SideOnly(value=Side.CLIENT)
public class FlywheelStorageRenderer
implements ILayeredBlockBakery,
ITESRRenderer {
    private static final String FLYWHEEL_STORAGE_REGISTRY_PATH = ":automation/flywheel_storage";
    public static final ModelResourceLocation LIGHT_MODEL_LOCATION = new ModelResourceLocation("ancientwarfare:automation/flywheel_storage", "small_light");
    public static final ModelResourceLocation MEDIUM_MODEL_LOCATION = new ModelResourceLocation("ancientwarfare:automation/flywheel_storage", "small_medium");
    public static final ModelResourceLocation HEAVY_MODEL_LOCATION = new ModelResourceLocation("ancientwarfare:automation/flywheel_storage", "small_heavy");
    public static final FlywheelStorageRenderer INSTANCE = new FlywheelStorageRenderer();
    private Collection<CCModel> spindleSmall;
    private Collection<CCModel> upperShroudSmall;
    private Collection<CCModel> lowerShroudSmall;
    private Collection<CCModel> flywheelExtensionSmall;
    private Collection<CCModel> lowerWindowSmall;
    private Collection<CCModel> upperWindowSmall;
    private Collection<CCModel> caseBarsSmall;
    private Collection<CCModel> spindleLarge;
    private Collection<CCModel> upperShroudLarge;
    private Collection<CCModel> lowerShroudLarge;
    private Collection<CCModel> flywheelExtensionLarge;
    private Collection<CCModel> lowerWindowLarge;
    private Collection<CCModel> upperWindowLarge;
    private Collection<CCModel> caseBarsLarge;
    private Map<Pair<Boolean, TorqueTier>, IconTransformation> iconTransformations = Maps.newHashMap();
    private Map<Pair<Boolean, TorqueTier>, TextureAtlasSprite> sprites = Maps.newHashMap();

    public void setSprite(boolean large, TorqueTier tier, TextureAtlasSprite sprite) {
        this.sprites.put((Pair<Boolean, TorqueTier>)new ImmutablePair((Object)large, (Object)tier), sprite);
        this.iconTransformations.put((Pair<Boolean, TorqueTier>)new ImmutablePair((Object)large, (Object)tier), new IconTransformation(sprite));
    }

    public TextureAtlasSprite getSprite(TorqueTier tier) {
        return this.sprites.get(new ImmutablePair((Object)false, (Object)tier));
    }

    private IconTransformation getIconTransformation(boolean large, TorqueTier tier) {
        return this.iconTransformations.get(new ImmutablePair((Object)large, (Object)tier));
    }

    private FlywheelStorageRenderer() {
        Map<String, CCModel> smallModel = this.loadModel("flywheel_small.obj");
        this.flywheelExtensionSmall = this.removeGroups(smallModel, s -> s.startsWith("spindle.flywheelExtension."));
        this.spindleSmall = this.removeGroups(smallModel, s -> s.startsWith("spindle."));
        this.upperShroudSmall = this.removeGroups(smallModel, s -> s.startsWith("shroudUpper."));
        this.lowerShroudSmall = this.removeGroups(smallModel, s -> s.startsWith("shroudLower."));
        this.lowerWindowSmall = this.setAlpha(this.removeGroups(smallModel, s -> s.startsWith("windowLower.")), 0.25);
        this.upperWindowSmall = this.setAlpha(this.removeGroups(smallModel, s -> s.startsWith("windowUpper.")), 0.25);
        this.caseBarsSmall = this.removeGroups(smallModel, s -> s.startsWith("caseBars."));
        Map<String, CCModel> largeModel = this.loadModel("flywheel_large.obj");
        this.flywheelExtensionLarge = this.removeGroups(largeModel, s -> s.startsWith("spindle.flywheelExtension."));
        this.spindleLarge = this.removeGroups(largeModel, s -> s.startsWith("spindle."));
        this.upperShroudLarge = this.removeGroups(largeModel, s -> s.startsWith("shroudUpper."));
        this.lowerShroudLarge = this.removeGroups(largeModel, s -> s.startsWith("shroudLower."));
        this.lowerWindowLarge = this.setAlpha(this.removeGroups(largeModel, s -> s.startsWith("windowLower.")), 0.25);
        this.upperWindowLarge = this.setAlpha(this.removeGroups(largeModel, s -> s.startsWith("windowUpper.")), 0.25);
        this.caseBarsLarge = this.removeGroups(largeModel, s -> s.startsWith("caseBars."));
    }

    private Map<String, CCModel> loadModel(String modelName) {
        Map ret = OBJParser.parseModels((ResourceLocation)new ResourceLocation("ancientwarfare", "models/block/automation/" + modelName), (int)7, (Transformation)new RedundantTransformation());
        for (Map.Entry entry : ret.entrySet()) {
            entry.setValue(((CCModel)entry.getValue()).backfacedCopy().computeNormals());
        }
        return ret;
    }

    private Collection<CCModel> removeGroups(Map<String, CCModel> objGroups, Function<String, Boolean> filter) {
        HashSet ret = Sets.newHashSet();
        Iterator<Map.Entry<String, CCModel>> iterator = objGroups.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, CCModel> entry = iterator.next();
            if (!filter.apply(entry.getKey()).booleanValue()) continue;
            ret.add(entry.getValue());
            iterator.remove();
        }
        return ret;
    }

    private Collection<CCModel> transformModels(Collection<CCModel> groups, Transformation transform) {
        return groups.stream().map(e -> e.copy().apply(transform)).collect(Collectors.toSet());
    }

    public List<BakedQuad> bakeItemQuads(@Nullable EnumFacing face, ItemStack stack) {
        BakingVertexBuffer buffer = BakingVertexBuffer.create();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.bind((BufferBuilder)buffer);
        TorqueTier tier = TorqueTier.byMetadata(stack.func_77960_j());
        HashSet transformedModels = Sets.newHashSet();
        transformedModels.addAll(this.getTransformedModels(BlockRenderLayer.SOLID, false, true, 0.0f, 1));
        transformedModels.addAll(this.getTransformedModels(BlockRenderLayer.SOLID, false, false, 0.0f, 1));
        transformedModels.addAll(this.getTransformedModels(BlockRenderLayer.TRANSLUCENT, false, false, 0.0f, 1));
        this.renderModels(transformedModels, ccrs, false, tier);
        buffer.func_178977_d();
        return buffer.bake();
    }

    public List<BakedQuad> bakeLayerFace(@Nullable EnumFacing face, BlockRenderLayer layer, IExtendedBlockState state) {
        if (face != null || !((Boolean)state.getValue(AutomationProperties.IS_CONTROL)).booleanValue()) {
            return Collections.emptyList();
        }
        BakingVertexBuffer buffer = BakingVertexBuffer.create();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.bind((BufferBuilder)buffer);
        boolean largeModel = (Integer)state.getValue(AutomationProperties.WIDTH) > 1;
        TorqueTier tier = (TorqueTier)((Object)state.func_177229_b(AutomationProperties.TIER));
        this.renderModels(this.getTransformedModels(layer, state), ccrs, largeModel, tier);
        buffer.func_178977_d();
        return buffer.bake();
    }

    private Set<CCModel> getTransformedModels(BlockRenderLayer layer, IExtendedBlockState state) {
        if (!((Boolean)state.getValue(AutomationProperties.IS_CONTROL)).booleanValue()) {
            return Collections.emptySet();
        }
        boolean largeModel = (Integer)state.getValue(AutomationProperties.WIDTH) > 1;
        boolean displayDynamicParts = (Boolean)state.getValue(AutomationProperties.DYNAMIC);
        float rotation = ((Float)state.getValue(AutomationProperties.ROTATION)).floatValue();
        int height = (Integer)state.getValue(AutomationProperties.HEIGHT);
        return this.getTransformedModels(layer, largeModel, displayDynamicParts, rotation, height);
    }

    private Set<CCModel> getTransformedModels(BlockRenderLayer layer, boolean largeModel, boolean displayDynamicParts, float rotation, int height) {
        HashSet transformedGroups;
        block5: {
            Collection<CCModel> upperWindow;
            Collection<CCModel> lowerShroud;
            Collection<CCModel> upperShroud;
            Collection<CCModel> lowerWindow;
            Collection<CCModel> caseBars;
            block4: {
                transformedGroups = Sets.newHashSet();
                Collection<CCModel> spindle = largeModel ? this.spindleLarge : this.spindleSmall;
                Collection<CCModel> flywheelExtension = largeModel ? this.flywheelExtensionLarge : this.flywheelExtensionSmall;
                caseBars = largeModel ? this.caseBarsLarge : this.caseBarsSmall;
                lowerWindow = largeModel ? this.lowerWindowLarge : this.lowerWindowSmall;
                upperShroud = largeModel ? this.upperShroudLarge : this.upperShroudSmall;
                lowerShroud = largeModel ? this.lowerShroudLarge : this.lowerShroudSmall;
                Collection<CCModel> collection = upperWindow = largeModel ? this.upperWindowLarge : this.upperWindowSmall;
                if (!displayDynamicParts) break block4;
                if (layer != BlockRenderLayer.SOLID) break block5;
                Transformation rotationTransform = new Rotation((double)rotation, 0.0, 1.0, 0.0).at(Vector3.center);
                for (int i = 0; i < height; ++i) {
                    Translation translation = new Translation(0.0, (double)i, 0.0);
                    transformedGroups.addAll(this.transformModels(spindle, (Transformation)translation.with(rotationTransform)));
                    if (i >= height - 1) continue;
                    transformedGroups.addAll(this.transformModels(flywheelExtension, (Transformation)translation.with(rotationTransform)));
                }
                break block5;
            }
            for (int i = 0; i < height; ++i) {
                Translation translation = new Translation(0.0, (double)i, 0.0);
                if (layer == BlockRenderLayer.SOLID) {
                    transformedGroups.addAll(this.transformModels(caseBars, (Transformation)translation));
                    if (i == height - 1) {
                        transformedGroups.addAll(this.transformModels(upperShroud, (Transformation)translation));
                    }
                    if (i != 0) continue;
                    transformedGroups.addAll(this.transformModels(lowerShroud, (Transformation)translation));
                    continue;
                }
                transformedGroups.addAll(this.transformModels(lowerWindow, (Transformation)translation));
                if (i >= height - 1) continue;
                transformedGroups.addAll(this.transformModels(upperWindow, (Transformation)translation));
            }
        }
        return transformedGroups;
    }

    private Collection<CCModel> setAlpha(Collection<CCModel> models, double alpha) {
        models.forEach(m -> m.setColour(new ColourRGBA(1.0, 1.0, 1.0, alpha).pack()));
        return models;
    }

    public IExtendedBlockState handleState(IExtendedBlockState state, IBlockAccess access, BlockPos pos) {
        Optional<TileFlywheelStorage> te = WorldTools.getTile(access, pos, TileFlywheelStorage.class);
        boolean isControl = true;
        int height = 1;
        int width = 1;
        if (te.isPresent()) {
            TileFlywheelStorage storage = te.get();
            isControl = storage.isControl;
            width = storage.setWidth;
            height = storage.setHeight;
        }
        IExtendedBlockState updatedState = state.withProperty(AutomationProperties.DYNAMIC, (Object)false);
        updatedState = updatedState.withProperty(AutomationProperties.IS_CONTROL, (Object)isControl);
        updatedState = updatedState.withProperty(AutomationProperties.HEIGHT, (Object)height);
        updatedState = updatedState.withProperty(AutomationProperties.WIDTH, (Object)width);
        updatedState = updatedState.withProperty(AutomationProperties.ROTATION, (Object)Float.valueOf(0.0f));
        return updatedState;
    }

    private void renderModels(Collection<CCModel> modelGroups, CCRenderState ccrs, boolean large, TorqueTier tier) {
        for (CCModel group : modelGroups) {
            group.render(ccrs, new IVertexOperation[]{this.getIconTransformation(large, tier)});
        }
    }

    @Override
    public void renderTransformedBlockModels(CCRenderState ccrs, IExtendedBlockState state) {
        TextureUtils.bindBlockTexture();
        boolean largeModel = (Integer)state.getValue(AutomationProperties.WIDTH) > 1;
        TorqueTier tier = (TorqueTier)((Object)state.func_177229_b(AutomationProperties.TIER));
        Set<CCModel> modelGroups = this.getTransformedModels(BlockRenderLayer.SOLID, state);
        for (CCModel group : modelGroups) {
            group.render(ccrs, new IVertexOperation[]{LightModel.standardLightModel, this.getIconTransformation(largeModel, tier)});
        }
    }
}

