/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.render;

import codechicken.lib.render.CCModel;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.shadowmage.ancientwarfare.automation.block.BlockFlywheelController;
import net.shadowmage.ancientwarfare.automation.render.TorqueTieredRenderer;
import net.shadowmage.ancientwarfare.automation.render.property.AutomationProperties;
import net.shadowmage.ancientwarfare.automation.tile.torque.TileFlywheelController;

public class FlywheelControllerRenderer
extends TorqueTieredRenderer<TileFlywheelController> {
    public static final ModelResourceLocation LIGHT_MODEL_LOCATION = new ModelResourceLocation("ancientwarfare:automation/flywheel_controller", "light");
    public static final ModelResourceLocation MEDIUM_MODEL_LOCATION = new ModelResourceLocation("ancientwarfare:automation/flywheel_controller", "medium");
    public static final ModelResourceLocation HEAVY_MODEL_LOCATION = new ModelResourceLocation("ancientwarfare:automation/flywheel_controller", "heavy");
    public static final FlywheelControllerRenderer INSTANCE = new FlywheelControllerRenderer();
    private Collection<CCModel> controlInput = this.removeGroups(s -> s.startsWith("inputGear"));
    private Collection<CCModel> controlOutput = this.removeGroups(s -> s.startsWith("outputGear"));
    private Collection<CCModel> controlSpindle = this.removeGroups(s -> s.startsWith("spindle"));

    private FlywheelControllerRenderer() {
        super("automation/flywheel_controller.obj");
    }

    @Override
    protected void transformMovingParts(Collection<CCModel> transformedGroups, EnumFacing frontFacing, float[] rotations, @Nullable IExtendedBlockState state) {
        float outputRotation = 0.0f;
        float inputRotation = 0.0f;
        float flywheelRotation = 0.0f;
        if (state != null) {
            inputRotation = outputRotation = ((Float)state.getValue(AutomationProperties.ROTATIONS[frontFacing.ordinal()])).floatValue();
            flywheelRotation = ((Float)state.getValue(BlockFlywheelController.FLYWHEEL_ROTATION)).floatValue();
            if (((Boolean)state.getValue(AutomationProperties.USE_INPUT)).booleanValue()) {
                inputRotation = ((Float)state.getValue(AutomationProperties.INPUT_ROTATION)).floatValue();
            }
        }
        transformedGroups.addAll(this.rotateModels(this.controlInput, frontFacing, new Rotation((double)inputRotation, 0.0, 0.0, 1.0).at(Vector3.center)));
        transformedGroups.addAll(this.rotateModels(this.controlOutput, frontFacing, new Rotation((double)outputRotation, 0.0, 0.0, 1.0).at(Vector3.center)));
        transformedGroups.addAll(this.rotateModels(this.controlSpindle, frontFacing, new Rotation((double)flywheelRotation, 0.0, 1.0, 0.0).at(Vector3.center)));
    }

    @Override
    protected IExtendedBlockState handleAdditionalProperties(IExtendedBlockState state, TileFlywheelController tileEntity) {
        state = super.handleAdditionalProperties(state, tileEntity);
        state = state.withProperty(BlockFlywheelController.FLYWHEEL_ROTATION, (Object)Float.valueOf(0.0f));
        state = state.withProperty(AutomationProperties.USE_INPUT, (Object)false);
        state = state.withProperty(AutomationProperties.INPUT_ROTATION, (Object)Float.valueOf(0.0f));
        return state;
    }
}

