/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.gui;

import java.util.Set;
import net.minecraft.util.EnumFacing;
import net.shadowmage.ancientwarfare.automation.container.ContainerWorksiteInventorySideSelection;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteBoundedInventory;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.block.Direction;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;

public class GuiWorksiteInventorySideSelection
extends GuiContainerBase<ContainerWorksiteInventorySideSelection> {
    public GuiWorksiteInventorySideSelection(ContainerBase par1Container) {
        super(par1Container, 191, 106);
    }

    @Override
    public void initElements() {
    }

    @Override
    protected boolean onGuiCloseRequested() {
        ((ContainerWorksiteInventorySideSelection)((Object)this.getContainer())).close();
        return false;
    }

    @Override
    public void setupElements() {
        this.clearElements();
        Label label = new Label(8, 6, "guistrings.automation.block_side");
        this.addGuiElement(label);
        label = new Label(74, 6, "guistrings.automation.direction");
        this.addGuiElement(label);
        label = new Label(128, 6, "guistrings.automation.inventory_accessed");
        this.addGuiElement(label);
        int height = 18;
        for (BlockRotationHandler.RelativeSide side : ((ContainerWorksiteInventorySideSelection)((Object)this.getContainer())).sideMap.keySet()) {
            label = new Label(8, height, side.getTranslationKey());
            this.addGuiElement(label);
            EnumFacing dir = BlockRotationHandler.RelativeSide.getMCSideToAccess(BlockRotationHandler.RotationType.FOUR_WAY, ((TileWorksiteBoundedInventory)((ContainerWorksiteInventorySideSelection)((Object)this.getContainer())).tileEntity).getPrimaryFacing(), side);
            label = new Label(74, height, Direction.getDirectionFor(dir).getTranslationKey());
            this.addGuiElement(label);
            BlockRotationHandler.RelativeSide accessed = ((ContainerWorksiteInventorySideSelection)((Object)this.getContainer())).sideMap.get((Object)side);
            SideButton sideButton = new SideButton(128, height, side, accessed);
            this.addGuiElement(sideButton);
            height += 14;
        }
    }

    private class SideButton
    extends Button {
        final BlockRotationHandler.RelativeSide side;
        BlockRotationHandler.RelativeSide selection;

        public SideButton(int topLeftX, int topLeftY, BlockRotationHandler.RelativeSide side, BlockRotationHandler.RelativeSide selection) {
            super(topLeftX, topLeftY, 55, 12, selection.getTranslationKey());
            if (side == null) {
                throw new IllegalArgumentException("access side may not be null..");
            }
            this.side = side;
            this.selection = selection;
        }

        @Override
        protected void onPressed() {
            int ordinal = this.selection.ordinal();
            Set<BlockRotationHandler.RelativeSide> validSides = ((TileWorksiteBoundedInventory)((ContainerWorksiteInventorySideSelection)((Object)GuiWorksiteInventorySideSelection.this.getContainer())).tileEntity).getSideInventories().keySet();
            for (int i = 0; i < BlockRotationHandler.RelativeSide.values().length; ++i) {
                BlockRotationHandler.RelativeSide next;
                if (++ordinal >= BlockRotationHandler.RelativeSide.values().length) {
                    ordinal = 0;
                }
                if (!validSides.contains((Object)(next = BlockRotationHandler.RelativeSide.values()[ordinal])) && next != BlockRotationHandler.RelativeSide.NONE) continue;
                this.selection = next;
                break;
            }
            ((ContainerWorksiteInventorySideSelection)((Object)GuiWorksiteInventorySideSelection.this.getContainer())).sideMap.put(this.side, this.selection);
            this.setText(this.selection.getTranslationKey());
            ((ContainerWorksiteInventorySideSelection)((Object)GuiWorksiteInventorySideSelection.this.getContainer())).sendSlotChange(this.side, this.selection);
        }
    }
}

