/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.gui;

import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.automation.container.ContainerWarehouseStockLinker;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStockLinker;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.interfaces.ITooltipRenderer;

public class GuiWarehouseStockLinker
extends GuiContainerBase<ContainerWarehouseStockLinker> {
    private CompositeScrolled area;

    public GuiWarehouseStockLinker(ContainerBase par1Container) {
        super(par1Container, 250, 172);
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 0, 250, 80);
        this.addGuiElement(this.area);
    }

    @Override
    public void setupElements() {
        Button button;
        this.area.clearElements();
        int totalHeight = 8;
        for (final TileWarehouseStockLinker.WarehouseStockFilter filter : ((ContainerWarehouseStockLinker)((Object)this.getContainer())).filters) {
            FilterItemSlot slot = new FilterItemSlot(8, totalHeight, filter, this);
            this.area.addGuiElement(slot);
            String text = filter.getFilterItem().func_190926_b() ? "Empty Filter" : filter.getFilterItem().func_82833_r();
            Label label = new Label(28, totalHeight + 4, text);
            this.area.addGuiElement(label);
            button = new FilterRemoveButton(this.field_146999_f - 20, totalHeight + 4, filter);
            this.area.addGuiElement(button);
            text = String.valueOf(filter.getQuantity());
            label = new Label(this.field_146999_f - 120 - this.field_146289_q.func_78256_a(text), totalHeight + 4, String.valueOf(filter.getQuantity()));
            this.area.addGuiElement(label);
            Button equalitySign = new Button(this.field_146999_f - 80, totalHeight + 4, 10, 12, filter.equalitySignType.getTranslationKey()){

                @Override
                protected void onPressed(int mButton) {
                    filter.changeEqualitySign(mButton == 1);
                    ((ContainerWarehouseStockLinker)((Object)GuiWarehouseStockLinker.this.getContainer())).sendFiltersToServer();
                    GuiWarehouseStockLinker.this.refreshGui();
                }
            };
            this.area.addGuiElement(equalitySign);
            NumberInput compareValue = new NumberInput(this.field_146999_f - 70, totalHeight + 4, 50, filter.compareValue, this){

                @Override
                public void onValueUpdated(float value) {
                    filter.setCompareValue((int)value);
                    ((ContainerWarehouseStockLinker)((Object)GuiWarehouseStockLinker.this.getContainer())).sendFiltersToServer();
                    GuiWarehouseStockLinker.this.refreshGui();
                }
            };
            compareValue.setIntegerValue();
            this.area.addGuiElement(compareValue);
            compareValue.setValue(filter.compareValue);
            totalHeight += 16;
        }
        if (((ContainerWarehouseStockLinker)((Object)this.getContainer())).filters.size() < 4) {
            button = new Button(8, totalHeight + 4, 154, 12, "guistrings.automation.new_filter"){

                @Override
                protected void onPressed() {
                    ((ContainerWarehouseStockLinker)((Object)GuiWarehouseStockLinker.this.getContainer())).filters.add(new TileWarehouseStockLinker.WarehouseStockFilter(ItemStack.field_190927_a, 0, 0, 0));
                    ((ContainerWarehouseStockLinker)((Object)GuiWarehouseStockLinker.this.getContainer())).sendFiltersToServer();
                    GuiWarehouseStockLinker.this.refreshGui();
                }
            };
            this.area.addGuiElement(button);
            totalHeight += 16;
        }
        this.area.setAreaSize(totalHeight);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        return super.onGuiCloseRequested();
    }

    private class FilterItemSlot
    extends ItemSlot {
        TileWarehouseStockLinker.WarehouseStockFilter filter;

        private FilterItemSlot(int topLeftX, int topLeftY, TileWarehouseStockLinker.WarehouseStockFilter filter, ITooltipRenderer render) {
            super(topLeftX, topLeftY, filter.getFilterItem(), render);
            this.filter = filter;
            this.renderItemQuantity = false;
        }

        @Override
        public void onSlotClicked(ItemStack stack, boolean rightClicked) {
            ItemStack in = stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
            this.setItem(in);
            if (!in.func_190926_b()) {
                in.func_190920_e(1);
            }
            this.filter.setItem(in.func_190926_b() ? ItemStack.field_190927_a : in.func_77946_l());
            ((ContainerWarehouseStockLinker)((Object)GuiWarehouseStockLinker.this.getContainer())).sendFiltersToServer();
        }
    }

    private class FilterRemoveButton
    extends Button {
        TileWarehouseStockLinker.WarehouseStockFilter filter;

        private FilterRemoveButton(int topLeftX, int topLeftY, TileWarehouseStockLinker.WarehouseStockFilter filter) {
            super(topLeftX, topLeftY, 12, 12, "-");
            this.filter = filter;
        }

        @Override
        protected void onPressed() {
            ((ContainerWarehouseStockLinker)((Object)GuiWarehouseStockLinker.this.getContainer())).filters.remove(this.filter);
            ((ContainerWarehouseStockLinker)((Object)GuiWarehouseStockLinker.this.getContainer())).sendFiltersToServer();
            GuiWarehouseStockLinker.this.refreshGui();
        }
    }
}

