/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.automation.tile.worksite.WorkSiteQuarry;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.core.interfaces.IBoundedSite;
import net.shadowmage.ancientwarfare.core.util.BlockTools;

public class ContainerWorksiteQuarryBounds
extends ContainerTileBase<WorkSiteQuarry> {
    public int maxHeight;

    public ContainerWorksiteQuarryBounds(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        this.maxHeight = ((WorkSiteQuarry)this.tileEntity).height;
    }

    @Override
    public void sendInitData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("height", this.maxHeight);
        this.sendDataToClient(tag);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        this.maxHeight = tag.func_74762_e("height");
        if (tag.func_74764_b("guiClosed")) {
            this.getWorksite().onBoundsAdjusted();
            this.getWorksite().onPostBoundsAdjusted();
            BlockTools.notifyBlockUpdate(this.player.field_70170_p, this.getPos());
        }
        if (!this.player.field_70170_p.field_72995_K) {
            ((WorkSiteQuarry)this.tileEntity).height = this.maxHeight;
            ((WorkSiteQuarry)this.tileEntity).func_70296_d();
        }
        this.refreshGui();
    }

    public void sendSettingsToServer() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("height", this.maxHeight);
        this.sendDataToServer(tag);
    }

    public void func_75142_b() {
        super.func_75142_b();
        boolean send = false;
        if (this.maxHeight != ((WorkSiteQuarry)this.tileEntity).height) {
            this.maxHeight = ((WorkSiteQuarry)this.tileEntity).height;
            send = true;
        }
        if (send) {
            this.sendInitData();
        }
    }

    public void onClose(boolean boundsAdjusted) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("guiClosed", true);
        if (boundsAdjusted) {
            tag.func_74768_a("height", this.maxHeight);
        }
        this.sendDataToServer(tag);
    }

    public BlockPos getPos() {
        return ((WorkSiteQuarry)this.tileEntity).func_174877_v();
    }

    public int getX() {
        return ((WorkSiteQuarry)this.tileEntity).func_174877_v().func_177958_n();
    }

    public int getY() {
        return ((WorkSiteQuarry)this.tileEntity).func_174877_v().func_177956_o();
    }

    public int getZ() {
        return ((WorkSiteQuarry)this.tileEntity).func_174877_v().func_177952_p();
    }

    public IBoundedSite getWorksite() {
        return (IBoundedSite)this.tileEntity;
    }
}

