/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.automation.tile.worksite.TileWorksiteFarm;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.core.interfaces.IBoundedSite;
import net.shadowmage.ancientwarfare.core.util.BlockTools;

public class ContainerWorksiteBoundsAdjust
extends ContainerTileBase {
    public BlockPos min;
    public BlockPos max;

    public ContainerWorksiteBoundsAdjust(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        if (!(this.tileEntity instanceof IBoundedSite)) {
            throw new IllegalArgumentException("Couldn't find work site");
        }
        this.min = this.getWorksite().getWorkBoundsMin();
        this.max = this.getWorksite().getWorkBoundsMax();
    }

    @Override
    public void sendInitData() {
        if (this.tileEntity instanceof TileWorksiteFarm) {
            TileWorksiteFarm twub = (TileWorksiteFarm)this.tileEntity;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74773_a("checkedMap", twub.getTargetMap());
            this.sendDataToGui(tag);
        }
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b("guiClosed")) {
            if (tag.func_74764_b("min") && tag.func_74764_b("max")) {
                BlockPos min = BlockPos.func_177969_a((long)tag.func_74763_f("min"));
                BlockPos max = BlockPos.func_177969_a((long)tag.func_74763_f("max"));
                this.getWorksite().setWorkBoundsMin(min);
                this.getWorksite().setWorkBoundsMax(max);
                this.getWorksite().onBoundsAdjusted();
                this.getWorksite().onPostBoundsAdjusted();
            }
            if (tag.func_74764_b("checkedMap") && this.tileEntity instanceof TileWorksiteFarm) {
                TileWorksiteFarm twub = (TileWorksiteFarm)this.tileEntity;
                byte[] map = tag.func_74770_j("checkedMap");
                twub.setTargetBlocks(map);
            }
            BlockTools.notifyBlockUpdate(this.player.field_70170_p, this.getPos());
        }
    }

    public void onClose(boolean boundsAdjusted, boolean targetsAdjusted, byte[] checkedMap) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("guiClosed", true);
        if (boundsAdjusted) {
            tag.func_74772_a("min", this.min.func_177986_g());
            tag.func_74772_a("max", this.max.func_177986_g());
        }
        if (targetsAdjusted && this.tileEntity instanceof TileWorksiteFarm) {
            tag.func_74773_a("checkedMap", checkedMap);
        }
        this.sendDataToServer(tag);
    }

    public BlockPos getPos() {
        return this.tileEntity.func_174877_v();
    }

    public int getX() {
        return this.tileEntity.func_174877_v().func_177958_n();
    }

    public int getY() {
        return this.tileEntity.func_174877_v().func_177956_o();
    }

    public int getZ() {
        return this.tileEntity.func_174877_v().func_177952_p();
    }

    public IBoundedSite getWorksite() {
        return (IBoundedSite)this.tileEntity;
    }
}

