/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.block;

import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.automation.block.BlockBaseAutomation;
import net.shadowmage.ancientwarfare.automation.gui.GuiWarehouseStorage;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStorage;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStorageLarge;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStorageMedium;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.ModelLoaderHelper;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public class BlockWarehouseStorage
extends BlockBaseAutomation {
    private static final PropertyEnum<Size> SIZE = PropertyEnum.func_177709_a((String)"size", Size.class);

    public BlockWarehouseStorage(String regName) {
        super(Material.field_151575_d, regName);
        this.func_149711_c(2.0f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SIZE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SIZE, (Comparable)((Object)Size.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Size)((Object)state.func_177229_b(SIZE))).getMeta();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((Size)((Object)state.func_177229_b(SIZE))) {
            case MEDIUM: {
                return new TileWarehouseStorageMedium();
            }
            case LARGE: {
                return new TileWarehouseStorageLarge();
            }
        }
        return new TileWarehouseStorage();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 1));
        items.add((Object)new ItemStack((Block)this, 1, 2));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return WorldTools.clickInteractableTileWithHand(world, pos, player, hand);
    }

    public int func_180651_a(IBlockState state) {
        return ((Size)((Object)state.func_177229_b(SIZE))).getMeta();
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        return WorldTools.sendClientEventToTile((IBlockAccess)world, pos, id, param);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        final ResourceLocation assetLocation = new ResourceLocation("ancientwarfare", "automation/" + this.getRegistryName().func_110623_a());
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(assetLocation, this.func_178131_a((Map)state.func_177228_b()));
            }
        });
        ModelLoaderHelper.registerItem(Item.func_150898_a((Block)this), "automation", false, meta -> "size=" + Size.values()[meta].name().toLowerCase());
        NetworkHandler.registerGui(19, GuiWarehouseStorage.class);
    }

    public static enum Size implements IStringSerializable
    {
        SMALL(0),
        MEDIUM(1),
        LARGE(2);

        private int meta;

        private Size(int meta) {
            this.meta = meta;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public int getMeta() {
            return this.meta;
        }

        public static Size byMetadata(int meta) {
            return Size.values()[meta];
        }
    }
}

