/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.automation.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.automation.block.BlockBaseAutomation;
import net.shadowmage.ancientwarfare.automation.gui.GuiWarehouseStockViewer;
import net.shadowmage.ancientwarfare.automation.tile.warehouse2.TileWarehouseStockViewer;
import net.shadowmage.ancientwarfare.core.block.BlockRotationHandler;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;

public class BlockWarehouseStockViewer
extends BlockBaseAutomation
implements BlockRotationHandler.IRotatableBlock {
    private static final Map<EnumFacing, AxisAlignedBB> AABBS;

    public BlockWarehouseStockViewer(String regName) {
        super(Material.field_151576_e, regName);
        this.func_149711_c(2.0f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CoreProperties.FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)BlockTools.getHorizontalFacingFromMeta(meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)).ordinal();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO());
    }

    @Override
    public BlockRotationHandler.RotationType getRotationType() {
        return BlockRotationHandler.RotationType.FOUR_WAY;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean invertFacing() {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABBS.get(state.func_177229_b((IProperty)CoreProperties.FACING));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileWarehouseStockViewer();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return WorldTools.clickInteractableTileWithHand(world, pos, player, hand);
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        return WorldTools.sendClientEventToTile((IBlockAccess)world, pos, id, param);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        super.registerClient();
        NetworkHandler.registerGui(20, GuiWarehouseStockViewer.class);
    }

    static {
        float wmin = 0.125f;
        float wmax = 0.875f;
        float hmin = 0.375f;
        float hmax = 0.875f;
        AABBS = ImmutableMap.of((Object)EnumFacing.WEST, (Object)new AxisAlignedBB((double)wmax, (double)hmin, 0.0, 1.0, (double)hmax, 1.0), (Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.0, (double)hmin, 0.0, (double)wmin, (double)hmax, 1.0), (Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.0, (double)hmin, 0.0, 1.0, (double)hmax, (double)wmin), (Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.0, (double)hmin, (double)wmax, 1.0, (double)hmax, 1.0));
    }
}

