/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.features.dwarven;

import com.ferreusveritas.cathedral.CathedralMod;
import com.ferreusveritas.cathedral.features.dwarven.ItemTallDoor;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTallDoor
extends Block {
    public static final PropertyEnum<EnumDoorThird> THIRD = PropertyEnum.func_177709_a((String)"third", EnumDoorThird.class);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
    ItemTallDoor doorItem;

    protected BlockTallDoor(Material materialIn, String name) {
        super(materialIn);
        this.setRegistryName(name);
        this.func_149663_c(name);
        this.func_149647_a(CathedralMod.tabDwemer);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)BlockDoor.field_176522_N, (Comparable)Boolean.valueOf(false)).func_177226_a(THIRD, (Comparable)((Object)EnumDoorThird.LOWER)));
    }

    public BlockTallDoor setDoorItem(ItemTallDoor doorItem) {
        this.doorItem = doorItem;
        return this;
    }

    public ItemTallDoor getDoorItem() {
        return this.doorItem;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a);
        boolean open = (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b) == false;
        boolean hingeOnRight = state.func_177229_b((IProperty)BlockDoor.field_176521_M) == BlockDoor.EnumHingePosition.RIGHT;
        switch (enumfacing) {
            default: {
                return open ? EAST_AABB : (hingeOnRight ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return open ? SOUTH_AABB : (hingeOnRight ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return open ? WEST_AABB : (hingeOnRight ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return open ? NORTH_AABB : (hingeOnRight ? WEST_AABB : EAST_AABB);
    }

    public BlockPos getPartnerPos(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a);
        boolean hingeOnRight = state.func_177229_b((IProperty)BlockDoor.field_176521_M) == BlockDoor.EnumHingePosition.RIGHT;
        switch (enumfacing) {
            default: {
                return hingeOnRight ? pos.func_177978_c() : pos.func_177968_d();
            }
            case SOUTH: {
                return hingeOnRight ? pos.func_177974_f() : pos.func_177976_e();
            }
            case WEST: {
                return hingeOnRight ? pos.func_177968_d() : pos.func_177978_c();
            }
            case NORTH: 
        }
        return hingeOnRight ? pos.func_177976_e() : pos.func_177974_f();
    }

    public String func_149732_F() {
        return I18n.func_74838_a((String)(this.func_149739_a() + ".name").replaceAll("tile", "item"));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return (Boolean)this.func_176221_a(worldIn.func_180495_p(pos), worldIn, pos).func_177229_b((IProperty)BlockDoor.field_176519_b);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private int getCloseSound() {
        return 1011;
    }

    private int getOpenSound() {
        return 1005;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151647_F;
    }

    public BlockPos getBottomPos(BlockPos pos, IBlockState state) {
        return pos.func_177979_c(((EnumDoorThird)((Object)state.func_177229_b(THIRD))).ordinal());
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState iblockstate;
        BlockPos bottomPos = this.getBottomPos(pos, state);
        IBlockState iBlockState = iblockstate = pos.equals((Object)bottomPos) ? state : worldIn.func_180495_p(bottomPos);
        if (iblockstate.func_177230_c() != this) {
            return false;
        }
        this.setDoorAjar(worldIn, pos, !this.isDoorAjar(state, (IBlockAccess)worldIn, pos));
        return true;
    }

    public void setDoorAjar(World worldIn, BlockPos pos, boolean open) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (iblockstate.func_177230_c() == this) {
            IBlockState bottomState;
            BlockPos bottomPos = this.getBottomPos(pos, iblockstate);
            IBlockState iBlockState = bottomState = pos == bottomPos ? iblockstate : worldIn.func_180495_p(bottomPos);
            if (bottomState.func_177230_c() == this && (Boolean)bottomState.func_177229_b((IProperty)BlockDoor.field_176519_b) != open) {
                BlockTallDoor partnerBlock;
                boolean isPartnerOpen;
                worldIn.func_180501_a(bottomPos, bottomState.func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf(open)), 10);
                worldIn.func_175704_b(bottomPos, bottomPos.func_177981_b(2));
                worldIn.func_180498_a((EntityPlayer)null, open ? this.getOpenSound() : this.getCloseSound(), pos, 0);
                BlockPos partnerPos = this.getPartnerPos(bottomState, (IBlockAccess)worldIn, bottomPos);
                IBlockState partnerState = worldIn.func_180495_p(partnerPos);
                if (partnerState.func_177230_c() == this && (isPartnerOpen = (partnerBlock = (BlockTallDoor)partnerState.func_177230_c()).isDoorAjar(partnerState, (IBlockAccess)worldIn, partnerPos)) != open) {
                    partnerBlock.setDoorAjar(worldIn, partnerPos, open);
                }
            }
        }
    }

    public boolean isDoorAjar(IBlockState state, IBlockAccess access, BlockPos pos) {
        IBlockState actualState = this.func_176221_a(state, access, pos);
        return actualState.func_177230_c() == this ? (Boolean)actualState.func_177229_b((IProperty)BlockDoor.field_176519_b) : false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos) {
        if (state.func_177229_b(THIRD) == EnumDoorThird.LOWER) {
            IBlockState underState;
            boolean invalid = false;
            BlockPos lowerPos = pos;
            BlockPos middlePos = pos.func_177984_a();
            BlockPos upperPos = pos.func_177981_b(2);
            BlockPos underPos = pos.func_177977_b();
            IBlockState lowerState = state;
            IBlockState middleState = world.func_180495_p(middlePos);
            IBlockState upperState = world.func_180495_p(upperPos);
            if (upperState.func_177230_c() != this) {
                world.func_175698_g(middlePos);
                world.func_175698_g(lowerPos);
                invalid = true;
            }
            if (middleState.func_177230_c() != this) {
                world.func_175698_g(upperPos);
                world.func_175698_g(lowerPos);
                invalid = true;
            }
            if (!(underState = world.func_180495_p(underPos)).isSideSolid((IBlockAccess)world, underPos, EnumFacing.UP) && !(underState.func_177230_c() instanceof BlockStairs)) {
                world.func_175698_g(lowerPos);
                invalid = true;
                if (middleState.func_177230_c() == this) {
                    world.func_175698_g(middlePos);
                }
                if (upperState.func_177230_c() == this) {
                    world.func_175698_g(upperPos);
                }
                if (!world.field_72995_K) {
                    this.func_176226_b(world, pos, state, 0);
                }
            }
            if (!invalid) {
                boolean isPoweredWorld = world.func_175640_z(lowerPos) || world.func_175640_z(middlePos) || world.func_175640_z(upperPos);
                boolean isPoweredState = (Boolean)upperState.func_177229_b((IProperty)BlockDoor.field_176522_N);
                if (neighborBlock != this && (isPoweredWorld || neighborBlock.func_176223_P().func_185897_m()) && isPoweredWorld != isPoweredState) {
                    world.func_180501_a(upperPos, upperState.func_177226_a((IProperty)BlockDoor.field_176522_N, (Comparable)Boolean.valueOf(isPoweredWorld)), 2);
                    boolean isOpen = (Boolean)lowerState.func_177229_b((IProperty)BlockDoor.field_176519_b);
                    if (isPoweredWorld != isOpen) {
                        this.setDoorAjar(world, lowerPos, isPoweredWorld);
                    }
                }
            }
        } else {
            BlockPos blockpos = pos.func_177979_c(((EnumDoorThird)((Object)state.func_177229_b(THIRD))).ordinal());
            IBlockState iblockstate = world.func_180495_p(blockpos);
            if (iblockstate.func_177230_c() != this) {
                world.func_175698_g(pos);
            } else {
                iblockstate.func_189546_a(world, blockpos, neighborBlock, fromPos);
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.getDoorItem();
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        if (pos.func_177956_o() >= worldIn.func_72800_K() - 1) {
            return false;
        }
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        return (state.func_185896_q() || state.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) == BlockFaceShape.SOLID || state.func_177230_c() instanceof BlockStairs) && super.func_176196_c(worldIn, pos) && super.func_176196_c(worldIn, pos.func_177984_a()) && super.func_176196_c(worldIn, pos.func_177981_b(2));
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getItem());
    }

    private Item getItem() {
        return this.doorItem;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        int third = ((EnumDoorThird)((Object)state.func_177229_b(THIRD))).ordinal();
        if (player.field_71075_bZ.field_75098_d) {
            BlockPos.func_177980_a((BlockPos)pos.func_177981_b(0 - third), (BlockPos)pos.func_177981_b(2 - third)).forEach(p -> worldIn.func_175698_g(p));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState[] states = new IBlockState[3];
        int third = ((EnumDoorThird)((Object)state.func_177229_b(THIRD))).ordinal();
        for (int i = 0; i < 3; ++i) {
            states[i] = worldIn.func_180495_p(pos.func_177981_b(i - third));
            if (states[i].func_177230_c() == this) continue;
            return state;
        }
        return state.func_177226_a((IProperty)BlockDoor.field_176521_M, states[0].func_177229_b((IProperty)BlockDoor.field_176521_M)).func_177226_a((IProperty)BlockDoor.field_176519_b, states[0].func_177229_b((IProperty)BlockDoor.field_176519_b)).func_177226_a((IProperty)BlockDoor.field_176520_a, states[1].func_177229_b((IProperty)BlockDoor.field_176520_a)).func_177226_a((IProperty)BlockDoor.field_176522_N, states[2].func_177229_b((IProperty)BlockDoor.field_176522_N));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177229_b(THIRD) != EnumDoorThird.MIDDLE ? state : state.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a))).func_177231_a((IProperty)BlockDoor.field_176521_M);
    }

    public IBlockState func_176203_a(int meta) {
        EnumDoorThird third = EnumDoorThird.values()[meta >> 2];
        IBlockState state = this.func_176223_P().func_177226_a(THIRD, (Comparable)((Object)third));
        switch (third) {
            case LOWER: {
                return state.func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.values()[meta & 1]).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.valueOf((meta & 2) > 0));
            }
            case MIDDLE: {
                return state.func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)).func_176735_f());
            }
            case UPPER: {
                return state.func_177226_a((IProperty)BlockDoor.field_176522_N, (Comparable)Boolean.valueOf((meta & 1) > 0));
            }
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumDoorThird)((Object)state.func_177229_b(THIRD))) {
            case LOWER: {
                return 0 | (state.func_177229_b((IProperty)BlockDoor.field_176521_M) == BlockDoor.EnumHingePosition.RIGHT ? 1 : 0) | ((Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b) != false ? 2 : 0);
            }
            case MIDDLE: {
                return 4 | ((EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a)).func_176746_e().func_176736_b();
            }
            case UPPER: {
                return 8 | ((Boolean)state.func_177229_b((IProperty)BlockDoor.field_176522_N) != false ? 1 : 0);
            }
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{THIRD, BlockDoor.field_176520_a, BlockDoor.field_176519_b, BlockDoor.field_176521_M, BlockDoor.field_176522_N});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static enum EnumHingePosition implements IStringSerializable
    {
        LEFT,
        RIGHT;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == LEFT ? "left" : "right";
        }
    }

    public static enum EnumDoorThird implements IStringSerializable
    {
        LOWER,
        MIDDLE,
        UPPER;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            switch (this) {
                case UPPER: {
                    return "upper";
                }
                case MIDDLE: {
                    return "middle";
                }
            }
            return "lower";
        }
    }
}

