/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.features.cathedral;

import com.ferreusveritas.cathedral.features.BlockForm;
import com.ferreusveritas.cathedral.features.IFeature;
import com.ferreusveritas.cathedral.features.IVariantEnumType;
import com.ferreusveritas.cathedral.features.cathedral.BlockCatwalk;
import com.ferreusveritas.cathedral.features.cathedral.BlockChain;
import com.ferreusveritas.cathedral.features.cathedral.BlockDeckPrism;
import com.ferreusveritas.cathedral.features.cathedral.BlockGargoyle;
import com.ferreusveritas.cathedral.features.cathedral.BlockGlassStained;
import com.ferreusveritas.cathedral.features.cathedral.BlockPaneStained;
import com.ferreusveritas.cathedral.features.cathedral.BlockPillar;
import com.ferreusveritas.cathedral.features.cathedral.BlockRailing;
import com.ferreusveritas.cathedral.features.cathedral.EnumMaterial;
import com.ferreusveritas.cathedral.features.cathedral.ItemDeckPrism;
import com.ferreusveritas.cathedral.features.cathedral.TileEntityDeckPrism;
import com.ferreusveritas.cathedral.models.ExtendedModelResourceLocation;
import com.ferreusveritas.cathedral.models.ModelBlockPillar;
import com.ferreusveritas.cathedral.models.ModelBlockRailing;
import com.ferreusveritas.cathedral.models.ModelLoaderKeyed;
import com.ferreusveritas.cathedral.proxy.ModelHelper;
import com.google.common.collect.Lists;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Cathedral
implements IFeature {
    public static final String featureName = "cathedral";
    public Block glassStained;
    public Block panesStained;
    public Block railingVarious;
    public Block chainVarious;
    public Block catwalkVarious;
    public Block pillarVarious;
    public Block deckPrism;
    public final BlockGargoyle[] gargoyleDemon = new BlockGargoyle[EnumMaterial.values().length];
    public static final String PILLAR = "pillar";
    public static final String RAILING = "railing";

    @Override
    public String getName() {
        return featureName;
    }

    @Override
    public void preInit() {
        GameRegistry.registerTileEntity(TileEntityDeckPrism.class, (ResourceLocation)new ResourceLocation(featureName, "deckprism"));
    }

    @Override
    public void createBlocks() {
        this.glassStained = new BlockGlassStained(this.featureObjectName(BlockForm.GLASS, "stained"));
        this.panesStained = new BlockPaneStained(this.featureObjectName(BlockForm.PANE, "stained"));
        this.railingVarious = new BlockRailing(this.featureObjectName(BlockForm.RAILING, "various"));
        this.chainVarious = new BlockChain(this.featureObjectName(BlockForm.CHAIN, "various"));
        this.catwalkVarious = new BlockCatwalk(Material.field_151573_f, this.featureObjectName(BlockForm.CATWALK, "various"));
        this.pillarVarious = new BlockPillar(this.featureObjectName(BlockForm.PILLAR, "various"));
        this.deckPrism = new BlockDeckPrism();
        for (EnumMaterial type : EnumMaterial.values()) {
            this.gargoyleDemon[type.ordinal()] = new BlockGargoyle(this.featureObjectName(BlockForm.GARGOYLE, "demon_" + type.func_176610_l()), type);
        }
    }

    @Override
    public void createItems() {
    }

    @Override
    public void registerBlocks(IForgeRegistry<Block> registry) {
        registry.registerAll((IForgeRegistryEntry[])new Block[]{this.glassStained, this.panesStained, this.railingVarious, this.chainVarious, this.pillarVarious, this.deckPrism});
        registry.registerAll((IForgeRegistryEntry[])this.gargoyleDemon);
    }

    public void railRecipe(EnumMaterial type) {
        ItemStack input = type.getRawMaterialBlock();
        if (input.func_77973_b() instanceof ItemBlock && ((ItemBlock)input.func_77973_b()).func_179223_d() != Blocks.field_150350_a) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(featureName, "railing_" + type.func_176610_l()), null, (ItemStack)new ItemStack(this.railingVarious, 8, type.getMetadata()), (Object[])new Object[]{"xxx", "x x", Character.valueOf('x'), input});
        }
    }

    public void gargoyleDemonRecipe(EnumMaterial type) {
        ItemStack input = type.getRawMaterialBlock();
        if (input.func_77973_b() instanceof ItemBlock && ((ItemBlock)input.func_77973_b()).func_179223_d() != Blocks.field_150350_a) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(featureName, "gargoyle_demon_" + type.func_176610_l()), null, (ItemStack)new ItemStack((Block)this.gargoyleDemon[type.ordinal()]), (Object[])new Object[]{" s ", "fpf", "sss", Character.valueOf('s'), input, Character.valueOf('p'), Blocks.field_150428_aP, Character.valueOf('f'), Items.field_151008_G});
        }
    }

    public void chainRecipe(BlockChain.EnumType type, IForgeRegistry<IRecipe> registry) {
        String nuggetName = "nugget" + type.getOreName();
        if (OreDictionary.doesOreNameExist((String)nuggetName)) {
            registry.register(new ShapedOreRecipe(null, new ItemStack(this.chainVarious, 4, type.getMetadata()), new Object[]{"o", "o", "o", Character.valueOf('o'), nuggetName}).setRegistryName("chain" + type.func_176610_l()));
        }
    }

    public void deckPrismRecipe(EnumDyeColor color, IForgeRegistry<IRecipe> registry) {
        String[] dyes = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
        String oreName = "blockGlass" + dyes[color.func_176767_b()];
        if (OreDictionary.doesOreNameExist((String)oreName)) {
            registry.register(new ShapedOreRecipe(null, new ItemStack(this.deckPrism, 4, color.func_176765_a()), new Object[]{"ooo", " o ", Character.valueOf('o'), oreName}).setRegistryName("deckPrism_" + color.func_176610_l()));
        }
    }

    @Override
    public void registerItems(IForgeRegistry<Item> registry) {
        this.registerMultiTextureItems(registry, stack -> EnumMaterial.byMetadata(stack.func_77960_j()).getUnlocalizedName(), this.railingVarious, this.pillarVarious);
        this.registerMultiTextureItems(registry, stack -> BlockGlassStained.EnumType.byMetadata(stack.func_77960_j()).getUnlocalizedName(), this.glassStained, this.panesStained);
        this.registerMultiTextureItems(registry, stack -> BlockChain.EnumType.byMetadata(stack.func_77960_j()).getUnlocalizedName(), this.chainVarious);
        registry.register(new ItemDeckPrism(this.deckPrism).setRegistryName(this.deckPrism.getRegistryName()));
        for (BlockGargoyle gargoyleBlock : this.gargoyleDemon) {
            registry.register(new ItemBlock((Block)gargoyleBlock).setRegistryName(gargoyleBlock.getRegistryName()));
        }
    }

    public void registerMultiTextureItems(IForgeRegistry<Item> registry, ItemMultiTexture.Mapper mapper, Block ... blocks) {
        Lists.newArrayList((Object[])blocks).forEach(block -> registry.register(new ItemMultiTexture(block, block, mapper).setRegistryName(block.getRegistryName())));
    }

    @Override
    public void registerRecipes(IForgeRegistry<IRecipe> registry) {
        registry.register(new ShapedOreRecipe(null, new ItemStack(this.glassStained, 16, 0), new Object[]{"cgm", "glg", "ygp", Character.valueOf('l'), OreDictionary.doesOreNameExist((String)"ingotLead") ? "ingotLead" : "ingotIron", Character.valueOf('g'), "blockGlass", Character.valueOf('c'), "dyeCyan", Character.valueOf('m'), "dyeMagenta", Character.valueOf('y'), "dyeYellow", Character.valueOf('p'), "dyePink"}).setRegistryName("stainedglass"));
        for (BlockGlassStained.EnumType enumType : BlockGlassStained.EnumType.values()) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(featureName, "pane_stained_" + enumType.func_176610_l()), null, (ItemStack)new ItemStack(this.panesStained, 16, enumType.getMetadata()), (Object[])new Object[]{"ggg", "ggg", Character.valueOf('g'), new ItemStack(this.glassStained, 1, enumType.getMetadata())});
        }
        for (Enum enum_ : EnumMaterial.values()) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(featureName, "pillar_" + ((EnumMaterial)enum_).func_176610_l()), null, (ItemStack)new ItemStack(this.pillarVarious, 4, ((EnumMaterial)enum_).getMetadata()), (Object[])new Object[]{"s", "s", "s", Character.valueOf('s'), ((EnumMaterial)enum_).getRawMaterialBlock()});
        }
        for (Enum enum_ : EnumMaterial.values()) {
            this.railRecipe((EnumMaterial)enum_);
        }
        for (Enum enum_ : BlockChain.EnumType.values()) {
            this.chainRecipe((BlockChain.EnumType)enum_, registry);
        }
        for (Enum enum_ : EnumDyeColor.values()) {
            this.deckPrismRecipe((EnumDyeColor)enum_, registry);
        }
        if (!OreDictionary.doesOreNameExist((String)"nuggetDwemer") && !OreDictionary.doesOreNameExist((String)"nuggetDawnstone")) {
            GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation(featureName, "chaindwemer"), null, (ItemStack)new ItemStack(this.chainVarious, 1, BlockChain.EnumType.DWEMER.getMetadata()), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(this.chainVarious, 1, (OreDictionary.doesOreNameExist((String)"nuggetBronze") ? BlockChain.EnumType.BRONZE : BlockChain.EnumType.GOLD).getMetadata())})});
        }
        for (Enum enum_ : EnumMaterial.values()) {
            this.gargoyleDemonRecipe((EnumMaterial)enum_);
        }
    }

    @Override
    public void init() {
        Lists.newArrayList((Object[])BlockGlassStained.EnumType.values()).forEach(type -> FMLInterModComms.sendMessage((String)"chisel", (String)"variation:add", (String)("cathedralglass|" + this.glassStained.getRegistryName() + "|" + type.getMetadata())));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerColorHandlers() {
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, world, pos, tint) -> ((BlockChain.EnumType)((Object)state.func_177229_b(BlockChain.VARIANT))).getColor(), new Block[]{this.chainVarious});
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tint) -> BlockChain.EnumType.byMetadata(stack.func_77952_i()).getColor(), new Item[]{Item.func_150898_a((Block)this.chainVarious)});
        Minecraft.func_71410_x().getItemColors().func_186730_a((stack, tint) -> tint == 0 ? EnumDyeColor.func_176764_b((int)stack.func_77960_j()).func_193350_e() : -1, new Item[]{Item.func_150898_a((Block)this.deckPrism)});
    }

    @Override
    public void postInit() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        BiConsumer<Block, IVariantEnumType> reg = (block, type) -> ModelHelper.regModel(Item.func_150898_a((Block)block), type.getMetadata(), new ResourceLocation(featureName, block.getRegistryName().func_110623_a() + "." + type.getUnlocalizedName()));
        Lists.newArrayList((Object[])BlockGlassStained.EnumType.values()).forEach(type -> reg.accept(this.glassStained, (IVariantEnumType)type));
        Lists.newArrayList((Object[])BlockGlassStained.EnumType.values()).forEach(type -> reg.accept(this.panesStained, (IVariantEnumType)type));
        Lists.newArrayList((Object[])EnumMaterial.values()).forEach(type -> reg.accept(this.railingVarious, (IVariantEnumType)type));
        Lists.newArrayList((Object[])BlockChain.EnumType.values()).forEach(type -> reg.accept(this.chainVarious, (IVariantEnumType)type));
        Lists.newArrayList((Object[])EnumMaterial.values()).forEach(type -> reg.accept(this.pillarVarious, (IVariantEnumType)type));
        Lists.newArrayList((Object[])EnumDyeColor.values()).forEach(color -> ModelHelper.regModel(Item.func_150898_a((Block)this.deckPrism), color.func_176767_b()));
        for (BlockGargoyle gargoyleBlock : this.gargoyleDemon) {
            ModelHelper.regModel(gargoyleBlock);
        }
        this.setupCustomModel(this.railingVarious, RAILING, resloc -> new ModelBlockRailing((ResourceLocation)resloc));
        this.setupCustomModel(this.pillarVarious, PILLAR, resloc -> new ModelBlockPillar((ResourceLocation)resloc));
    }

    @SideOnly(value=Side.CLIENT)
    public void setupCustomModel(Block block, String resName, @Nonnull Function<ResourceLocation, IModel> loader) {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new ModelLoaderKeyed(resName, loader));
        Function<EnumMaterial, ModelResourceLocation> resMaker = mat -> new ExtendedModelResourceLocation(featureName, resName, mat.func_176610_l(), resName);
        Map<EnumMaterial, ModelResourceLocation> matModelMap = Lists.newArrayList((Object[])EnumMaterial.values()).stream().collect(Collectors.toMap(mat -> mat, resMaker));
        IStateMapper mapper = blk -> blk.func_176194_O().func_177619_a().stream().collect(Collectors.toMap(b -> b, b -> (ModelResourceLocation)matModelMap.get(b.func_177229_b(EnumMaterial.VARIANT))));
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }

    @SideOnly(value=Side.CLIENT)
    public void setGenericStateMapper(Block block, ModelResourceLocation modelLocation) {
        ModelLoader.setCustomStateMapper((Block)block, state -> block.func_176194_O().func_177619_a().stream().collect(Collectors.toMap(b -> b, b -> modelLocation)));
    }
}

