/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.features.cathedral;

import com.ferreusveritas.cathedral.CathedralMod;
import com.ferreusveritas.cathedral.features.cathedral.EnumMaterial;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRailing
extends Block {
    public static final String name = "railing";
    public static final Properties.PropertyAdapter<Boolean> POSTCAP = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"postcap"));
    public static final Properties.PropertyAdapter<Boolean> POST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)"post"));
    public static final Properties.PropertyAdapter<Boolean> NORTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)EnumFacing.NORTH.func_176610_l()));
    public static final Properties.PropertyAdapter<Boolean> SOUTH = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)EnumFacing.SOUTH.func_176610_l()));
    public static final Properties.PropertyAdapter<Boolean> WEST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)EnumFacing.WEST.func_176610_l()));
    public static final Properties.PropertyAdapter<Boolean> EAST = new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)EnumFacing.EAST.func_176610_l()));
    protected static final AxisAlignedBB[] AABB_BY_INDEX = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.3125, 1.0, 1.0, 0.6875), new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75)};
    protected static final AxisAlignedBB[] CLIP_AABB_BY_INDEX = new AxisAlignedBB[]{AABB_BY_INDEX[0].func_186666_e(1.5), AABB_BY_INDEX[1].func_186666_e(1.5), AABB_BY_INDEX[2].func_186666_e(1.5), AABB_BY_INDEX[3].func_186666_e(1.5), AABB_BY_INDEX[4].func_186666_e(1.5), AABB_BY_INDEX[5].func_186666_e(1.5), AABB_BY_INDEX[6].func_186666_e(1.5), AABB_BY_INDEX[7].func_186666_e(1.5), AABB_BY_INDEX[8].func_186666_e(1.5), AABB_BY_INDEX[9].func_186666_e(1.5), AABB_BY_INDEX[10].func_186666_e(1.5), AABB_BY_INDEX[11].func_186666_e(1.5), AABB_BY_INDEX[12].func_186666_e(1.5), AABB_BY_INDEX[13].func_186666_e(1.5), AABB_BY_INDEX[14].func_186666_e(1.5), AABB_BY_INDEX[15].func_186666_e(1.5), AABB_BY_INDEX[16]};

    public BlockRailing() {
        this(name);
    }

    public BlockRailing(String name) {
        super(Material.field_151576_e);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumMaterial.VARIANT, (Comparable)((Object)EnumMaterial.STONE)));
        this.func_149647_a(CathedralMod.tabCathedral);
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{EnumMaterial.VARIANT};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{POST, NORTH, SOUTH, WEST, EAST, POSTCAP};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState retval = (IExtendedBlockState)state;
            retval = retval.withProperty(POST, (Object)false).withProperty(NORTH, (Object)false).withProperty(EAST, (Object)false).withProperty(SOUTH, (Object)false).withProperty(WEST, (Object)false).withProperty(POSTCAP, (Object)false);
            boolean n = this.canRailConnectTo(world, pos, EnumFacing.NORTH);
            boolean e = this.canRailConnectTo(world, pos, EnumFacing.EAST);
            boolean s = this.canRailConnectTo(world, pos, EnumFacing.SOUTH);
            boolean w = this.canRailConnectTo(world, pos, EnumFacing.WEST);
            boolean up = this.canRailConnectTo(world, pos, EnumFacing.UP);
            boolean centerPole = !(n && s && !e && !w || !n && !s && e && w);
            boolean railbelow = world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockRailing;
            if (!(w || e || s || n)) {
                if (up) {
                    return retval.withProperty(POST, (Object)true);
                }
                if (railbelow) {
                    return retval.withProperty(POSTCAP, (Object)true);
                }
            }
            return retval.withProperty(POST, (Object)(centerPole || up ? 1 : 0)).withProperty(NORTH, (Object)n).withProperty(EAST, (Object)e).withProperty(SOUTH, (Object)s).withProperty(WEST, (Object)w).withProperty(POSTCAP, (Object)false);
        }
        return state;
    }

    private boolean canConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d(world, pos, facing);
        boolean flag = blockfaceshape == BlockFaceShape.MIDDLE_POLE_THICK || blockfaceshape == BlockFaceShape.MIDDLE_POLE && block instanceof BlockFenceGate;
        return !BlockRailing.isExceptionBlockForAttachWithPiston(block) && blockfaceshape == BlockFaceShape.SOLID || flag;
    }

    protected static boolean isExceptionBlockForAttachWithPiston(Block block) {
        return Block.func_193382_c((Block)block) || block == Blocks.field_180401_cv || block == Blocks.field_150440_ba || block == Blocks.field_150423_aK || block == Blocks.field_150428_aP;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block connector = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return connector instanceof BlockWall || connector instanceof BlockFenceGate || connector instanceof BlockRailing;
    }

    private boolean canRailConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos other = pos.func_177972_a(facing);
        Block block = world.func_180495_p(other).func_177230_c();
        return block.canBeConnectedTo(world, other, facing.func_176734_d()) || this.canConnectTo(world, other, facing.func_176734_d());
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE_THICK : BlockFaceShape.CENTER_BIG;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(EnumMaterial.VARIANT, (Comparable)((Object)EnumMaterial.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMaterial)((Object)state.func_177229_b(EnumMaterial.VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumMaterial)((Object)state.func_177229_b(EnumMaterial.VARIANT))).getMetadata();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumMaterial type : EnumMaterial.values()) {
            items.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess access, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN ? super.func_176225_a(state, access, pos, side) : true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        return AABB_BY_INDEX[BlockRailing.getAABBIndex((IExtendedBlockState)this.getExtendedState(state, access, pos))];
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockRailing.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CLIP_AABB_BY_INDEX[BlockRailing.getAABBIndex((IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)world, pos))]);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        return CLIP_AABB_BY_INDEX[BlockRailing.getAABBIndex((IExtendedBlockState)this.getExtendedState(state, access, pos))];
    }

    private static int getAABBIndex(IExtendedBlockState state) {
        int i = 0;
        if (((Boolean)state.getValue(POSTCAP)).booleanValue()) {
            return 16;
        }
        if (((Boolean)state.getValue(NORTH)).booleanValue()) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (((Boolean)state.getValue(EAST)).booleanValue()) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (((Boolean)state.getValue(SOUTH)).booleanValue()) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (((Boolean)state.getValue(WEST)).booleanValue()) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return i;
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        return ((EnumMaterial)((Object)blockState.func_177229_b(EnumMaterial.VARIANT))).getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return ((EnumMaterial)((Object)world.func_180495_p(pos).func_177229_b(EnumMaterial.VARIANT))).getExplosionResistance(exploder);
    }
}

