/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral;

import com.ferreusveritas.cathedral.features.IFeature;
import com.ferreusveritas.cathedral.features.basalt.Basalt;
import com.ferreusveritas.cathedral.features.basalt.BlockBasalt;
import com.ferreusveritas.cathedral.features.cathedral.Cathedral;
import com.ferreusveritas.cathedral.features.dwarven.Dwarven;
import com.ferreusveritas.cathedral.features.dwarven.FeatureTypes;
import com.ferreusveritas.cathedral.features.extras.Extras;
import com.ferreusveritas.cathedral.features.roofing.Roofing;
import com.ferreusveritas.cathedral.proxy.CommonProxy;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(modid="cathedral", version="1.12.2-1.9.9", dependencies="required-after:chisel;after:thermalfoundation", acceptedMinecraftVersions="[1.12.2]")
public class CathedralMod {
    public static Cathedral cathedral;
    public static Basalt basalt;
    public static Dwarven dwarven;
    public static Extras extras;
    public static Roofing roofing;
    public static ArrayList<IFeature> features;
    @Mod.Instance(value="cathedral")
    public static CathedralMod instance;
    @SidedProxy(clientSide="com.ferreusveritas.cathedral.proxy.ClientProxy", serverSide="com.ferreusveritas.cathedral.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final CreativeTabs tabBasalt;
    public static final CreativeTabs tabCathedral;
    public static final CreativeTabs tabDwemer;
    public static final CreativeTabs tabRoofing;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        features.forEach(f -> f.preInit());
        features.forEach(f -> f.createBlocks());
        features.forEach(f -> f.createItems());
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        features.forEach(f -> f.init());
        features.forEach(f -> f.registerColorHandlers());
        proxy.init();
    }

    @Mod.EventHandler
    public void PostInit(FMLPostInitializationEvent e) {
        features.forEach(f -> f.postInit());
    }

    static {
        features = new ArrayList();
        cathedral = new Cathedral();
        basalt = new Basalt();
        dwarven = new Dwarven();
        extras = new Extras();
        roofing = new Roofing();
        Collections.addAll(features, cathedral, basalt, dwarven, extras, roofing);
        tabBasalt = new CreativeTabs("tabBasalt"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack(CathedralMod.basalt.blockCarved, 1, BlockBasalt.EnumType.POISON.getMetadata());
            }
        };
        tabCathedral = new CreativeTabs("tabCathedral"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack(CathedralMod.cathedral.railingVarious);
            }
        };
        tabDwemer = new CreativeTabs("tabDwemer"){

            public ItemStack func_78016_d() {
                return new ItemStack(CathedralMod.dwarven.blockCarved, 1, FeatureTypes.EnumCarvedType.EMBEDDED.getMetadata());
            }
        };
        tabRoofing = new CreativeTabs("tabRoofing"){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)CathedralMod.roofing.roofingShinglesStairsNatural, 1);
            }
        };
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            features.forEach(f -> f.registerBlocks((IForgeRegistry<Block>)event.getRegistry()));
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            features.forEach(f -> f.registerItems((IForgeRegistry<Item>)event.getRegistry()));
        }

        @SubscribeEvent
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            features.forEach(f -> f.registerRecipes((IForgeRegistry<IRecipe>)event.getRegistry()));
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public static void registerModels(ModelRegistryEvent event) {
            OBJLoader.INSTANCE.addDomain("cathedral");
            features.forEach(f -> f.registerModels(event));
        }

        @SubscribeEvent
        public static void newRegistry(RegistryEvent.NewRegistry event) {
        }
    }
}

