/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.tileentity;

import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.dawnoftimebuilder.items.IItemCanBeDried;
import org.dawnoftimebuilder.registries.DoTBItemsRegistry;

public class DoTBTileEntityDryer
extends TileEntity
implements ITickable {
    private IItemCanBeDried[] undriedItem = new IItemCanBeDried[2];
    private int[] craftingTimes = new int[2];
    private int[] currentTimes = new int[2];
    private int tickCount = 0;

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            ++this.tickCount;
            if (this.tickCount == 20) {
                IBlockState state;
                this.tickCount = 0;
                if (this.craftingTimes[0] > this.currentTimes[0]) {
                    this.currentTimes[0] = this.currentTimes[0] + 1;
                    if (this.craftingTimes[0] == this.currentTimes[0]) {
                        state = this.field_145850_b.func_180495_p(this.field_174879_c);
                        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
                    }
                }
                if (this.craftingTimes[1] > this.currentTimes[1]) {
                    this.currentTimes[1] = this.currentTimes[1] + 1;
                    if (this.craftingTimes[1] == this.currentTimes[1]) {
                        state = this.field_145850_b.func_180495_p(this.field_174879_c);
                        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
                    }
                }
            }
        }
    }

    public void upgrade(DoTBTileEntityDryer oldTileEntity) {
        this.undriedItem = oldTileEntity.undriedItem;
        this.craftingTimes = oldTileEntity.craftingTimes;
        this.currentTimes = oldTileEntity.currentTimes;
    }

    public boolean containsItemInSlot(int index) {
        return this.undriedItem[index] != null;
    }

    public IBakedModel getItemCustomModel(int index) {
        String name = this.currentTimes[index] >= this.craftingTimes[index] ? Objects.requireNonNull(this.undriedItem[index].getDriedItem().getRegistryName()).func_110623_a() : Objects.requireNonNull(this.undriedItem[index].getItem().getRegistryName()).func_110623_a();
        return DoTBItemsRegistry.getModel(name);
    }

    public boolean putUndriedItem(IItemCanBeDried item, boolean simple, World worldIn, BlockPos pos) {
        if (this.putItemInFreeSpace(item, simple)) {
            return true;
        }
        if (simple) {
            if (this.itemIsDried(0)) {
                this.dropItemIndex(0, true, worldIn, pos);
                this.putItemIndex(0, item);
                return true;
            }
            return false;
        }
        int index = this.dropOneDriedItem(worldIn, pos);
        if (index < 0) {
            return false;
        }
        this.putItemIndex(index, item);
        return true;
    }

    public boolean dropOneItem(World worldIn, BlockPos pos) {
        if (this.dropOneDriedItem(worldIn, pos) > -1) {
            return true;
        }
        if (this.undriedItem[0] != null) {
            this.dropItemIndex(0, false, worldIn, pos);
            return true;
        }
        if (this.undriedItem[1] != null) {
            this.dropItemIndex(1, false, worldIn, pos);
            return true;
        }
        return false;
    }

    public int dropOneDriedItem(World worldIn, BlockPos pos) {
        if (this.itemIsDried(0)) {
            this.dropItemIndex(0, true, worldIn, pos);
            return 0;
        }
        if (this.itemIsDried(1)) {
            this.dropItemIndex(1, true, worldIn, pos);
            return 1;
        }
        return -1;
    }

    private boolean itemIsDried(int index) {
        if (this.undriedItem[index] == null) {
            return false;
        }
        return this.currentTimes[index] == this.craftingTimes[index];
    }

    private boolean putItemInFreeSpace(IItemCanBeDried item, boolean simple) {
        if (this.undriedItem[0] == null) {
            this.putItemIndex(0, item);
            return true;
        }
        if (!simple && this.undriedItem[1] == null) {
            this.putItemIndex(1, item);
            return true;
        }
        return false;
    }

    private void putItemIndex(int index, IItemCanBeDried item) {
        this.undriedItem[index] = item;
        this.currentTimes[index] = 0;
        this.craftingTimes[index] = (int)((double)item.getDryingTime() * (0.8 + (double)new Random().nextInt(5) * 0.1));
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    private void dropItemIndex(int index, boolean isDried, World worldIn, BlockPos pos) {
        Item item = isDried ? this.undriedItem[index].getDriedItem() : this.undriedItem[index].getItem();
        int quantity = isDried ? this.undriedItem[index].getDriedItemQuantity() : this.undriedItem[index].getItemQuantity();
        for (int i = 0; i < quantity; ++i) {
            Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(item, 1));
        }
        this.resetIndex(index);
    }

    private void resetIndex(int index) {
        this.undriedItem[index] = null;
        this.craftingTimes[index] = 0;
        this.currentTimes[index] = 0;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.handleUpdateTag(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        for (int index = 0; index < 2; ++index) {
            this.undriedItem[index] = compound.func_150297_b("id_" + index, 8) ? (IItemCanBeDried)Item.func_111206_d((String)compound.func_74779_i("id_" + index)) : null;
            this.craftingTimes[index] = compound.func_74762_e("crafting_time_" + index);
            this.currentTimes[index] = compound.func_74762_e("current_time_" + index);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        for (int index = 0; index < 2; ++index) {
            ResourceLocation resourcelocation;
            if (this.undriedItem[index] != null && (resourcelocation = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.undriedItem[index].getItem())) != null) {
                nbt.func_74778_a("id_" + index, resourcelocation.toString());
            }
            nbt.func_74768_a("crafting_time_" + index, (int)((short)this.craftingTimes[index]));
            nbt.func_74768_a("current_time_" + index, (int)((short)this.currentTimes[index]));
        }
        return nbt;
    }
}

