/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.registries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.dawnoftimebuilder.DoTBConfigs;
import org.dawnoftimebuilder.blocks.IBlockMeta;
import org.dawnoftimebuilder.enums.IEnumMetaVariants;
import org.dawnoftimebuilder.items.IItemCanBeDried;
import org.dawnoftimebuilder.items.egyptian.ItemPharaohArmor;
import org.dawnoftimebuilder.items.french.ItemIronPlateArmor;
import org.dawnoftimebuilder.items.general.DoTBItem;
import org.dawnoftimebuilder.items.general.DoTBItemCanBeDried;
import org.dawnoftimebuilder.items.general.DoTBItemHat;
import org.dawnoftimebuilder.items.japanese.ItemJapaneseLightArmor;
import org.dawnoftimebuilder.items.japanese.ItemOYoroiArmor;
import org.dawnoftimebuilder.items.japanese.ItemRaijinArmor;
import org.dawnoftimebuilder.items.japanese.ItemTachiSword;

public class DoTBItemsRegistry {
    public static List<Item> items_list = new ArrayList<Item>();
    private static final HashMap<String, IBakedModel> CUSTOM_MODELS = new HashMap();

    private static void addToList(Item ... items) {
        Collections.addAll(items_list, items);
    }

    public static IBakedModel getModel(String name) {
        return CUSTOM_MODELS.get(name);
    }

    public static void init() {
        DoTBItem silk_worms = new DoTBItem("silk_worms");
        DoTBItem tea_leaves = new DoTBItem("tea_leaves");
        DoTBItemsRegistry.addToList(new Item[]{new ItemIronPlateArmor(EntityEquipmentSlot.FEET), new ItemIronPlateArmor(EntityEquipmentSlot.CHEST), new ItemIronPlateArmor(EntityEquipmentSlot.HEAD), new ItemIronPlateArmor(EntityEquipmentSlot.LEGS), new DoTBItem("wax"), new DoTBItemHat("bamboo_hat"), new DoTBItem("grey_tile"), new DoTBItem("grey_clay_tile"), new DoTBItem("mulberry_leaves"), new DoTBItemCanBeDried("silk_worm_hatchery", 1, 60, silk_worms, 1), silk_worms, new DoTBItemCanBeDried("camellia_leaves", 1, 40, tea_leaves, 1), tea_leaves, new DoTBItem("silk_worm_eggs"), new DoTBItem("silk_cocoons"), new DoTBItem("silk"), new ItemJapaneseLightArmor(EntityEquipmentSlot.FEET), new ItemJapaneseLightArmor(EntityEquipmentSlot.CHEST), new ItemJapaneseLightArmor(EntityEquipmentSlot.HEAD), new ItemJapaneseLightArmor(EntityEquipmentSlot.LEGS), new ItemOYoroiArmor(EntityEquipmentSlot.FEET), new ItemOYoroiArmor(EntityEquipmentSlot.CHEST), new ItemOYoroiArmor(EntityEquipmentSlot.HEAD), new ItemOYoroiArmor(EntityEquipmentSlot.LEGS), new ItemPharaohArmor(EntityEquipmentSlot.FEET), new ItemPharaohArmor(EntityEquipmentSlot.CHEST), new ItemPharaohArmor(EntityEquipmentSlot.HEAD), new ItemPharaohArmor(EntityEquipmentSlot.LEGS), new ItemRaijinArmor(EntityEquipmentSlot.FEET), new ItemRaijinArmor(EntityEquipmentSlot.CHEST), new ItemRaijinArmor(EntityEquipmentSlot.HEAD), new ItemRaijinArmor(EntityEquipmentSlot.LEGS), new ItemTachiSword()});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        for (Item item : items_list) {
            if (DoTBConfigs.enabledMap.containsKey(Objects.requireNonNull(item.getRegistryName()).func_110623_a()) && !DoTBConfigs.enabledMap.get(Objects.requireNonNull(item.getRegistryName()).func_110623_a()).booleanValue()) continue;
            registry.register((IForgeRegistryEntry)item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemsModels() {
        for (Item item : items_list) {
            Block block;
            if (item instanceof ItemBlock && (block = ((ItemBlock)item).func_179223_d()) instanceof IBlockMeta) {
                IBlockMeta blockMeta = (IBlockMeta)block;
                for (IEnumMetaVariants variant : blockMeta.getVariants()) {
                    DoTBItemsRegistry.setResourceLocation(item, variant.getMetadata(), variant.func_176610_l());
                }
                continue;
            }
            DoTBItemsRegistry.setResourceLocation(item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void setResourceLocation(Item item) {
        DoTBItemsRegistry.setResourceLocation(item, 0, new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()).toString(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void setResourceLocation(Item item, int meta, String variant) {
        DoTBItemsRegistry.setResourceLocation(item, meta, new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()).toString() + "_" + variant, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    private static void setResourceLocation(Item item, int meta, ModelResourceLocation location) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)location);
        if (item instanceof IItemCanBeDried) {
            DoTBItemsRegistry.preInitCustomModels("dryer", location.func_110623_a());
            DoTBItemsRegistry.preInitCustomModels("dryer", Objects.requireNonNull(((IItemCanBeDried)item).getDriedItem().getRegistryName()).func_110623_a());
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void preInitCustomModels(String path, String name) {
        CUSTOM_MODELS.put(path + "/" + name, null);
    }

    @SideOnly(value=Side.CLIENT)
    public static void initCustomModels() {
        HashMap<String, IBakedModel> models = new HashMap<String, IBakedModel>();
        for (String path : CUSTOM_MODELS.keySet()) {
            IModel imodel = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)new ResourceLocation("dawnoftimebuilder", path));
            IBakedModel ibakedmodel = imodel.bake(imodel.getDefaultState(), DefaultVertexFormats.field_176600_a, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
            models.put(path.split("/")[1], ibakedmodel);
        }
        CUSTOM_MODELS.clear();
        CUSTOM_MODELS.putAll(models);
    }
}

