/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.mayan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dawnoftimebuilder.DoTBUtils;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;

public class BlockSerpentSculptedColumn
extends DoTBBlock {
    private static final PropertyInteger PILLAR = PropertyInteger.func_177719_a((String)"pillar", (int)0, (int)3);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final AxisAlignedBB HEAD_NORTH_AABB = new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 0.6875, 0.5625);
    private static final AxisAlignedBB TAIL_NORTH_AABB = new AxisAlignedBB(0.3125, 0.0, 0.625, 0.6875, 1.0, 1.0);
    private static final AxisAlignedBB SMALL_TAIL_NORTH_AABB = new AxisAlignedBB(0.3125, 0.0, 0.625, 0.6875, 0.375, 1.0);
    private static final AxisAlignedBB END_TAIL_NORTH_AABB = new AxisAlignedBB(0.3125, 0.625, 0.0625, 0.6875, 1.0, 0.625);

    public BlockSerpentSculptedColumn() {
        super("serpent_sculpted_column", Material.field_151576_e, 1.5f, SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, PILLAR});
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (!p_185477_7_) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        for (AxisAlignedBB axisalignedbb : BlockSerpentSculptedColumn.getCollisionBoxList(state)) {
            BlockSerpentSculptedColumn.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return DoTBUtils.getMainAABB(BlockSerpentSculptedColumn.getCollisionBoxList(this.func_176221_a(state, source, pos)));
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch ((Integer)state.func_177229_b((IProperty)PILLAR)) {
            default: {
                list.add(DoTBUtils.getRotatedAABB(TAIL_NORTH_AABB, facing));
                list.add(DoTBUtils.getRotatedAABB(END_TAIL_NORTH_AABB, facing));
                break;
            }
            case 1: {
                list.add(DoTBUtils.getRotatedAABB(TAIL_NORTH_AABB, facing));
                break;
            }
            case 3: {
                list.add(DoTBUtils.getRotatedAABB(HEAD_NORTH_AABB, facing));
                list.add(DoTBUtils.getRotatedAABB(SMALL_TAIL_NORTH_AABB, facing));
                break;
            }
            case 2: {
                list.add(DoTBUtils.getRotatedAABB(TAIL_NORTH_AABB, facing));
                list.add(DoTBUtils.getRotatedAABB(HEAD_NORTH_AABB, facing));
            }
        }
        return list;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)PILLAR, (Comparable)Integer.valueOf(this.getTileIndex(state, worldIn, pos)));
    }

    private int getTileIndex(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean blockDown;
        IBlockState up = worldIn.func_180495_p(pos.func_177984_a());
        IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        boolean blockUp = up.func_177230_c() instanceof BlockSerpentSculptedColumn && up.func_177229_b((IProperty)FACING) == facing;
        boolean bl = blockDown = down.func_177230_c() instanceof BlockSerpentSculptedColumn && down.func_177229_b((IProperty)FACING) == facing;
        return blockUp && blockDown ? 1 : (!blockUp && !blockDown ? 3 : (blockDown ? 0 : 2));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }
}

