/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.mayan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.dawnoftimebuilder.DoTBUtils;
import org.dawnoftimebuilder.blocks.general.DoTBBlock;
import org.dawnoftimebuilder.enums.EnumsBlock;

public class BlockRedSculptedPlasteredStoneFrieze
extends DoTBBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final PropertyEnum<EnumsBlock.EnumStairsShape> SHAPE = PropertyEnum.func_177709_a((String)"shape", EnumsBlock.EnumStairsShape.class);
    private static final AxisAlignedBB AABB_QTR_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 0.5);
    private static final AxisAlignedBB AABB_OCT_NW = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 0.25, 0.5);
    private static final AxisAlignedBB AABB_SPIKE_NORTH = new AxisAlignedBB(0.21875, 0.25, 0.25, 0.78125, 0.8125, 0.4375);
    private static final AxisAlignedBB AABB_SPIKE_NW = new AxisAlignedBB(0.25, 0.25, 0.25, 0.71875, 0.8125, 0.71875);

    public BlockRedSculptedPlasteredStoneFrieze() {
        super("red_sculpted_plastered_stone_frieze", Material.field_151576_e, 1.5f, SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.STRAIGHT)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, SHAPE});
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        if (!p_185477_7_) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        for (AxisAlignedBB axisalignedbb : BlockRedSculptedPlasteredStoneFrieze.getCollisionBoxList(state)) {
            BlockRedSculptedPlasteredStoneFrieze.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return DoTBUtils.getMainAABB(BlockRedSculptedPlasteredStoneFrieze.getCollisionBoxList(this.func_176221_a(state, source, pos)));
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState bstate) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)bstate.func_177229_b((IProperty)FACING);
        EnumsBlock.EnumStairsShape shape = (EnumsBlock.EnumStairsShape)((Object)bstate.func_177229_b(SHAPE));
        switch (shape) {
            default: {
                list.add(DoTBUtils.getRotatedAABB(AABB_QTR_NORTH, facing));
                list.add(DoTBUtils.getRotatedAABB(AABB_SPIKE_NORTH, facing));
                break;
            }
            case OUTER_LEFT: {
                list.add(DoTBUtils.getRotatedAABB(AABB_OCT_NW, facing));
                list.add(DoTBUtils.getRotatedAABB(AABB_SPIKE_NW, facing));
                break;
            }
            case OUTER_RIGHT: {
                list.add(DoTBUtils.getRotatedAABB(AABB_OCT_NW, facing.func_176746_e()));
                list.add(DoTBUtils.getRotatedAABB(AABB_SPIKE_NW, facing.func_176746_e()));
                break;
            }
            case INNER_LEFT: {
                list.add(DoTBUtils.getRotatedAABB(AABB_QTR_NORTH, facing));
                list.add(DoTBUtils.getRotatedAABB(AABB_OCT_NW, facing.func_176735_f()));
                list.add(DoTBUtils.getRotatedAABB(AABB_SPIKE_NORTH, facing));
                list.add(DoTBUtils.getRotatedAABB(AABB_SPIKE_NORTH, facing.func_176735_f()));
                break;
            }
            case INNER_RIGHT: {
                list.add(DoTBUtils.getRotatedAABB(AABB_QTR_NORTH, facing));
                list.add(DoTBUtils.getRotatedAABB(AABB_OCT_NW, facing.func_176734_d()));
                list.add(DoTBUtils.getRotatedAABB(AABB_SPIKE_NORTH, facing));
                list.add(DoTBUtils.getRotatedAABB(AABB_SPIKE_NORTH, facing.func_176746_e()));
            }
        }
        return list;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(SHAPE, (Comparable)((Object)BlockRedSculptedPlasteredStoneFrieze.getRedStoneFriezeShape(state, worldIn, pos)));
    }

    private static EnumsBlock.EnumStairsShape getRedStoneFriezeShape(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing facingAdjacent;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        IBlockState stateAdjacent = worldIn.func_180495_p(pos.func_177972_a(facing));
        if (BlockRedSculptedPlasteredStoneFrieze.isBlockRedStoneFrieze(stateAdjacent) && (facingAdjacent = (EnumFacing)stateAdjacent.func_177229_b((IProperty)FACING)).func_176740_k() != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() && BlockRedSculptedPlasteredStoneFrieze.isDifferentRedStoneFrieze(state, worldIn, pos, facingAdjacent.func_176734_d())) {
            if (facingAdjacent == facing.func_176735_f()) {
                return EnumsBlock.EnumStairsShape.OUTER_LEFT;
            }
            return EnumsBlock.EnumStairsShape.OUTER_RIGHT;
        }
        stateAdjacent = worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d()));
        if (BlockRedSculptedPlasteredStoneFrieze.isBlockRedStoneFrieze(stateAdjacent) && (facingAdjacent = (EnumFacing)stateAdjacent.func_177229_b((IProperty)FACING)).func_176740_k() != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() && BlockRedSculptedPlasteredStoneFrieze.isDifferentRedStoneFrieze(state, worldIn, pos, facingAdjacent)) {
            if (facingAdjacent == facing.func_176735_f()) {
                return EnumsBlock.EnumStairsShape.INNER_LEFT;
            }
            return EnumsBlock.EnumStairsShape.INNER_RIGHT;
        }
        return EnumsBlock.EnumStairsShape.STRAIGHT;
    }

    private static boolean isDifferentRedStoneFrieze(IBlockState p_185704_0_, IBlockAccess p_185704_1_, BlockPos p_185704_2_, EnumFacing p_185704_3_) {
        IBlockState iblockstate = p_185704_1_.func_180495_p(p_185704_2_.func_177972_a(p_185704_3_));
        return !BlockRedSculptedPlasteredStoneFrieze.isBlockRedStoneFrieze(iblockstate) || iblockstate.func_177229_b((IProperty)FACING) != p_185704_0_.func_177229_b((IProperty)FACING);
    }

    private static boolean isBlockRedStoneFrieze(IBlockState state) {
        return state.func_177230_c() instanceof BlockRedSculptedPlasteredStoneFrieze;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.STRAIGHT));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(facing.func_176740_k().func_176720_b() ? EnumFacing.NORTH : facing));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumsBlock.EnumStairsShape shape = (EnumsBlock.EnumStairsShape)((Object)state.func_177229_b(SHAPE));
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (enumfacing.func_176740_k() != EnumFacing.Axis.Z) break;
                switch (shape) {
                    case OUTER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.OUTER_RIGHT));
                    }
                    case OUTER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.OUTER_LEFT));
                    }
                    case INNER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.INNER_LEFT));
                    }
                    case INNER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.INNER_RIGHT));
                    }
                }
                return state.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (enumfacing.func_176740_k() != EnumFacing.Axis.X) break;
                switch (shape) {
                    case OUTER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.OUTER_RIGHT));
                    }
                    case OUTER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.OUTER_LEFT));
                    }
                    case INNER_RIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.INNER_RIGHT));
                    }
                    case INNER_LEFT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180).func_177226_a(SHAPE, (Comparable)((Object)EnumsBlock.EnumStairsShape.INNER_LEFT));
                    }
                    case STRAIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return state;
    }
}

