/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftimebuilder.blocks.mayan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.dawnoftimebuilder.blocks.general.DoTBBlockColumn;
import org.dawnoftimebuilder.enums.EnumsBlock;

public class BlockPlasteredStoneColumn
extends DoTBBlockColumn {
    private static final AxisAlignedBB LONE_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    private static final AxisAlignedBB BOT_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.25, 0.875);
    private static final AxisAlignedBB BOT_COLUMN_AABB = new AxisAlignedBB(0.1875, 0.25, 0.1875, 0.8125, 1.0, 0.8125);
    private static final AxisAlignedBB MID_COLUMN_AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
    private static final AxisAlignedBB TOP_AABB = new AxisAlignedBB(0.0625, 0.5, 0.0625, 0.9375, 1.0, 0.9375);
    private static final AxisAlignedBB TOP_COLUMN_AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.5, 0.8125);

    public BlockPlasteredStoneColumn() {
        super("plastered_stone_column", Material.field_151576_e, 0.8f, SoundType.field_185851_d);
    }

    @Override
    public List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        switch ((EnumsBlock.EnumVerticalConnection)((Object)state.func_177229_b((IProperty)VERTICAL_CONNECTION))) {
            default: {
                list.add(TOP_AABB);
                list.add(TOP_COLUMN_AABB);
                break;
            }
            case BOTH: {
                list.add(MID_COLUMN_AABB);
                break;
            }
            case NONE: {
                list.add(LONE_AABB);
                break;
            }
            case ABOVE: {
                list.add(BOT_AABB);
                list.add(BOT_COLUMN_AABB);
            }
        }
        return list;
    }

    @Override
    public boolean isSameColumn(IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c() instanceof BlockPlasteredStoneColumn;
    }
}

